<?php

error_reporting(E_ALL & ~E_DEPRECATED);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once $_SERVER['DOCUMENT_ROOT'] . '/config.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/helperFunctions/RLE.php'; // include RLE function
require_once $_SERVER['DOCUMENT_ROOT'] . '/helperFunctions/RLEbinary.php'; // include RLE function
require_once $_SERVER['DOCUMENT_ROOT'] . '/helperFunctions/image_to_rgb565.php'; // OG RGB 565 Function
require_once $_SERVER['DOCUMENT_ROOT'] . '/helperFunctions/image_to_rgb565_json.php'; // JSON OUTPUT RGB 565
require_once $_SERVER['DOCUMENT_ROOT'] . '/helperFunctions/image_to_rgb565_json_RLE.php'; // RLE 565 Output function

// RLE Flag set in config
global $runRLE; // needs definition in every functions its used as global so the pointer works to the config file.
global $runRLEbinary;

$output_dir = $_SERVER['DOCUMENT_ROOT'] . "/../../App_Output/BIN/customFcn"; // Output directory
$fontFiles = $_SERVER['DOCUMENT_ROOT'] . '/GDN/functions/fonts/';
require $_SERVER['DOCUMENT_ROOT'] . '/GDN/functions/fonts/drawText.php'; // drawText()

// Generated app: This is the APP
// Created by: guest
// Created at: 2025-02-27 18:06:49
// Execution Interval: 5 minutes

// ----- USER CODE SECTION BEGIN -----

// Initialize canvas and colors
$width = 64;
$height = 32;
$image = imagecreatetruecolor($width, $height);
$black = imagecolorallocate($image, 0, 0, 0);
$white = imagecolorallocate($image, 255, 255, 255);
$red = imagecolorallocate($image, 255, 0, 0);
$green = imagecolorallocate($image, 0, 255, 0);
$blue = imagecolorallocate($image, 0, 0, 255);
$cyan = imagecolorallocate($image, 0, 255, 255);
$yellow = imagecolorallocate($image, 255, 255, 0);
$magenta = imagecolorallocate($image, 255, 0, 255);

// Fill background with black
imagefill($image, 0, 0, $black);

drawText($image, 'GLANCE', 5, 10, 'left', imagecolorallocate($image, 255, 255, 255), $fontFiles . 'bitmap_5x7');
$data = getData('https://api.example.com/data', 'your-api-key');
drawText($image, '125', 5, 10, 'left', imagecolorallocate($image, 255, 255, 255), $fontFiles . 'bitmap_7x16');

    

drawText($image, "Hello", 1, 4, 'left', imagecolorallocate($image, 255, 255, 255), $fontFiles . 'bitmap_5x7');




// ----- USER CODE SECTION END -----


// Save debug image if flag is enabled
$saveImageFlag = true; // Set to true to save a debug PNG of the LED panel
if ($saveImageFlag) {
    $debug_dir = $_SERVER['DOCUMENT_ROOT'] . '../debug_images/';
    if (!is_dir($debug_dir)) {
        mkdir($debug_dir, 0755, true);
    }
    $image_file_path = $debug_dir . '/This is the APP.png';
    imagepng($image, $image_file_path);
    echo "<br>Debug image saved to: $image_file_path";
}
$output_file_path = $output_dir . '/This is the APP';

if(!$runRLEbinary){

    if($runRLE){
        $json_output = image_to_rgb565_json_RLE($image, $String1, $String2);
    } else {
        $json_output = image_to_rgb565_json($image);
    }
    file_put_contents($output_file_path . '.json', $json_output); // Make sure to use the full path
    
    // Echo out the JSON content
    // echo "New JSON Data:\n";
    echo json_encode(json_decode($json_output), JSON_PRETTY_PRINT);
    
} else {
    $image_data = image_to_rgb565($image);
    $bin_file_path = $output_file_path . '.bin'; // Use the provided directory path

    // Generate RLE Binary
    $filename = compressAndSaveImageData($image_data, $bin_file_path);
    if ($filename) {
        echo "File saved successfully: $bin_file_path";
    } else {
        echo "Failed to save file.";
    }
}
imagedestroy($image);

$db = null;

?>