<?php
// Prevent direct access
if (!defined('APP_RUNNING')) {
    header('HTTP/1.0 403 Forbidden');
    exit('Direct access is not allowed.');
}

/**
 * Sanitize user input
 */
function sanitizeInput($input) {
    if (is_array($input)) {
        foreach ($input as $key => $value) {
            $input[$key] = sanitizeInput($value);
        }
        return $input;
    }
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

/**
 * Validate color format (#RRGGBB)
 */
function validateColor($color) {
    if (preg_match('/^#[a-f0-9]{6}$/i', $color)) {
        return $color;
    }
    return '#FFFFFF'; // Default to white if invalid
}

/**
 * Convert hex color to RGB
 */
function hex2rgb($hex) {
    $hex = str_replace('#', '', $hex);
    return array(
        'r' => hexdec(substr($hex, 0, 2)),
        'g' => hexdec(substr($hex, 2, 2)),
        'b' => hexdec(substr($hex, 4, 2))
    );
}

/**
 * Log operation for debugging
 */
function logOperation($operation, $params) {
    // Simple logging
    $logFile = __DIR__ . '/../logs/operations.log';
    $dir = dirname($logFile);
    
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }
    
    $logEntry = date('[Y-m-d H:i:s]') . ' ' . $operation . ': ' . json_encode($params) . PHP_EOL;
    file_put_contents($logFile, $logEntry, FILE_APPEND);
}