<?php
require_once '../../config.php';
session_start();
header('Content-Type: application/json; charset=UTF-8');

// 1) ignore your factory IP
// if ($_SERVER['REMOTE_ADDR'] === '50.185.150.242') {
//     http_response_code(204);
//     exit;
// }

// 2) validate MAC
if (
    empty($_GET['mac']) ||
    !preg_match('/^([0-9A-Fa-f]{2}:){5}[0-9A-Fa-f]{2}$/', $_GET['mac'])
) {
    http_response_code(400);
    exit;
}
$mac = $_GET['mac'];

// 3) compute next session_count
$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (!$con) {
    http_response_code(500);
    exit;
}
$stmt = mysqli_prepare($con, "
   SELECT COALESCE(MAX(session_count),0) + 1
     FROM glance_led_v2_tracking
    WHERE mac_address = ?
");
mysqli_stmt_bind_param($stmt, 's', $mac);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $nextSession);
mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

// 4) pack the caller’s IP
$ipPacked = inet_pton($_SERVER['REMOTE_ADDR']);
if ($ipPacked === false) {
    http_response_code(400);
    exit;
}

// 5) format Eastern time
$dt = new DateTime('now', new DateTimeZone('UTC'));
$dt->setTimezone(new DateTimeZone('America/New_York'));
$fmt = $dt->format('n/j/Y g:i A');

// 6) insert the row
$ins = mysqli_prepare($con, "
  INSERT INTO glance_led_v2_tracking
    (mac_address, ip_address, session_starttime,
     session_count, heartbeat, last_ping_time)
  VALUES (?, ?, ?, ?, 0, ?)
");
mysqli_stmt_bind_param($ins,
  'sssis',
  $mac,
  $ipPacked,
  $fmt,
  $nextSession,
  $fmt
);
mysqli_stmt_execute($ins);
mysqli_stmt_close($ins);
mysqli_close($con);

// 7) emit only a numeric session_id
echo json_encode(
  ['session_id' => (int)$nextSession],
  JSON_NUMERIC_CHECK
);
