<?php
/**
 * Authentication API Endpoint
 */

require_once '../../lib/database.php';
require_once '../../lib/functions.php';

header('Content-Type: application/json');

// Handle POST requests only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['company_key'])) {
    echo json_encode(['success' => false, 'error' => 'Company key required']);
    exit;
}

$companyKey = sanitizeInput($input['company_key']);

// Load company configuration
$config = getCompanyConfig('doordash');

if (!$config) {
    echo json_encode(['success' => false, 'error' => 'Configuration error']);
    exit;
}

// Authenticate
if (authenticateUser($companyKey, $config)) {
    $_SESSION['authenticated'] = true;
    $_SESSION['company'] = 'doordash';
    
    echo json_encode(['success' => true, 'redirect' => '?page=home']);
} else {
    echo json_encode(['success' => false, 'error' => 'Invalid company key']);
}