<?php
// Session reset script
// Place this file at the same level as your other QuickBooks scripts

// Start the session
session_start();

// Clear all session variables
$_SESSION = array();

// If it's desired to kill the session, also delete the session cookie
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Finally, destroy the session
session_destroy();

// Output confirmation message
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Session Reset</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 20px;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        h1 {
            color: #2c3e50;
        }
        .message {
            background-color: #d4edda;
            color: #155724;
            padding: 15px;
            margin-bottom: 20px;
            border: 1px solid #c3e6cb;
            border-radius: 4px;
        }
        .button {
            display: inline-block;
            padding: 10px 15px;
            background-color: #3498db;
            color: white;
            text-decoration: none;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Session Reset</h1>
        <div class="message">
            <p><strong>Your session has been reset successfully.</strong></p>
            <p>All QuickBooks connection data has been cleared from your session.</p>
        </div>
        <a href="index.php" class="button">Return to QuickBooks Connection</a>
        
        <div style="margin-top: 30px;">
            <h3>Troubleshooting Tips:</h3>
            <ol>
                <li>Clear your browser cache and cookies</li>
                <li>Try using a different browser</li>
                <li>Check your QuickBooks Developer Portal settings:
                    <ul>
                        <li>Verify your Client ID and Client Secret</li>
                        <li>Confirm your Redirect URI is correct</li>
                        <li>Make sure your app has the right permissions</li>
                    </ul>
                </li>
                <li>Ensure you're using the correct environment (production vs development)</li>
            </ol>
        </div>
    </div>
</body>
</html>