<?php
// Constants and Configurations
define('MLB_STANDINGS_URL', 'https://site.api.espn.com/apis/v2/sports/baseball/mlb/standings');

// Team Information Mapping with abbreviations, colors, and divisions
$TEAM_INFO = array(
    'LAA' => array('name' => 'Angels', 'colors' => array(186, 0, 33), 'division' => 'AMERICAN'),
    'ARI' => array('name' => 'Dbacks', 'colors' => array(167, 25, 48), 'division' => 'NATIONAL'),
    'BAL' => array('name' => 'Orioles', 'colors' => array(252, 76, 2), 'division' => 'AMERICAN'),
    'BOS' => array('name' => 'Red Sox', 'colors' => array(189, 48, 57), 'division' => 'AMERICAN'),
    'CHC' => array('name' => 'Cubs', 'colors' => array(0, 47, 108), 'division' => 'NATIONAL'),
    'CHW' => array('name' => 'White Sox', 'colors' => array(0, 0, 0), 'division' => 'AMERICAN'),
    'CIN' => array('name' => 'Reds', 'colors' => array(198, 1, 31), 'division' => 'NATIONAL'),
    'CLE' => array('name' => 'Guardians', 'colors' => array(12, 35, 64), 'division' => 'AMERICAN'),
    'COL' => array('name' => 'Rockies', 'colors' => array(51, 0, 111), 'division' => 'NATIONAL'),
    'DET' => array('name' => 'Tigers', 'colors' => array(12, 35, 64), 'division' => 'AMERICAN'),
    'HOU' => array('name' => 'Astros', 'colors' => array(0, 45, 98), 'division' => 'AMERICAN'),
    'KC'  => array('name' => 'Royals', 'colors' => array(0, 32, 91), 'division' => 'AMERICAN'),
    'LAD' => array('name' => 'Dodgers', 'colors' => array(0, 47, 108), 'division' => 'NATIONAL'),
    'WSH' => array('name' => 'Nationals', 'colors' => array(171, 0, 3), 'division' => 'NATIONAL'),
    'NYM' => array('name' => 'Mets', 'colors' => array(0, 45, 114), 'division' => 'NATIONAL'),
    'OAK' => array('name' => 'Athletics', 'colors' => array(0, 56, 49), 'division' => 'AMERICAN'),
    'PIT' => array('name' => 'Pirates', 'colors' => array(253, 184, 39), 'division' => 'NATIONAL'),
    'SD'  => array('name' => 'Padres', 'colors' => array(0, 45, 98), 'division' => 'NATIONAL'),
    'SEA' => array('name' => 'Mariners', 'colors' => array(0, 104, 71), 'division' => 'AMERICAN'),
    'SF'  => array('name' => 'Giants', 'colors' => array(255, 75, 31), 'division' => 'NATIONAL'),
    'STL' => array('name' => 'Cardinals', 'colors' => array(196, 30, 58), 'division' => 'NATIONAL'),
    'TB'  => array('name' => 'Rays', 'colors' => array(9, 43, 94), 'division' => 'AMERICAN'),
    'TEX' => array('name' => 'Rangers', 'colors' => array(2, 45, 92), 'division' => 'AMERICAN'),
    'TOR' => array('name' => 'Blue Jays', 'colors' => array(19, 74, 142), 'division' => 'AMERICAN'),
    'MIN' => array('name' => 'Twins', 'colors' => array(0, 43, 92), 'division' => 'AMERICAN'),
    'PHI' => array('name' => 'Phillies', 'colors' => array(239, 51, 64), 'division' => 'NATIONAL'),
    'ATL' => array('name' => 'Braves', 'colors' => array(186, 12, 47), 'division' => 'NATIONAL'),
    'MIL' => array('name' => 'Brewers', 'colors' => array(19, 46, 94), 'division' => 'NATIONAL'),
    'MIA' => array('name' => 'Marlins', 'colors' => array(0, 0, 139), 'division' => 'NATIONAL'),
    'NYY' => array('name' => 'Yankees', 'colors' => array(12, 35, 64), 'division' => 'AMERICAN'),
);

// Function to get MLB standings with error handling
function get_mlb_standings() {
    $response = file_get_contents(MLB_STANDINGS_URL);
    if ($response === FALSE) {
        echo "Failed to retrieve data from the API.\n";
        return array();
    }

    $data = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo "Error decoding JSON: " . json_last_error_msg() . "\n";
        return array();
    }

    return $data;
}

// Database Connection
require_once '../config.php'; // Adjust the path as needed
session_start();
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

// Fetch Standings Data
$data = get_mlb_standings();
if (empty($data)) {
    echo "No data retrieved.\n";
    exit;
}

// Check structure of data
if (!isset($data['children'])) {
    echo "Data structure does not match expected format.\n";
    echo "<pre>";
    print_r($data);
    echo "</pre>";
    exit;
}

// Process Standings Data and Execute Updates
foreach ($data['children'] as $league) {
    if (!isset($league['standings']['entries'])) {
        echo "No standings entries found in this league.\n";
        continue;
    }

    foreach ($league['standings']['entries'] as $team_entry) {
        $team_abbrev = strtoupper($team_entry['team']['abbreviation']);
        echo "Processing team: $team_abbrev\n"; // Debugging line to log the team abbreviation
        
        if (!isset($TEAM_INFO[$team_abbrev])) {
            echo "Skipping update for $team_abbrev due to missing mapping.\n";
            continue;
        }
        
        $team_name = strtoupper($TEAM_INFO[$team_abbrev]['name']);  // Convert team name to uppercase
        
        // Extract wins and losses
        $wins = 0;
        $losses = 0;
        foreach ($team_entry['stats'] as $stat) {
            if ($stat['name'] == 'wins') {
                $wins = (int) $stat['value'];
            }
            if ($stat['name'] == 'losses') {
                $losses = (int) $stat['value'];
            }
        }

        // Extract ranking (using playoff seed as an example)
        $ranking = 0;
        foreach ($team_entry['stats'] as $stat) {
            if ($stat['name'] == 'playoffSeed') {
                $ranking = (int) $stat['value'];
            }
        }

        $division = $TEAM_INFO[$team_abbrev]['division']; // Get the division from the mapping table
        $colors = $TEAM_INFO[$team_abbrev]['colors'];

        // Validate colors to avoid SQL errors
        if (empty($colors) || count($colors) !== 3) {
            echo "Skipping update for $team_name due to missing colors.\n";
            continue;
        }

        // Construct SQL query
        $query = "UPDATE leader_board SET 
                    current_team = '$team_name', 
                    winLossRecord = '$wins-$losses', 
                    Abbrev = '$team_abbrev',
                    Red = {$colors[0]}, 
                    Green = {$colors[1]}, 
                    Blue = {$colors[2]} 
                  WHERE team_rank = $ranking 
                  AND division = '$division' 
                  AND league = 'MLB';";
                  
        // Echo the query for debugging
        echo "Executing query: $query\n";
        
        // Execute the query
        if (mysqli_query($conn, $query)) {
            echo "Updated $team_name successfully.\n";
        } else {
            echo "Error updating $team_name: " . mysqli_error($conn) . "\n";
        }
    }
}

// Close Database Connection
mysqli_close($conn);
?>
