<?php
// Include the configuration file
require_once '../config.php';

// Initialize SQL database
session_start();
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

// Check the database connection
if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

// API URL for NBA standings
$url = 'https://site.api.espn.com/apis/v2/sports/basketball/nba/standings';

// Initialize a CURL session
$ch = curl_init();

// Set CURL options
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Accept: application/json'
));

// Execute the CURL session and fetch the data
$response = curl_exec($ch);

// Close the CURL session
curl_close($ch);

// Decode the JSON response
$data = json_decode($response, true);

// Check if the response is not null
if ($data === null) {
    echo "Failed to decode JSON.\n";
    echo "Response:\n";
    echo $response;
    exit;
}

/*************** 🌟 START OF HELPER FUNCTIONS 🌟 ***************/

// Function to get the value of a specific stat
function get_stat_value($stats, $name) {
    foreach ($stats as $stat) {
        if ($stat['name'] === $name) {
            return $stat['value'];
        }
    }
    return null;
}

// Function to prepare SQL query for each team
function prepare_sql($team, $division, $team_colors, $teamAbbreviations) {
    $team_id = $team['team']['id'];
    $team_name = $team['team']['name'];
    $team_abbr = $team['team']['abbreviation'];
    $stats = $team['stats'];

    // Handle special cases for team names
    $special_cases = array(
        'Trail Blazers' => 'TRAIL BLAZERS',
        '76ers' => '76ERS',
        'Timberwolves' => 'TIMBERWOLVES'
    );

    // Ensure the team name is uppercase
    $team_name_upper = strtoupper($team_name);

    // Replace special cases
    if (array_key_exists($team_name, $special_cases)) {
        $team_name_upper = $special_cases[$team_name];
    }

    // Extract required stats
    $wins = get_stat_value($stats, 'wins');
    $losses = get_stat_value($stats, 'losses');
    $ranking = get_stat_value($stats, 'playoffSeed');

    // If 'playoffSeed' is not available, use 'rank'
    if ($ranking === null) {
        $ranking = get_stat_value($stats, 'rank');
    }

    // Get team colors
    if (!isset($team_colors[$team_name_upper])) {
        echo "Missing colors for team: $team_name_upper\n";
        return null;
    }
    $color = $team_colors[$team_name_upper];
    $red = $color[0];
    $green = $color[1];
    $blue = $color[2];

    $winLossRecord = "$wins-$losses";

    $query = "UPDATE leader_board SET 
        current_team = '$team_name_upper', 
        winLossRecord = '$winLossRecord', 
        Abbrev = '$team_abbr',
        Red = $red, 
        Green = $green, 
        Blue = $blue 
        WHERE team_rank = $ranking 
        AND league = 'NBA' 
        AND division = '$division';";

    return $query;
}

// Function to add leading zeros
function addZeros($rgb) {
    $rgb = str_pad($rgb, 3, '0', STR_PAD_LEFT);
    return $rgb;
}

/*************** 🌟 END OF HELPER FUNCTIONS 🌟 ***************/

// Define the team colors and abbreviations
$teamColors = array(
    "Hawks" => array(194, 39, 45),
    "Celtics" => array(0, 122, 51),
    "Nets" => array(0, 0, 0),
    "Hornets" => array(29, 17, 96),
    "Bulls" => array(206, 17, 65),
    "Cavaliers" => array(134, 0, 56),
    "Mavericks" => array(0, 43, 92),
    "Nuggets" => array(13, 34, 64),
    "Pistons" => array(0, 43, 92),
    "Warriors" => array(0, 107, 182),
    "Rockets" => array(206, 17, 65),
    "Pacers" => array(0, 45, 98),
    "Clippers" => array(200, 16, 46),
    "Lakers" => array(85, 37, 130),
    "Grizzlies" => array(12, 35, 64),
    "Heat" => array(152, 0, 46),
    "Bucks" => array(0, 71, 27),
    "Timberwolves" => array(12, 35, 64),
    "Pelicans" => array(0, 43, 92),
    "Knicks" => array(0, 107, 182),
    "Thunder" => array(0, 125, 195),
    "Magic" => array(0, 125, 197),
    "76ers" => array(0, 27, 65),
    "Suns" => array(229, 96, 32),
    "Trail Blazers" => array(224, 58, 62),
    "Kings" => array(91, 43, 130),
    "Spurs" => array(196, 206, 211),
    "Raptors" => array(206, 17, 65),
    "Jazz" => array(0, 43, 92),
    "Wizards" => array(0, 43, 92)
);

$teamAbbreviations = array(
    "Hawks" => "ATL",
    "Celtics" => "BOS",
    "Nets" => "BKN",
    "Hornets" => "CHA",
    "Bulls" => "CHI",
    "Cavaliers" => "CLE",
    "Mavericks" => "DAL",
    "Nuggets" => "DEN",
    "Pistons" => "DET",
    "Warriors" => "GS",
    "Rockets" => "HOU",
    "Pacers" => "IND",
    "Clippers" => "LAC",
    "Lakers" => "LAL",
    "Grizzlies" => "MEM",
    "Heat" => "MIA",
    "Bucks" => "MIL",
    "Timberwolves" => "MIN",
    "Pelicans" => "NO",
    "Knicks" => "NY",
    "Thunder" => "OKC",
    "Magic" => "ORL",
    "76ers" => "PHI",
    "Suns" => "PHX",
    "Trail Blazers" => "POR",
    "Kings" => "SAC",
    "Spurs" => "SA",
    "Raptors" => "TOR",
    "Jazz" => "UTAH",
    "Wizards" => "WSH"
);

// Transform team colors and abbreviations to uppercase keys
$team_colors = array();
foreach ($teamColors as $team_name => $colors) {
    $team_name_upper = strtoupper($team_name);
    $team_colors[$team_name_upper] = $colors;
}

// Execute SQL queries for each team and output in HTML table
if (isset($data['children'])) {
    echo "<table border='1'>";
    echo "<tr><th>Team Name</th><th>Win-Loss Record</th><th>Red</th><th>Green</th><th>Blue</th><th>SQL Query</th><th>Status</th></tr>";
    foreach ($data['children'] as $conference) {
        $division = $conference['name'] === 'Eastern Conference' ? 'EASTERN' : 'WESTERN';
        if (isset($conference['standings']) && isset($conference['standings']['entries'])) {
            foreach ($conference['standings']['entries'] as $entry) {
                $query = prepare_sql($entry, $division, $team_colors, $teamAbbreviations);
                if ($query !== null) {
                    $team_name_upper = strtoupper($entry['team']['name']);
                    // Handle special cases
                    $special_cases = array(
                        'Trail Blazers' => 'TRAIL BLAZERS',
                        '76ers' => '76ERS',
                        'Timberwolves' => 'TIMBERWOLVES'
                    );
                    if (array_key_exists($entry['team']['name'], $special_cases)) {
                        $team_name_upper = $special_cases[$entry['team']['name']];
                    }

                    $wins = get_stat_value($entry['stats'], 'wins');
                    $losses = get_stat_value($entry['stats'], 'losses');

                    echo "<tr>";
                    echo "<td>" . $team_name_upper . "</td>";
                    echo "<td>" . $wins . "-" . $losses . "</td>";
                    echo "<td>" . addZeros($team_colors[$team_name_upper][0]) . "</td>";
                    echo "<td>" . addZeros($team_colors[$team_name_upper][1]) . "</td>";
                    echo "<td>" . addZeros($team_colors[$team_name_upper][2]) . "</td>";
                    echo "<td>$query</td>";
                    if (mysqli_query($conn, $query)) {
                        echo "<td>Query executed successfully.</td>";
                    } else {
                        echo "<td>Error executing query: " . mysqli_error($conn) . "</td>";
                    }
                    echo "</tr>";
                } else {
                    echo "<tr><td colspan='7'>Query not generated for team: " . strtoupper($entry['team']['name']) . "</td></tr>";
                }
            }
        }
    }
    echo "</table>";
} else {
    echo "No children data found.\n";
}

// Close the database connection
mysqli_close($conn);
?>
