<?php
// Enable error reporting for debugging (disable these in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once '../config.php'; // Your DB config file


/*************** 🛠️ START OF HELPER FUNCTIONS 🛠️ ***************/

// Function to clear out special characters
function clean($string) {
    $string = str_replace(' ', '-', $string); // Replaces spaces with hyphens.
    return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
}

// Function to download and save an image
function downloadImage($imageUrl, $savePath) {
    $imageData = file_get_contents($imageUrl);
    file_put_contents($savePath, $imageData);
}

// Function to clear a directory of PNGs (except a default one)
function clearDirectory($dirPath) {
    $files = glob($dirPath . '/*.png');
    foreach ($files as $file) {
        if (basename($file) != 'NCAAB_DEFAULT.png') {
            unlink($file);
        }
    }
}

/*************** 🛠️ END OF HELPER FUNCTIONS 🛠️ ***************/

// Connect to the database (only once)
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

if (!$conn) {
    die("Database connection error: " . mysqli_connect_error());
}

// API call for NCAA men's college basketball rankings
$url = 'https://site.api.espn.com/apis/site/v2/sports/basketball/mens-college-basketball/rankings';
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
]);
$result = curl_exec($curl);
$err    = curl_error($curl);
curl_close($curl);
if ($err) {
    die("cURL Error #: " . $err);
}

// Decode the API JSON response
$jsonData = json_decode($result, true);
if (!$jsonData) {
    die("Error decoding JSON: " . json_last_error_msg());
}
if (!isset($jsonData['rankings'][0]['ranks']) || !is_array($jsonData['rankings'][0]['ranks'])) {
    die("No ranks data found.");
}
$apiTeams = $jsonData['rankings'][0]['ranks'];

// Query the database to get the existing Top25 rows ordered by team_rank and then unique_count
$dbQuery = "SELECT unique_count FROM leader_board 
            WHERE division = 'TOP25' AND league = 'NCAAB'
            ORDER BY team_rank ASC, unique_count ASC";
$dbResult = mysqli_query($conn, $dbQuery);
if (!$dbResult) {
    die("Error querying DB: " . mysqli_error($conn));
}
$dbRows = [];
while ($row = mysqli_fetch_assoc($dbResult)) {
    $dbRows[] = $row;
}

// Use the smaller of the two counts (in case they differ)
$updateCount = min(count($dbRows), count($apiTeams));

// Loop over each API team entry and update the corresponding DB row (using unique_count)
for ($i = 0; $i < $updateCount; $i++) {
    $teamData = $apiTeams[$i];
    $unique_count = $dbRows[$i]['unique_count']; // Unique identifier for this row

    // Force a unique ranking from 1 to updateCount (ignoring API's "current" value)
    $team_ranking = $i + 1;
    
    // Extract win-loss record from API
    $winLossRecord  = isset($teamData['recordSummary']) ? $teamData['recordSummary'] : '';

    // Extract team information
    $teamInfo = isset($teamData['team']) ? $teamData['team'] : [];
    $abbrev   = isset($teamInfo['abbreviation']) ? $teamInfo['abbreviation'] : '';
    $current_team = isset($teamInfo['nickname']) ? strtoupper($teamInfo['nickname']) : '';

    // Extract hex color and convert to RGB components
    $hexColor = isset($teamInfo['color']) ? $teamInfo['color'] : '000000';
    list($red, $green, $blue) = sscanf($hexColor, "%02x%02x%02x");

    // Renaming logic (kept as before)
    if ($current_team == "TEXAS A&M") {
        $current_team = "TEX A&M";
    }
    if ($current_team == "TENNESSEE") {
        $current_team = "TENN";
    }
    if ($current_team == "MICHIGAN ST") {
        $current_team = "MICH ST";
    }
    if ($current_team == "MARQUETTE") {
        $current_team = "MARQ";
    }
      if ($current_team == "FLORIDA") {
        $current_team = "FLA";
    }
    $current_team = str_replace("'", "", $current_team);
    $current_team = str_replace("SAINT", "ST", $current_team);



    // Build the UPDATE query using the unique_count as the WHERE clause key.
    // Also update team_rank with the sequential rank (1-25).
    $query = "UPDATE leader_board SET 
                team_rank    = '".$team_ranking."',
                current_team = '".$current_team."',
                winLossRecord= '".$winLossRecord."',
                Abbrev       = '".$abbrev."',
                Red          = '".$red."',
                Green        = '".$green."',
                Blue         = '".$blue."'
              WHERE unique_count = '".$unique_count."'";

    if (!mysqli_query($conn, $query)) {
        echo "Error updating record with unique_count {$unique_count}: " . mysqli_error($conn) . "<br>\n";
    } else {
        echo "Updated record unique_count {$unique_count}: " . $query . "<br>\n";
    }
}

// Close the database connection when done
mysqli_close($conn);
?>
