<?php

require_once '../config.php'; // Adjust the path as needed

// Constants and Configurations
define('NFL_STANDINGS_URL', 'https://site.api.espn.com/apis/v2/sports/football/nfl/standings');

// Corrected Team Information Mapping with abbreviations, colors, and divisions
$TEAM_INFO = array(
    'ARI' => array('name' => 'Cardinals', 'colors' => array(155, 16, 30), 'division' => 'NFC'),
    'ATL' => array('name' => 'Falcons', 'colors' => array(255, 255, 255), 'division' => 'NFC'),
    'BAL' => array('name' => 'Ravens', 'colors' => array(26, 25, 95), 'division' => 'AFC'),
    'BUF' => array('name' => 'Bills', 'colors' => array(0, 51, 141), 'division' => 'AFC'),
    'CAR' => array('name' => 'Panthers', 'colors' => array(0, 133, 202), 'division' => 'NFC'),
    'CHI' => array('name' => 'Bears', 'colors' => array(200, 56, 3), 'division' => 'NFC'),
    'CIN' => array('name' => 'Bengals', 'colors' => array(251, 79, 20), 'division' => 'AFC'),
    'CLE' => array('name' => 'Browns', 'colors' => array(49, 29, 0), 'division' => 'AFC'),
    'DAL' => array('name' => 'Cowboys', 'colors' => array(127, 150, 149), 'division' => 'NFC'),
    'DEN' => array('name' => 'Broncos', 'colors' => array(0, 35, 77), 'division' => 'AFC'),
    'DET' => array('name' => 'Lions', 'colors' => array(0, 118, 182), 'division' => 'NFC'),
    'GB'  => array('name' => 'Packers', 'colors' => array(24, 48, 40), 'division' => 'NFC'),
    'HOU' => array('name' => 'Texans', 'colors' => array(3, 32, 47), 'division' => 'AFC'),
    'IND' => array('name' => 'Colts', 'colors' => array(0, 44, 95), 'division' => 'AFC'),
    'JAX' => array('name' => 'Jaguars', 'colors' => array(0, 103, 120), 'division' => 'AFC'),
    'KC'  => array('name' => 'Chiefs', 'colors' => array(227, 24, 55), 'division' => 'AFC'),
    'LV'  => array('name' => 'Raiders', 'colors' => array(165, 172, 175), 'division' => 'AFC'),
    'LAC' => array('name' => 'Chargers', 'colors' => array(0, 128, 198), 'division' => 'AFC'),
    'LAR' => array('name' => 'Rams', 'colors' => array(0, 53, 148), 'division' => 'NFC'),
    'MIA' => array('name' => 'Dolphins', 'colors' => array(0, 142, 151), 'division' => 'AFC'),
    'MIN' => array('name' => 'Vikings', 'colors' => array(79, 38, 131), 'division' => 'NFC'),
    'NE'  => array('name' => 'Patriots', 'colors' => array(0, 34, 68), 'division' => 'AFC'),
    'NO'  => array('name' => 'Saints', 'colors' => array(211, 188, 141), 'division' => 'NFC'),
    'NYG' => array('name' => 'Giants', 'colors' => array(1, 35, 82), 'division' => 'NFC'),
    'NYJ' => array('name' => 'Jets', 'colors' => array(18, 87, 64), 'division' => 'AFC'),
    'PHI' => array('name' => 'Eagles', 'colors' => array(0, 76, 84), 'division' => 'NFC'),
    'PIT' => array('name' => 'Steelers', 'colors' => array(165, 172, 175), 'division' => 'AFC'),
    'SEA' => array('name' => 'Seahawks', 'colors' => array(0, 34, 68), 'division' => 'NFC'),
    'SF'  => array('name' => '49ers', 'colors' => array(170, 0, 0), 'division' => 'NFC'),
    'TB'  => array('name' => 'Buccaneers', 'colors' => array(213, 10, 10), 'division' => 'NFC'),
    'TEN' => array('name' => 'Titans', 'colors' => array(75, 146, 219), 'division' => 'AFC'),
    'WSH' => array('name' => 'Commanders', 'colors' => array(90, 20, 20), 'division' => 'NFC'),
    'ATL' => array('name' => 'Falcons', 'colors' => array(255, 255, 255), 'division' => 'NFC')
);

// Function to get NFL standings
function get_nfl_standings() {
    $response = file_get_contents(NFL_STANDINGS_URL);
    if ($response === FALSE) {
        echo "Failed to retrieve data.\n";
        return array();
    }
    return json_decode($response, true);
}

// Database Connection

session_start();
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

// Fetch Standings Data
$data = get_nfl_standings();
if (empty($data)) {
    echo "No data retrieved.\n";
    exit;
}

// Process Standings Data and Execute Updates
foreach ($data['children'] as $conference) {
    foreach ($conference['standings']['entries'] as $team_entry) {
        $team_id = strtoupper($team_entry['team']['abbreviation']);
        echo "Processing team: $team_id\n"; // Debugging line to log the team ID
        
        if (!isset($TEAM_INFO[$team_id])) {
            echo "Skipping update for $team_id due to missing mapping.\n";
            continue;
        }
        
        $team_name = $TEAM_INFO[$team_id]['name'];  // Get team name without city
        $wins = $team_entry['stats'][10]['value'];
        $losses = $team_entry['stats'][2]['value'];
        $ranking = $team_entry['stats'][3]['value']; // Assuming ranking is stored in stats[3]
        $division = $TEAM_INFO[$team_id]['division']; // Get the division from the mapping table
        $colors = $TEAM_INFO[$team_id]['colors'];

        // Validate colors to avoid SQL errors
        if (empty($colors) || count($colors) !== 3) {
            echo "Skipping update for $team_name due to missing colors.\n";
            continue;
        }
        $team_name = strtoupper($team_name);  // Convert to uppercase
if($team_name == "COMMANDERS")
{
    $team_name = "COMMDRS";
}

if($team_name == "BUCCANEERS")
{
    $team_name = "BUCS";
}
        // Construct SQL query
        $query = "UPDATE leader_board SET 
                    current_team = '$team_name', 
                    winLossRecord = '$wins-$losses', 
                    Abbrev = '$team_id',
                    Red = {$colors[0]}, 
                    Green = {$colors[1]}, 
                    Blue = {$colors[2]} 
                  WHERE team_rank = $ranking 
                  AND division = '$division' 
                  AND league = 'NFL';";

        // Execute the query
        if (mysqli_query($conn, $query)) {
            // echo "Updated $team_name successfully.\n";
            echo $query; // Add this line before executing the query

        } else {
            echo "Error updating $team_name: " . mysqli_error($conn) . "\n";
        }
    }
}

// Close Database Connection
mysqli_close($conn);

?>
