<?php
// populate_nfl_draft_stubs.php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 1) Load DB credentials
require_once '../../config.php';  

// 2) Connect
$con = new mysqli($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if ($con->connect_error) {
    die("DB connection failed: " . $con->connect_error);
}

// 3) Ensure table exists
$createTableSQL = <<<SQL
CREATE TABLE IF NOT EXISTS `nfl_draft` (
    `pick` INT PRIMARY KEY,
    `overall` INT,
    `round` INT,
    `traded` INT,
    `trade_note` TEXT,
    `name` TEXT,
    `position` VARCHAR(10),
    `college` VARCHAR(100),
    `team` VARCHAR(50),
    `R` INT, `G` INT, `B` INT,
    `R_2` INT, `G_2` INT, `B_2` INT,
    `rank` INT,
    `overall_rank` INT,
    `grade` INT,
    `day1` TINYINT(1),
    `day2` TINYINT(1),
    `day3` TINYINT(1)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
SQL;

if (! $con->query($createTableSQL)) {
    die("Table creation failed: " . $con->error);
}

// 4) Truncate existing stubs
if (! $con->query("TRUNCATE TABLE `nfl_draft`")) {
    die("Truncate failed: " . $con->error);
}

// 5) Define the 21 columns we’ll insert
$cols = [
    'pick', 'overall', 'round', 'traded',
    'trade_note', 'name', 'position', 'college', 'team',
    'R','G','B','R_2','G_2','B_2',
    'rank','overall_rank','grade',
    'day1','day2','day3'
];

// 6) Build dynamic placeholders & SQL
$placeholders = implode(',', array_fill(0, count($cols), '?'));
$sql = sprintf(
    "INSERT INTO `nfl_draft` (%s) VALUES (%s)",
    implode(',', $cols),
    $placeholders
);
$stmt = $con->prepare($sql);
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}

// 7) Build the types string (21 fields)
$types = str_repeat('i', 4)    // pick, overall, round, traded
       . str_repeat('s', 5)    // trade_note, name, position, college, team
       . str_repeat('i', 6)    // R, G, B, R_2, G_2, B_2
       . str_repeat('i', 3)    // rank, overall_rank, grade
       . str_repeat('i', 3);   // day1, day2, day3

// 8) Insert stubs 1–257
$con->begin_transaction();
for ($i = 1; $i <= 257; $i++) {
    if ($i <= 32)       $rnd = 1;
    elseif ($i <= 64)   $rnd = 2;
    elseif ($i <= 96)   $rnd = 3;
    elseif ($i <= 128)  $rnd = 4;
    elseif ($i <= 160)  $rnd = 5;
    elseif ($i <= 192)  $rnd = 6;
    else                $rnd = 7;

    $pick         = $i;
    $overall      = $i;
    $round        = $rnd;
    $traded       = 0;
    $trade_note   = '';
    $name         = '';
    $position     = '';
    $college      = '';
    $team         = '';
    $R = $G = $B = $R2 = $G2 = $B2 = 0;
    $rankVal      = 0;
    $ovrRank      = 0;
    $grade        = 0;
    $day1 = $i <= 32     ? 1 : 0;
    $day2 = $i >= 33 && $i <= 96 ? 1 : 0;
    $day3 = $i >= 97     ? 1 : 0;

    $stmt->bind_param(
        $types,
        $pick, $overall, $round, $traded,
        $trade_note, $name, $position, $college, $team,
        $R, $G, $B, $R2, $G2, $B2,
        $rankVal, $ovrRank, $grade,
        $day1, $day2, $day3
    );
    if (! $stmt->execute()) {
        error_log("Insert failed at pick {$i}: " . $stmt->error);
    }
}
$con->commit();

$stmt->close();
$con->close();

echo "✅ Inserted 257 stub rows into `nfl_draft`.\n";
