<?php
// Include the configuration file
require_once '../config.php';

// Initialize SQL database
session_start();
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

// Check the database connection
if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

// API URL
$url = 'https://site.api.espn.com/apis/v2/sports/hockey/nhl/standings';

// Initialize a CURL session
$ch = curl_init();

// Set CURL options
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Accept: application/json'
));

// Execute the CURL session and fetch the data
$response = curl_exec($ch);

// echo $response;
// Close the CURL session
curl_close($ch);

// Decode the JSON response
$data = json_decode($response, true);

// Check if the response is not null
if ($data === null) {
    echo "Failed to decode JSON.\n";
    echo "Response:\n";
    echo $response;
    exit;
}

// Define the team colors, including Utah Hockey Club
$team_colors = array(
    "DUCKS" => array(188, 189, 193),
    "COYOTES" => array(140, 33, 47),
    "BRUINS" => array(255, 196, 37),
    "SABRES" => array(0, 39, 76),
    "FLAMES" => array(207, 10, 44),
    "HURRICANES" => array(226, 24, 54),
    "B-HAWKS" => array(206, 17, 65),
    "AVALANCHE" => array(111, 38, 61),
    "B-JACKETS" => array(0, 38, 84),
    "STARS" => array(1, 129, 118),
    "R-WINGS" => array(206, 17, 38),
    "OILERS" => array(4, 30, 66),
    "PANTHERS" => array(4, 30, 66),
    "KINGS" => array(0, 0, 0),
    "WILD" => array(1, 71, 35),
    "CANADIENS" => array(175, 30, 45),
    "PREDATORS" => array(255, 184, 28),
    "DEVILS" => array(206, 17, 65),
    "ISLANDERS" => array(0, 39, 76),
    "RANGERS" => array(0, 56, 168),
    "SENATORS" => array(202, 28, 41),
    "FLYERS" => array(247, 148, 29),
    "PENGUINS" => array(252, 181, 0),
    "SHARKS" => array(3, 114, 133),
    "BLUES" => array(0, 47, 108),
    "LIGHTNING" => array(0, 40, 104),
    "LEAFS" => array(0, 45, 114), 
    "CANUCKS" => array(0, 32, 91),
    "G-KNIGHTS" => array(185, 151, 91), 
    "CAPITALS" => array(186, 12, 47),
    "JETS" => array(5, 51, 115),
    "KRAKEN" => array(153, 217, 217),
    "UTAH" => array(0, 128, 128) // Adding Utah Hockey Club
);

$TEAM_INFO = array(
    "DUCKS"      => array('abbrev' => 'ANH', 'colors' => array(188, 189, 193)),
    "COYOTES"    => array('abbrev' => 'ARI', 'colors' => array(140, 33, 47)),
    "BRUINS"     => array('abbrev' => 'BOS', 'colors' => array(255, 196, 37)),
    "SABRES"     => array('abbrev' => 'BUF', 'colors' => array(0, 39, 76)),
    "FLAMES"     => array('abbrev' => 'CGY', 'colors' => array(207, 10, 44)),
    "HURRICANES" => array('abbrev' => 'CAR', 'colors' => array(226, 24, 54)),
    "B-HAWKS"    => array('abbrev' => 'CHI', 'colors' => array(206, 17, 65)),
    "AVALANCHE"  => array('abbrev' => 'COL', 'colors' => array(111, 38, 61)),
    "B-JACKETS"  => array('abbrev' => 'CBJ', 'colors' => array(0, 38, 84)),
    "STARS"      => array('abbrev' => 'DAL', 'colors' => array(1, 129, 118)),
    "R-WINGS"    => array('abbrev' => 'DET', 'colors' => array(206, 17, 38)),
    "OILERS"     => array('abbrev' => 'EDM', 'colors' => array(4, 30, 66)),
    "PANTHERS"   => array('abbrev' => 'FLA', 'colors' => array(4, 30, 66)),
    "KINGS"      => array('abbrev' => 'LA',  'colors' => array(0, 0, 0)),
    "WILD"       => array('abbrev' => 'MIN', 'colors' => array(1, 71, 35)),
    "CANADIENS"  => array('abbrev' => 'MTL', 'colors' => array(175, 30, 45)),
    "PREDATORS"  => array('abbrev' => 'NSH', 'colors' => array(255, 184, 28)),
    "DEVILS"     => array('abbrev' => 'NJ',  'colors' => array(206, 17, 65)),
    "ISLANDERS"  => array('abbrev' => 'NYI', 'colors' => array(0, 39, 76)),
    "RANGERS"    => array('abbrev' => 'NYR', 'colors' => array(0, 56, 168)),
    "SENATORS"   => array('abbrev' => 'OTT', 'colors' => array(202, 28, 41)),
    "FLYERS"     => array('abbrev' => 'PHI', 'colors' => array(247, 148, 29)),
    "PENGUINS"   => array('abbrev' => 'PIT', 'colors' => array(252, 181, 0)),
    "SHARKS"     => array('abbrev' => 'SJ',  'colors' => array(3, 114, 133)),
    "BLUES"      => array('abbrev' => 'STL', 'colors' => array(0, 47, 108)),
    "LIGHTNING"  => array('abbrev' => 'TB',  'colors' => array(0, 40, 104)),
    "LEAFS"      => array('abbrev' => 'TOR', 'colors' => array(0, 45, 114)), // Mapping for MAPLE LEAFS
    "CANUCKS"    => array('abbrev' => 'VAN', 'colors' => array(0, 32, 91)),
    "G-KNIGHTS"  => array('abbrev' => 'VGK', 'colors' => array(185, 151, 91)), // Mapping for GOLDEN KNIGHTS
    "CAPITALS"   => array('abbrev' => 'WSH', 'colors' => array(186, 12, 47)),
    "JETS"       => array('abbrev' => 'WIN', 'colors' => array(5, 51, 115)),
    "KRAKEN"     => array('abbrev' => 'SEA', 'colors' => array(153, 217, 217)),
     "UTAH"       => array('abbrev' => 'UTAH', 'colors' => array(0, 128, 128)) // Adding Utah Hockey Club
);

// Function to get the value of a specific stat
function get_stat_value($stats, $name) {
    foreach ($stats as $stat) {
        if ($stat['name'] === $name) {
            return $stat['displayValue'];
        }
    }
    return null;
}

// Function to prepare SQL query for each team
function prepare_sql($team, $division, $team_colors) {
    $team_id = $team['team']['id'];
    $team_name = $team['team']['name'];
    $team_abbr = $team['team']['abbreviation'];
    $stats = $team['stats'];

    // Handle special cases for team names
    $special_cases = array(
        "BLACKHAWKS" => "B-HAWKS",
        "BLUE JACKETS" => "B-JACKETS",
        "RED WINGS" => "R-WINGS",
        "GOLDEN KNIGHTS" => "G-KNIGHTS",
        "MAPLE LEAFS" => "LEAFS",
        "HOCKEY CLUB" => "UTAH" // Add a case for "Hockey Club" to become "UTAH"
    );

    // Ensure the team name is uppercase
    $team_name_upper = strtoupper($team_name);

    // Replace "Hockey Club" with "UTAH"
    if (array_key_exists($team_name_upper, $special_cases)) {
        $team_name_upper = $special_cases[$team_name_upper];
    }

    // Extract required stats
    $wins = get_stat_value($stats, 'wins');
    $losses = get_stat_value($stats, 'losses');
    $ranking = get_stat_value($stats, 'playoffSeed');

    // Get team colors
    if (!isset($team_colors[$team_name_upper])) {
        echo "Missing colors for team: $team_name_upper\n";
        return null;
    }
    $color = $team_colors[$team_name_upper];
    $red = $color[0];
    $green = $color[1];
    $blue = $color[2];

    $winLossRecord = "$wins-$losses";

    $query = "UPDATE leader_board SET 
        current_team = '$team_name_upper', 
        winLossRecord = '$winLossRecord', 
        Abbrev = '$team_abbr',
        Red = $red, 
        Green = $green, 
        Blue = $blue 
        WHERE team_rank = $ranking 
        AND league = 'NHL' 
        AND division = '$division';";

    return $query;
}


// Execute SQL queries for each team and output in HTML table
if (isset($data['children'])) {
    echo "<table border='1'>";
    echo "<tr><th>Team Name</th><th>Win-Loss Record</th><th>Red</th><th>Green</th><th>Blue</th><th>SQL Query</th><th>Status</th></tr>";
    foreach ($data['children'] as $conference) {
        $division = $conference['name'] === 'Eastern Conference' ? 'EASTERN' : 'WESTERN';
        if (isset($conference['standings']) && isset($conference['standings']['entries'])) {
            foreach ($conference['standings']['entries'] as $entry) {
                $query = prepare_sql($entry, $division, $team_colors);
                if ($query !== null) {
                    echo "<tr>";
                    echo "<td>" . strtoupper($entry['team']['name']) . "</td>";
                    echo "<td>" . get_stat_value($entry['stats'], 'wins') . "-" . get_stat_value($entry['stats'], 'losses') . "</td>";
                    echo "<td>" . $team_colors[strtoupper($entry['team']['name'])][0] . "</td>";
                    echo "<td>" . $team_colors[strtoupper($entry['team']['name'])][1] . "</td>";
                    echo "<td>" . $team_colors[strtoupper($entry['team']['name'])][2] . "</td>";
                    echo "<td>$query</td>";
                    if (mysqli_query($conn, $query)) {
                        echo "<td>Query executed successfully.</td>";
                    } else {
                        echo "<td>Error executing query: " . mysqli_error($conn) . "</td>";
                    }
                    echo "</tr>";
                } else {
                    echo "<tr><td colspan='7'>Query not generated for team: " . strtoupper($entry['team']['name']) . "</td></tr>";
                }
            }
        }
    }
    echo "</table>";
} else {
    echo "No children data found.\n";
}

// Close the database connection
mysqli_close($conn);
?>
