<?php
require_once '../config.php'; // Include the configuration file

$return_game = "FALSE";
try {
    $db = new PDO("mysql:host=$host_gscroll;dbname=$database_gscroll", $username_gscroll, $password_gscroll);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get current time
    $current_time = gmdate("Y-m-d\TH:i\Z");

    // Prepare statement to select all tee times from the database
    $stmt = $db->prepare("SELECT teeTime FROM scoreBoard");
    $stmt->execute();

    // Fetch all rows from the query
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Loop through all rows
    foreach ($rows as $row) {
        // Calculate artificial end time (tee time + 6 hours)
        $startTime = $row['teeTime'];
        $endTime = date('Y-m-d\TH:i\Z', strtotime($startTime . ' +6 hours'));

        // Compare current time to start and end times
        if ($current_time >= $startTime && $current_time <= $endTime && strlen($startTime) > 5) {
            // Game is active
            $return_game = "TRUE";
            break;
        }
    }

    $return_game = array("Return_Game" => $return_game);

    // Output the result
    echo json_encode($return_game);

} catch (PDOException $e) {
    die($e->getMessage());
}
?>
