<?php
require_once '../config.php'; // Include the configuration file
session_start();
$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

$sql = "SELECT * FROM sports_list";
$result = mysqli_query($con, $sql);

echo "
<style>
    table {
        border-collapse: collapse;
        width: 100%;
        font-family: Arial, Helvetica, sans-serif;
    }

    th, td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: center;
    }

    tr:nth-child(even) {background-color: #f2f2f2;}

    th {
        padding-top: 12px;
        padding-bottom: 12px;
        text-align: center;
        background-color: #4CAF50;
        color: white;
    }
</style>
";

echo "<table>";
echo "<tr>";
echo "<th>ID</th>"; 
echo "<th>League</th>";
echo "<th>Conference</th>";
echo "<th>Team 1</th>"; 
echo "<th>Team 2</th>"; 
echo "<th>Game Played</th>";
echo "<th>Hours Difference</th>";
echo "<th>SQL Statement</th>";  
echo "</tr>";

while($row = mysqli_fetch_assoc($result)) {
    $league = $row['League'];
    $gameDate = $row['Game_Date'];
    $team1Name = $row['Team_1_Name'];
    $team2Name = $row['Team_2_Name'];
    $id = $row['ID'];
    $gamePlayed = $row['Game_Played'];
    $Conference = $row['Conference'];
    $gameDateTime = new DateTime($gameDate);
    $now = new DateTime();
    $interval = $now->diff($gameDateTime);
    $hoursDifference = ($interval->days * 24 + $interval->h);
    if($now < $gameDateTime) {
        $hoursDifference *= -1;
    }

    // Existing logic for MLB, NHL, MLS, EPL, NBA, Champion (removed NCAAB)
    if($league == "MLB" || $league == "NHL" || $league == "MLS" || $league == "EPL" || $league == "NBA" || $league == "Champion" || $league == "WNBA") {
        $updateSql = "UPDATE sports_list SET Game_Played = '', Team_1_Name = '', Team_2_Name = '' WHERE ID = " . $id;

        if($hoursDifference >= 14) {
            echo "<tr>";
            echo "<td>" . $id . "</td>"; 
            echo "<td>" . $league . "</td>";
            echo "<td>" . $Conference . "</td>";
            echo "<td>" . $team1Name . "</td>"; 
            echo "<td>" . $team2Name . "</td>"; 
            echo "<td>" . $gamePlayed . "</td>";
            echo "<td>" . $hoursDifference . " hours</td>"; 
            echo "<td>" . $updateSql . "</td>";
            echo "</tr>";

            // Execute the SQL statement
            mysqli_query($con, $updateSql);
        }
    }

    // Updated branch for NCAAB with game age check
    if($league == "NCAAB") {
        if($hoursDifference >= 14) {
            if($team1Name === $team2Name) {
                // Get the max ID for rows with the same NCAAB team names
                $queryMax = "SELECT MAX(ID) as maxID FROM sports_list WHERE League = 'NCAAB' AND Team_1_Name = '" . mysqli_real_escape_string($con, $team1Name) . "' AND Team_2_Name = '" . mysqli_real_escape_string($con, $team2Name) . "'";
                $resultMax = mysqli_query($con, $queryMax);
                $rowMax = mysqli_fetch_assoc($resultMax);
                $maxID = $rowMax['maxID'];
                if($id == $maxID) {
                    $updateSql = "UPDATE sports_list SET Game_Played = '', Team_1_Name = '' WHERE ID = " . $id;
                    echo "<tr>";
                    echo "<td>" . $id . "</td>"; 
                    echo "<td>" . $league . "</td>";
                    echo "<td>" . $Conference . "</td>";
                    echo "<td>" . $team1Name . "</td>"; 
                    echo "<td>" . $team2Name . "</td>"; 
                    echo "<td>" . $gamePlayed . "</td>";
                    echo "<td>" . $hoursDifference . " hours</td>"; 
                    echo "<td>" . $updateSql . "</td>";
                    echo "</tr>";
                    mysqli_query($con, $updateSql);
                } else {
                    // Output row without update if not the max ID
                    echo "<tr>";
                    echo "<td>" . $id . "</td>"; 
                    echo "<td>" . $league . "</td>";
                    echo "<td>" . $Conference . "</td>";
                    echo "<td>" . $team1Name . "</td>"; 
                    echo "<td>" . $team2Name . "</td>"; 
                    echo "<td>" . $gamePlayed . "</td>";
                    echo "<td>" . $hoursDifference . " hours</td>"; 
                    echo "<td></td>";
                    echo "</tr>";
                }
            } else {
                // For non-identical team names, update normally by clearing all three fields.
                $updateSql = "UPDATE sports_list SET Game_Played = '', Team_1_Name = '', Team_2_Name = '' WHERE ID = " . $id;
                echo "<tr>";
                echo "<td>" . $id . "</td>"; 
                echo "<td>" . $league . "</td>";
                echo "<td>" . $Conference . "</td>";
                echo "<td>" . $team1Name . "</td>"; 
                echo "<td>" . $team2Name . "</td>"; 
                echo "<td>" . $gamePlayed . "</td>";
                echo "<td>" . $hoursDifference . " hours</td>"; 
                echo "<td>" . $updateSql . "</td>";
                echo "</tr>";
                mysqli_query($con, $updateSql);
            }
        } else {
            // If game is not older than 14 hours, output row without update.
            echo "<tr>";
            echo "<td>" . $id . "</td>"; 
            echo "<td>" . $league . "</td>";
            echo "<td>" . $Conference . "</td>";
            echo "<td>" . $team1Name . "</td>"; 
            echo "<td>" . $team2Name . "</td>"; 
            echo "<td>" . $gamePlayed . "</td>";
            echo "<td>" . $hoursDifference . " hours</td>"; 
            echo "<td></td>";
            echo "</tr>";
        }
    }

    // New section for NFL and CFB
    if($league == "NFL" || $league == "CFB") {
        $updateSql = "UPDATE sports_list SET Game_Played = '', Team_1_Name = '', Team_2_Name = '' WHERE ID = " . $id;

        if($hoursDifference > 85) {
            echo "<tr>";
            echo "<td>" . $id . "</td>"; 
            echo "<td>" . $league . "</td>";
            echo "<td>" . $Conference . "</td>";
            echo "<td>" . $team1Name . "</td>"; 
            echo "<td>" . $team2Name . "</td>"; 
            echo "<td>" . $gamePlayed . "</td>";
            echo "<td>" . $hoursDifference . " hours</td>"; 
            echo "<td>" . $updateSql . "</td>";
            echo "</tr>";

            // Execute the SQL statement
            mysqli_query($con, $updateSql);
        }
    }
}

echo "</table>";
?>
