<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../config.php';

// ===== Call MegaMillions endpoint =====
$ch = curl_init('https://www.megamillions.com/cmspages/utilservice.asmx/GetLatestDrawData');
curl_setopt_array($ch, [
    CURLOPT_POST            => true,
    CURLOPT_POSTFIELDS      => '',
    CURLOPT_RETURNTRANSFER  => true,
    CURLOPT_FOLLOWLOCATION  => true,
    CURLOPT_TIMEOUT         => 20,
    CURLOPT_HTTPHEADER      => [
        'Content-Type: application/json; charset=UTF-8',
        'Accept: application/json, text/javascript, */*; q=0.01',
        'Origin: https://www.megamillions.com',
        'Referer: https://www.megamillions.com/',
        'X-Requested-With: XMLHttpRequest',
    ],
    CURLOPT_ENCODING        => 'gzip, deflate, br',
]);
$result   = curl_exec($ch);
$err      = curl_error($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($err) die("cURL Error: " . $err);
if ($httpCode !== 200) die("API Error: HTTP " . $httpCode . " | Body: " . substr($result ?? '', 0, 500));

// Outer JSON (ASP.NET style): {"d":"{...real json...}"}
$outer = json_decode($result, true);
if (json_last_error() !== JSON_ERROR_NONE) die("JSON Parse Error (outer): " . json_last_error_msg());

// Extract inner JSON string
$innerJson = $outer['d'] ?? ($outer['string']['#text'] ?? $result);

// Decode the real payload
$data = json_decode($innerJson, true);
if (json_last_error() !== JSON_ERROR_NONE || !is_array($data)) die("JSON Parse Error (inner): " . json_last_error_msg());

// ===== Extract fields =====
$drawing = $data['Drawing'] ?? [];
$jackpot = $data['Jackpot'] ?? [];

// Numbers
$n1 = isset($drawing['N1']) ? intval($drawing['N1']) : null;
$n2 = isset($drawing['N2']) ? intval($drawing['N2']) : null;
$n3 = isset($drawing['N3']) ? intval($drawing['N3']) : null;
$n4 = isset($drawing['N4']) ? intval($drawing['N4']) : null;
$n5 = isset($drawing['N5']) ? intval($drawing['N5']) : null;
$mb = isset($drawing['MBall']) ? intval($drawing['MBall']) : null;

// Format helpers
$fmtDateShort = function($s){ if(!$s) return ''; $ts=strtotime($s); return $ts?date('M j, Y',$ts):trim($s); };
$fmtDateLong  = function($s){ if(!$s) return ''; $ts=strtotime($s); return $ts?date('l, M j, Y',$ts):trim($s); };
$fmtAmount    = function($v){
    if ($v === null || $v === '' || !is_numeric($v)) return '';
    $v = floatval($v);
    if ($v >= 1_000_000_000) return '$' . rtrim(rtrim(number_format($v/1_000_000_000,2),'0'),'.') . ' Billion';
    return '$' . number_format(round($v/1_000_000)) . ' Million';
};

// Current jackpot (date/amount)
$jackpotDate       = $fmtDateShort($drawing['PlayDate'] ?? $jackpot['PlayDate'] ?? '');
$jackpotCurrentAmt = $fmtAmount($jackpot['CurrentPrizePool'] ?? $jackpot['PrizePool'] ?? $jackpot['CurrentJackpot'] ?? null);

// ✅ Next drawing date is at the ROOT level
$jackpotDateNext    = $fmtDateLong($data['NextDrawingDate'] ?? '');
// Next amount from Jackpot
$jackpotDateNextAmt = $fmtAmount($jackpot['NextPrizePool'] ?? $jackpot['NextJackpot'] ?? null);

// Optional last-updated
$lastUpdated = $fmtDateShort($drawing['UpdatedTime'] ?? '');

// Debug (remove in prod)
echo "Mega Millions Data Extracted:\n";
echo "Numbers: $n1, $n2, $n3, $n4, $n5, MB: $mb\n";
echo "Current Jackpot: $jackpotCurrentAmt on $jackpotDate\n";
echo "Next Jackpot: $jackpotDateNextAmt on $jackpotDateNext\n";
if ($lastUpdated) echo "Last Updated: $lastUpdated\n\n";

// Validate
if (in_array(null, [$n1,$n2,$n3,$n4,$n5,$mb], true)) die("ERROR: One or more number values are NULL. Cannot update database.");

// ===== DB I/O (unchanged) =====
session_start();
if (!isset($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll)) die("Database configuration variables not set. Check config.php");

$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (mysqli_connect_errno()) die("Failed to connect to MySQL: " . mysqli_connect_error());

mysqli_autocommit($con, FALSE);

try {
    $delete_query  = "DELETE FROM Lotto WHERE Game = 'MM'";
    $delete_result = mysqli_query($con, $delete_query);
    if (!$delete_result) throw new Exception("Delete failed: " . mysqli_error($con));
    echo "Deleted " . mysqli_affected_rows($con) . " existing MM row(s).\n";

    $insert_query = "INSERT INTO Lotto (Game, n1, n2, n3, n4, n5, MB, jackpotCurrentAmt, jackpotDateNext, jackpotDateNextAmt, jackpotDate) 
                     VALUES ('MM', ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($con, $insert_query);
    if (!$stmt) throw new Exception("Prepare failed: " . mysqli_error($con));

    if (!mysqli_stmt_bind_param($stmt, 'iiiiisssss',
        $n1, $n2, $n3, $n4, $n5, $mb, $jackpotCurrentAmt, $jackpotDateNext, $jackpotDateNextAmt, $jackpotDate
    )) throw new Exception("Binding parameters failed: " . mysqli_stmt_error($stmt));

    if (!mysqli_stmt_execute($stmt)) throw new Exception("Insert failed: " . mysqli_stmt_error($stmt));

    echo "New MM row inserted successfully.\n";
    mysqli_commit($con);
    echo "Transaction committed successfully.\n";
    mysqli_stmt_close($stmt);

} catch (Exception $e) {
    mysqli_rollback($con);
    echo "ERROR: Transaction rolled back - " . $e->getMessage() . "\n";
    die();
}

mysqli_autocommit($con, TRUE);
mysqli_close($con);
session_write_close();

echo "Mega Millions script completed successfully!";
