<?php
// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../config.php'; // Include configuration file

// API Request
$curl = curl_init();

curl_setopt_array($curl, array(
    CURLOPT_URL => "https://api.collectapi.com/chancegame/usaPowerball",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => array(
        "authorization: apikey 4YsfWvy27Gzt0knE8hwZE3:3aeD7zAfAAoqW1ugDC223P",
        "content-type: application/json"
    ),
));

$result = curl_exec($curl);
$err = curl_error($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
curl_close($curl);

// Check for cURL errors
if ($err) {
    die("cURL Error: " . $err);
}

// Check HTTP response code
if ($httpCode !== 200) {
    die("API Error: HTTP " . $httpCode);
}

// Parse JSON response
$data = json_decode($result, true);

// Check if JSON parsing was successful
if (json_last_error() !== JSON_ERROR_NONE) {
    die("JSON Parse Error: " . json_last_error_msg());
}

// Check if the API call was successful
if (!isset($data['success']) || $data['success'] != 1) {
    die("API returned unsuccessful response");
}

// Check if result exists
if (!isset($data['result'])) {
    die("No result found in API response");
}

$lottery = $data['result'];

// Extract numbers from the numbers array
if (!isset($lottery['numbers'])) {
    die("Numbers not found in API response");
}

$numbers = $lottery['numbers'];

// Extract individual numbers
$n1 = isset($numbers['n1']) ? intval($numbers['n1']) : null;
$n2 = isset($numbers['n2']) ? intval($numbers['n2']) : null;
$n3 = isset($numbers['n3']) ? intval($numbers['n3']) : null;
$n4 = isset($numbers['n4']) ? intval($numbers['n4']) : null;
$n5 = isset($numbers['n5']) ? intval($numbers['n5']) : null;
$mb = isset($numbers['pb']) ? intval($numbers['pb']) : null;

// Extract other fields from result
$jackpotDate = isset($lottery['date']) ? $lottery['date'] : '';
$jackpotCurrentAmt = isset($lottery['jackpot']) ? $lottery['jackpot'] : '';

// Extract next jackpot info
if (isset($lottery['next-jackpot'])) {
    $jackpotDateNext = isset($lottery['next-jackpot']['date']) ? $lottery['next-jackpot']['date'] : '';
    $jackpotDateNextAmt = isset($lottery['next-jackpot']['amount']) ? $lottery['next-jackpot']['amount'] : '';
    
    // Clean up the amount field (remove the cash value part if needed)
    // It contains: "$605 Million Cash value: $273.4 Million"
    // Let's keep just the main amount
    if (strpos($jackpotDateNextAmt, 'Cash value') !== false) {
        $jackpotDateNextAmt = trim(explode('Cash value:', $jackpotDateNextAmt)[0]);
    }
    
    // Clean up the date field - remove extra whitespace and format nicely
    $jackpotDateNext = preg_replace('/[\n\t]+/', '', $jackpotDateNext);  // Remove newlines and tabs
    $jackpotDateNext = preg_replace('/\s+/', ' ', $jackpotDateNext);     // Collapse multiple spaces
    $jackpotDateNext = trim($jackpotDateNext);                          // Remove leading/trailing spaces
} else {
    $jackpotDateNext = '';
    $jackpotDateNextAmt = '';
}

// Display extracted values (remove in production)
echo "Powerball Data Extracted:\n";
echo "Numbers: $n1, $n2, $n3, $n4, $n5, PB: $mb\n";
echo "Current Jackpot: $jackpotCurrentAmt on $jackpotDate\n";
echo "Next Jackpot: $jackpotDateNextAmt on $jackpotDateNext\n\n";

// Check for null values before database update
if ($n1 === null || $n2 === null || $n3 === null || $n4 === null || $n5 === null || $mb === null) {
    die("ERROR: One or more number values are NULL. Cannot update database.");
}

// Database connection
session_start();

// Check if config variables exist
if (!isset($host_gscroll) || !isset($username_gscroll) || !isset($password_gscroll) || !isset($database_gscroll)) {
    die("Database configuration variables not set. Check config.php");
}

$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

// Check connection
if (mysqli_connect_errno()) {
    die("Failed to connect to MySQL: " . mysqli_connect_error());
}

// START TRANSACTION to ensure atomic operation
mysqli_autocommit($con, FALSE);

try {
    // STEP 1: Delete all existing PB entries
    $delete_query = "DELETE FROM Lotto WHERE Game = 'PB'";
    $delete_result = mysqli_query($con, $delete_query);
    
    if (!$delete_result) {
        throw new Exception("Delete failed: " . mysqli_error($con));
    }
    
    $deleted_rows = mysqli_affected_rows($con);
    echo "Deleted $deleted_rows existing PB row(s).\n";
    
    // STEP 2: Insert the new data
    $insert_query = "INSERT INTO Lotto (Game, n1, n2, n3, n4, n5, MB, jackpotCurrentAmt, jackpotDateNext, jackpotDateNextAmt, jackpotDate) 
                     VALUES ('PB', ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = mysqli_prepare($con, $insert_query);
    
    if (!$stmt) {
        throw new Exception("Prepare failed: " . mysqli_error($con));
    }
    
    // Bind parameters
    if (!mysqli_stmt_bind_param($stmt, 'iiiiisssss', $n1, $n2, $n3, $n4, $n5, $mb, $jackpotCurrentAmt, $jackpotDateNext, $jackpotDateNextAmt, $jackpotDate)) {
        throw new Exception("Binding parameters failed: " . mysqli_stmt_error($stmt));
    }
    
    // Execute insert
    if (!mysqli_stmt_execute($stmt)) {
        throw new Exception("Insert failed: " . mysqli_stmt_error($stmt));
    }
    
    echo "New PB row inserted successfully.\n";
    
    // Commit the transaction
    mysqli_commit($con);
    echo "Transaction committed successfully.\n";
    
    // Clean up statement
    mysqli_stmt_close($stmt);
    
} catch (Exception $e) {
    // Rollback on error
    mysqli_rollback($con);
    echo "ERROR: Transaction rolled back - " . $e->getMessage() . "\n";
    die();
}

// Re-enable autocommit
mysqli_autocommit($con, TRUE);

// Clean up
mysqli_close($con);
session_write_close();

echo "Powerball script completed successfully!";
?>