<?php
// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../config.php'; // Include configuration file

echo "===========================================\n";
echo "POWERBALL API DEBUG SCRIPT\n";
echo "Current Date/Time: " . date('Y-m-d H:i:s T') . "\n";
echo "===========================================\n\n";

// API Request
$curl = curl_init();

curl_setopt_array($curl, array(
    CURLOPT_URL => "https://api.collectapi.com/chancegame/usaPowerball",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => array(
        "authorization: apikey 4YsfWvy27Gzt0knE8hwZE3:3aeD7zAfAAoqW1ugDC223P",
        "content-type: application/json"
    ),
));

echo ">>> Making API Request to CollectAPI...\n";
$result = curl_exec($curl);
$err = curl_error($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
curl_close($curl);

// Check for cURL errors
if ($err) {
    die("cURL Error: " . $err);
}

echo ">>> HTTP Response Code: " . $httpCode . "\n\n";

// Check HTTP response code
if ($httpCode !== 200) {
    die("API Error: HTTP " . $httpCode);
}

// Print raw API response for debugging
echo ">>> RAW API RESPONSE:\n";
echo "-------------------------------------------\n";
echo $result . "\n";
echo "-------------------------------------------\n\n";

// Parse JSON response
$data = json_decode($result, true);

// Check if JSON parsing was successful
if (json_last_error() !== JSON_ERROR_NONE) {
    die("JSON Parse Error: " . json_last_error_msg());
}

// Pretty print the parsed JSON for easier reading
echo ">>> PARSED JSON (Pretty Print):\n";
echo "-------------------------------------------\n";
echo json_encode($data, JSON_PRETTY_PRINT) . "\n";
echo "-------------------------------------------\n\n";

// Check if the API call was successful
if (!isset($data['success']) || $data['success'] != 1) {
    die("API returned unsuccessful response");
}

// Check if result exists
if (!isset($data['result'])) {
    die("No result found in API response");
}

$lottery = $data['result'];

echo ">>> EXTRACTED LOTTERY DATA:\n";
echo "-------------------------------------------\n";

// Extract and debug numbers
if (!isset($lottery['numbers'])) {
    die("Numbers not found in API response");
}

$numbers = $lottery['numbers'];

echo "Numbers array structure:\n";
print_r($numbers);
echo "\n";

// Extract individual numbers
$n1 = isset($numbers['n1']) ? intval($numbers['n1']) : null;
$n2 = isset($numbers['n2']) ? intval($numbers['n2']) : null;
$n3 = isset($numbers['n3']) ? intval($numbers['n3']) : null;
$n4 = isset($numbers['n4']) ? intval($numbers['n4']) : null;
$n5 = isset($numbers['n5']) ? intval($numbers['n5']) : null;
$mb = isset($numbers['pb']) ? intval($numbers['pb']) : null;

echo "Extracted Numbers:\n";
echo "  n1: " . ($n1 !== null ? $n1 : "NULL") . "\n";
echo "  n2: " . ($n2 !== null ? $n2 : "NULL") . "\n";
echo "  n3: " . ($n3 !== null ? $n3 : "NULL") . "\n";
echo "  n4: " . ($n4 !== null ? $n4 : "NULL") . "\n";
echo "  n5: " . ($n5 !== null ? $n5 : "NULL") . "\n";
echo "  Powerball: " . ($mb !== null ? $mb : "NULL") . "\n\n";

// Extract other fields from result
$jackpotDate = isset($lottery['date']) ? $lottery['date'] : '';
$jackpotCurrentAmt = isset($lottery['jackpot']) ? $lottery['jackpot'] : '';

echo "Current Draw Info:\n";
echo "  Date: " . $jackpotDate . "\n";
echo "  Jackpot Amount: " . $jackpotCurrentAmt . "\n\n";

// Extract next jackpot info
if (isset($lottery['next-jackpot'])) {
    echo "Next Jackpot Info (raw):\n";
    print_r($lottery['next-jackpot']);
    echo "\n";
    
    $jackpotDateNext = isset($lottery['next-jackpot']['date']) ? $lottery['next-jackpot']['date'] : '';
    $jackpotDateNextAmt = isset($lottery['next-jackpot']['amount']) ? $lottery['next-jackpot']['amount'] : '';
    
    echo "Next Jackpot - Raw Date: '" . $jackpotDateNext . "'\n";
    echo "Next Jackpot - Raw Amount: '" . $jackpotDateNextAmt . "'\n\n";
    
    // Debug the cleaning process
    echo "Cleaning next jackpot amount...\n";
    echo "  Before: '" . $jackpotDateNextAmt . "'\n";
    
    // Clean up the amount field (remove the cash value part if needed)
    if (strpos($jackpotDateNextAmt, 'Cash value') !== false) {
        $jackpotDateNextAmt = trim(explode('Cash value:', $jackpotDateNextAmt)[0]);
    }
    echo "  After removing cash value: '" . $jackpotDateNextAmt . "'\n\n";
    
    echo "Cleaning next jackpot date...\n";
    echo "  Before: '" . $jackpotDateNext . "'\n";
    // Clean up the date field - remove extra whitespace and format nicely
    $jackpotDateNext = preg_replace('/[\n\t]+/', '', $jackpotDateNext);  // Remove newlines and tabs
    $jackpotDateNext = preg_replace('/\s+/', ' ', $jackpotDateNext);     // Collapse multiple spaces
    $jackpotDateNext = trim($jackpotDateNext);                          // Remove leading/trailing spaces
    echo "  After cleaning: '" . $jackpotDateNext . "'\n\n";
} else {
    echo "No next-jackpot information found in response!\n\n";
    $jackpotDateNext = '';
    $jackpotDateNextAmt = '';
}

echo "-------------------------------------------\n\n";

// Display final extracted values
echo ">>> FINAL EXTRACTED VALUES:\n";
echo "===========================================\n";
echo "CURRENT/LAST DRAW:\n";
echo "  Date: " . $jackpotDate . "\n";
echo "  Numbers: $n1, $n2, $n3, $n4, $n5\n";
echo "  Powerball: $mb\n";
echo "  Jackpot: $jackpotCurrentAmt\n\n";
echo "NEXT DRAW:\n";
echo "  Date: " . $jackpotDateNext . "\n";
echo "  Estimated Jackpot: " . $jackpotDateNextAmt . "\n";
echo "===========================================\n\n";

// Compare with expected values
echo ">>> COMPARISON WITH EXPECTED (Sept 4, 2025):\n";
echo "-------------------------------------------\n";
echo "EXPECTED (Latest - Sept 3, 2025):\n";
echo "  Numbers: 3, 16, 29, 61, 69\n";
echo "  Powerball: 22\n";
echo "  Next Draw: Saturday, Sept 6, 2025\n";
echo "  Next Jackpot: $1.7 billion\n\n";
echo "YOUR APP SHOWS:\n";
echo "  Numbers: 8, 23, 25, 40, 53\n";
echo "  Powerball: 5\n";
echo "  Next Draw: Today at 10:59, $1.4B\n\n";
echo "API RETURNS:\n";
echo "  Numbers: $n1, $n2, $n3, $n4, $n5\n";
echo "  Powerball: $mb\n";
echo "  Date: $jackpotDate\n";
echo "  Next: $jackpotDateNext @ $jackpotDateNextAmt\n";
echo "-------------------------------------------\n\n";

// Check for null values before database update
if ($n1 === null || $n2 === null || $n3 === null || $n4 === null || $n5 === null || $mb === null) {
    echo "WARNING: One or more number values are NULL. Database update will be skipped.\n\n";
    $skipDatabase = true;
} else {
    $skipDatabase = false;
}

// Ask user if they want to proceed with database update
echo ">>> DATABASE UPDATE SECTION\n";
echo "-------------------------------------------\n";

if ($skipDatabase) {
    echo "Skipping database update due to NULL values.\n";
} else {
    echo "Ready to update database with these values.\n";
    echo "Uncomment the database section below to proceed.\n\n";
    
    /* UNCOMMENT THIS SECTION TO ENABLE DATABASE UPDATE
    
    // Database connection
    session_start();
    
    // Check if config variables exist
    if (!isset($host_gscroll) || !isset($username_gscroll) || !isset($password_gscroll) || !isset($database_gscroll)) {
        die("Database configuration variables not set. Check config.php");
    }
    
    echo "Connecting to database...\n";
    $con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
    
    // Check connection
    if (mysqli_connect_errno()) {
        die("Failed to connect to MySQL: " . mysqli_connect_error());
    }
    
    echo "Database connected successfully.\n";
    
    // START TRANSACTION to ensure atomic operation
    mysqli_autocommit($con, FALSE);
    
    try {
        // STEP 1: Delete all existing PB entries
        echo "Deleting existing PB entries...\n";
        $delete_query = "DELETE FROM Lotto WHERE Game = 'PB'";
        $delete_result = mysqli_query($con, $delete_query);
        
        if (!$delete_result) {
            throw new Exception("Delete failed: " . mysqli_error($con));
        }
        
        $deleted_rows = mysqli_affected_rows($con);
        echo "Deleted $deleted_rows existing PB row(s).\n";
        
        // STEP 2: Insert the new data
        echo "Inserting new data...\n";
        $insert_query = "INSERT INTO Lotto (Game, n1, n2, n3, n4, n5, MB, jackpotCurrentAmt, jackpotDateNext, jackpotDateNextAmt, jackpotDate) 
                         VALUES ('PB', ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt = mysqli_prepare($con, $insert_query);
        
        if (!$stmt) {
            throw new Exception("Prepare failed: " . mysqli_error($con));
        }
        
        // Bind parameters
        if (!mysqli_stmt_bind_param($stmt, 'iiiiisssss', $n1, $n2, $n3, $n4, $n5, $mb, $jackpotCurrentAmt, $jackpotDateNext, $jackpotDateNextAmt, $jackpotDate)) {
            throw new Exception("Binding parameters failed: " . mysqli_stmt_error($stmt));
        }
        
        // Execute insert
        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Insert failed: " . mysqli_stmt_error($stmt));
        }
        
        echo "New PB row inserted successfully.\n";
        
        // Commit the transaction
        mysqli_commit($con);
        echo "Transaction committed successfully.\n";
        
        // Clean up statement
        mysqli_stmt_close($stmt);
        
    } catch (Exception $e) {
        // Rollback on error
        mysqli_rollback($con);
        echo "ERROR: Transaction rolled back - " . $e->getMessage() . "\n";
        die();
    }
    
    // Re-enable autocommit
    mysqli_autocommit($con, TRUE);
    
    // Clean up
    mysqli_close($con);
    session_write_close();
    
    END OF DATABASE UPDATE SECTION */
}

echo "\n>>> Debug script completed!\n";
echo "===========================================\n";
?>