<?php

// Enable error reporting to see what's going wrong
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('max_execution_time', 300); // 5 minutes timeout

/**
 * ===================
 *  HELPER FUNCTIONS
 * ===================
 */

 require_once '../config.php'; // Include the configuration file

// Function to fetch and process sports news from ESPN API
function fetchSportsNews($sport_name, $api_url, &$counter, $host, $username, $password, $database) {
    echo "<br><br>=== $sport_name NEWS DEBUG ===<br>";
    flush();

    echo "$sport_name: Fetching from URL: $api_url<br>";
    flush();

    $curl = curl_init($api_url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_TIMEOUT, 30);
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);

    $result = curl_exec($curl);

    if ($result === false) {
        echo "$sport_name: cURL Error: " . curl_error($curl) . "<br>";
        curl_close($curl);
        return;
    }

    echo "$sport_name API Response length: " . strlen($result) . "<br>";
    curl_close($curl);

    $data = json_decode($result, true);

    if ($data === null || !isset($data['articles'])) {
        echo "$sport_name: Failed to parse JSON or no articles found<br>";
        return;
    }

    $articles = $data['articles'];
    $article_count = count($articles);
    echo "$sport_name: Found $article_count articles in JSON<br>";
    flush();

    foreach ($articles as $article) {
        $counter++;

        $headline = isset($article['headline']) ? $article['headline'] : '';
        $description = isset($article['description']) ? $article['description'] : '';

        echo "$sport_name: Processing article $counter - " . substr($headline, 0, 50) . "...<br>";
        flush();

        if (empty($headline) && empty($description)) {
            echo "$sport_name: Skipping - no headline or description<br>";
            continue;
        }

        $conn = mysqli_connect($host, $username, $password, $database);
        if (!$conn) {
            echo "$sport_name: DB Connection failed: " . mysqli_connect_error() . "<br>";
            continue;
        }

        $query = "UPDATE News_DB_sports SET Title = ?, Description = ?, source = ? WHERE Identifer = ?";
        $stmt = mysqli_prepare($conn, $query);
        if (!$stmt) {
            echo "$sport_name: Error preparing statement: " . mysqli_error($conn) . "<br>";
            mysqli_close($conn);
            continue;
        }

        mysqli_stmt_bind_param($stmt, "sssi", $headline, $description, $sport_name, $counter);

        if (mysqli_stmt_execute($stmt)) {
            echo "$sport_name: ✓ Updated row $counter<br>";
        } else {
            echo "$sport_name: Error updating row $counter: " . mysqli_error($conn) . "<br>";
        }

        mysqli_stmt_close($stmt);
        mysqli_close($conn);
    }

    flush();
}



session_start();
// Establish a database connection using mysqli
$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

// Check connection
if (mysqli_connect_errno()) {
    echo "Failed to connect to MySQL: " . mysqli_connect_error();
    exit;
}

echo "<h2>Starting Sports News Update Script</h2>";
echo "<hr>";

// Delete all rows from the table
$deleteQuery = "DELETE FROM News_DB_sports";
if (mysqli_query($con, $deleteQuery)) {
    echo "All rows deleted successfully.<br>";
} else {
    echo "Error deleting rows: " . mysqli_error($con) . "<br>";
}

// Insert new values into the table
$insertQuery = "INSERT INTO News_DB_sports (Identifer, Title, Description, source)
    VALUES
    (1, '', '', ''),
    (2, '', '', ''),
    (3, '', '', ''),
    (4, '', '', ''),
    (5, '', '', ''),
    (6, '', '', ''),
    (7, '', '', ''),
    (8, '', '', ''),
    (9, '', '', ''),
    (10, '', '', ''),
    (11, '', '', ''),
    (12, '', '', ''),
    (13, '', '', ''),
    (14, '', '', ''),
    (15, '', '', ''),
    (16, '', '', ''),
    (17, '', '', ''),
    (18, '', '', ''),
    (19, '', '', ''),
    (20, '', '', ''),
    (21, '', '', ''),
    (22, '', '', ''),
    (23, '', '', ''),
    (24, '', '', ''),
    (25, '', '', ''),
    (26, '', '', ''),
    (27, '', '', ''),
    (28, '', '', ''),
    (29, '', '', ''),
    (30, '', '', ''),
    (31, '', '', '')";

if (mysqli_query($con, $insertQuery)) {
    echo "New rows inserted successfully (31 rows with Identifier only).<br>";
} else {
    echo "Error inserting rows: " . mysqli_error($con) . "<br>";
}

mysqli_close($con);
echo "<br>Now fetching sports news from ESPN API...<br>";
flush();

// Initialize counter
$counter = 0;

// Fetch all sports news
fetchSportsNews('NCAAF', 'http://site.api.espn.com/apis/site/v2/sports/football/college-football/news', $counter, $host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);



fetchSportsNews('MLB', 'http://site.api.espn.com/apis/site/v2/sports/baseball/mlb/news', $counter, $host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);




fetchSportsNews('NHL', 'http://site.api.espn.com/apis/site/v2/sports/hockey/nhl/news', $counter, $host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);



fetchSportsNews('NBA', 'http://site.api.espn.com/apis/site/v2/sports/basketball/nba/news', $counter, $host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);


fetchSportsNews('NCAAB', 'http://site.api.espn.com/apis/site/v2/sports/basketball/mens-college-basketball/news', $counter, $host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);


fetchSportsNews('NFL', 'https://site.api.espn.com/apis/site/v2/sports/football/nfl/news', $counter, $host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);


fetchSportsNews('PGA', 'https://site.api.espn.com/apis/site/v2/sports/golf/pga/news', $counter, $host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);


fetchSportsNews('UFC', 'https://site.api.espn.com/apis/site/v2/sports/mma/ufc/news', $counter, $host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);


fetchSportsNews('F1', 'https://site.api.espn.com/apis/site/v2/sports/racing/f1/news', $counter, $host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

echo "<br><br><hr>";
echo "<h2>Script Completed Successfully!</h2>";
echo "Total items processed: <strong>$counter</strong><br>";

?>
