<?php
// Turn on full error reporting and throw exceptions on mysqli errors
error_reporting(E_ALL);
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
session_start();
require_once '../config.php'; // your DB credentials

// Process start time
$startTime = microtime(true);

// Start HTML output
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Instagram Data Sync Debug</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: #f5f5f5;
            margin: 20px;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #e91e63;
            text-align: center;
            margin-bottom: 30px;
            font-size: 24px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        th {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 12px;
            text-align: left;
            font-weight: 600;
        }
        td {
            padding: 12px;
            border-bottom: 1px solid #eee;
        }
        tr:hover {
            background-color: #f8f9fa;
        }
        .success { color: #28a745; font-weight: 600; }
        .error { color: #dc3545; font-weight: 600; }
        .info { color: #17a2b8; font-weight: 600; }
        .processing { color: #ffc107; font-weight: 600; }
        .icon { margin-right: 8px; }
        .status-box {
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            text-align: center;
            font-size: 18px;
        }
        .status-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .number {
            font-weight: bold;
            color: #5e72e4;
        }
        .table-section {
            margin-bottom: 30px;
        }
        .section-title {
            background: #f8f9fa;
            padding: 10px 15px;
            margin: 0;
            font-size: 16px;
            color: #495057;
            border-bottom: 2px solid #dee2e6;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>📸 Instagram Data Sync - Debug Mode</h1>
    
    <div class="table-section">
        <h3 class="section-title">🔄 Process Status</h3>
        <table>
            <thead>
                <tr>
                    <th width="40%">Step</th>
                    <th width="60%">Status</th>
                </tr>
            </thead>
            <tbody>
<?php

// 1) Connect
echo '<tr><td>Database Connection</td><td>';
$con = mysqli_connect(
    $host_gscroll,
    $username_gscroll,
    $password_gscroll,
    $database_gscroll
);
if (mysqli_connect_errno()) {
    echo '<span class="error">❌ Failed: ' . mysqli_connect_error() . '</span>';
    echo '</td></tr></tbody></table></div></div></body></html>';
    die();
}
echo '<span class="success">✅ Connected Successfully</span></td></tr>';

// 2) Process username
$userName = str_replace('@', '', $_GET['UN'] ?? '');
echo '<tr><td>Username</td><td><span class="info">ℹ️ @' . htmlspecialchars($userName) . '</span></td></tr>';

// 3) Fetch from API
$url = "https://api.digitalbyte.cc/instagram/aj.com/{$userName}";
echo '<tr><td>API Call</td><td>';

$curl = curl_init($url);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
$resp = curl_exec($curl);
if ($resp === false) {
    echo '<span class="error">❌ Failed: ' . curl_error($curl) . '</span>';
    echo '</td></tr></tbody></table></div></div></body></html>';
    die();
}
curl_close($curl);
echo '<span class="success">✅ Success (' . strlen($resp) . ' bytes)</span></td></tr>';

// 4) Parse JSON
echo '<tr><td>JSON Parsing</td><td>';
$resp = trim($resp);
$jsonObjects = preg_split('/(?<=})\s*(?={)/', $resp);
$data = json_decode($jsonObjects[0], true);
if ($data === null) {
    echo '<span class="error">❌ Failed: ' . json_last_error_msg() . '</span>';
    echo '</td></tr></tbody></table></div></div></body></html>';
    die();
}
echo '<span class="success">✅ Parsed Successfully</span></td></tr>';
?>
            </tbody>
        </table>
    </div>

    <div class="table-section">
        <h3 class="section-title">📊 Extracted Data</h3>
        <table>
            <thead>
                <tr>
                    <th width="40%">Field</th>
                    <th width="60%">Value</th>
                </tr>
            </thead>
            <tbody>
<?php
// Extract data
$user_followers = isset($data['user_followers']) ? (int)$data['user_followers'] : 0;
$total_posts = isset($data['total_posts']) ? (int)$data['total_posts'] : 0;
$mediaType = 'Instagram';

echo '<tr><td>Username</td><td>@' . htmlspecialchars($userName) . '</td></tr>';
echo '<tr><td>Followers</td><td><span class="number">' . number_format($user_followers) . '</span></td></tr>';
echo '<tr><td>Total Posts</td><td><span class="number">' . number_format($total_posts) . '</span></td></tr>';
echo '<tr><td>Media Type</td><td>' . $mediaType . '</td></tr>';
?>
            </tbody>
        </table>
    </div>

    <div class="table-section">
        <h3 class="section-title">💾 Database Operation</h3>
        <table>
            <thead>
                <tr>
                    <th width="40%">Operation</th>
                    <th width="60%">Details</th>
                </tr>
            </thead>
            <tbody>
<?php
// Check existing record
$checkQ = "
    SELECT COUNT(*) AS cnt
      FROM `SocialMedia`
     WHERE `userName` = ? AND `mediaType` = ?
";
$stmt = $con->prepare($checkQ);
$stmt->bind_param("ss", $userName, $mediaType);
$stmt->execute();
$stmt->bind_result($cnt);
$stmt->fetch();
$stmt->close();

echo '<tr><td>Record Check</td><td><span class="info">ℹ️ ' . $cnt . ' existing record(s) found</span></td></tr>';

if ($cnt > 0) {
    // Update existing
    echo '<tr><td>Operation Type</td><td><span class="info">ℹ️ UPDATE</span></td></tr>';
    
    $updQ = "
        UPDATE `SocialMedia`
           SET `followers` = ?, `post` = ?
         WHERE `userName` = ? AND `mediaType` = ?
    ";
    $stmt = $con->prepare($updQ);
    $stmt->bind_param("iiss", $user_followers, $total_posts, $userName, $mediaType);
    
    try {
        $stmt->execute();
        $affectedRows = $stmt->affected_rows;
        echo '<tr><td>Execution Status</td><td><span class="success">✅ Success</span></td></tr>';
        echo '<tr><td>Affected Rows</td><td>' . $affectedRows . '</td></tr>';
        if ($affectedRows == 0) {
            echo '<tr><td>Note</td><td><span class="info">ℹ️ No changes (values same as before)</span></td></tr>';
        }
    } catch (mysqli_sql_exception $e) {
        echo '<tr><td>Execution Status</td><td><span class="error">❌ Failed: ' . $e->getMessage() . '</span></td></tr>';
    }
    $stmt->close();
} else {
    // Insert new
    echo '<tr><td>Operation Type</td><td><span class="info">ℹ️ INSERT</span></td></tr>';
    
    $insQ = "
        INSERT INTO `SocialMedia`
          (`userName`,`followers`,`post`,`mediaType`,`views`)
        VALUES
          (?, ?, ?, ?, 0)
    ";
    $stmt = $con->prepare($insQ);
    $stmt->bind_param("siis", $userName, $user_followers, $total_posts, $mediaType);
    
    try {
        $stmt->execute();
        $insertId = $stmt->insert_id;
        echo '<tr><td>Execution Status</td><td><span class="success">✅ Success</span></td></tr>';
        echo '<tr><td>New Record ID</td><td><span class="number">' . $insertId . '</span></td></tr>';
        echo '<tr><td>Views</td><td>0 (default)</td></tr>';
    } catch (mysqli_sql_exception $e) {
        echo '<tr><td>Execution Status</td><td><span class="error">❌ Failed: ' . $e->getMessage() . '</span></td></tr>';
    }
    $stmt->close();
}

$con->close();
echo '<tr><td>Database Connection</td><td><span class="success">✅ Closed</span></td></tr>';

// Execution time
$endTime = microtime(true);
$executionTime = round($endTime - $startTime, 3);
?>
            </tbody>
        </table>
    </div>

    <div class="status-box status-success">
        ✅ Script completed in <?php echo $executionTime; ?> seconds
    </div>
</div>
</body>
</html>