<?php
error_reporting(0);
session_start();
require_once '../config.php'; // Include the configuration file

$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (mysqli_connect_errno()) {
    echo "Failed to connect to MySQL: " . mysqli_connect_error();
    exit();
}

// Get parameters
$userName = $_GET['UN'] ?? '';
$platform = $_GET['platform'] ?? '';

if (empty($userName) || empty($platform)) {
    die("Error: Both UN and platform parameters are required");
}

// Convert platform to proper case for consistency
$platform = strtolower($platform);

if ($platform === 'youtube') {
    // YouTube logic
    function strposX($haystack, $needle, $number = 0) {
        return strpos($haystack, $needle, $number > 1 ? strposX($haystack, $needle, $number - 1) + strlen($needle) : 0);
    }
    
    $url = 'https://www.youtube.com/@' . $userName;
    $data = file_get_contents($url);
    $rawData = strip_tags($data);
    
    $start_suffix = 'channel_id=';
    $end_suffix = '","externalId":"';
    $index_start = strposX($rawData, $start_suffix, 1) + strlen($start_suffix);
    $index_end = strposX($rawData, $end_suffix, 1) - $index_start;
    $id = substr($rawData, $index_start, $index_end);
    
    if (strlen($id) > 25) {
        $id = substr($id, 0, 24);
    }
    
    $api_link = sprintf('https://www.googleapis.com/youtube/v3/channels?part=statistics&id=%s&key=AIzaSyDgStZHMBc3_7SYjKdqu0-IU6QYaNZ-RxU', $id);
    
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $api_link,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
    ]);
    
    $result = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    
    if ($err) {
        echo "cURL Error #:" . $err;
        exit();
    }
    
    $data = json_decode($result, true);
    $viewCount = isset($data['items'][0]['statistics']['viewCount']) ? $data['items'][0]['statistics']['viewCount'] : 0;
    $subscriberCount = isset($data['items'][0]['statistics']['subscriberCount']) ? $data['items'][0]['statistics']['subscriberCount'] : 0;
    $videoCount = isset($data['items'][0]['statistics']['videoCount']) ? $data['items'][0]['statistics']['videoCount'] : 0;
    
    $mediaType = 'YouTube';
    $followers = $subscriberCount;
    $posts = $videoCount;
    $views = $viewCount;
    
} elseif ($platform === 'instagram') {
    // Instagram logic
    $userName = str_replace('@', '', $userName);
    $url = "https://fanhub.pro/api_20?username=" . $userName;
    
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $resp = curl_exec($curl);
    curl_close($curl);
    
    // Handle multiple JSON objects
    $resp = trim($resp);
    $jsonObjects = preg_split('/(?<=})\s*(?={)/', $resp);
    $data = json_decode($jsonObjects[0], true);
    
    if ($data === null) {
        die("Error decoding JSON: " . json_last_error_msg());
    }
    
    $mediaType = 'Instagram';
    $followers = isset($data['user_followers']) ? $data['user_followers'] : 0;
    $posts = isset($data['total_posts']) ? $data['total_posts'] : 0;
    $views = 0; // Instagram doesn't have views in the same way as YouTube
    
} else {
    die("Error: Invalid platform. Use 'Youtube' or 'Instagram'");
}

// Database operations (common for both platforms)
// Check if userName and mediaType exists
$checkQuery = "SELECT COUNT(*) as count FROM SocialMedia WHERE userName = ? AND mediaType = ?";
$checkStmt = mysqli_prepare($con, $checkQuery);
mysqli_stmt_bind_param($checkStmt, "ss", $userName, $mediaType);
mysqli_stmt_execute($checkStmt);
mysqli_stmt_bind_result($checkStmt, $count);
mysqli_stmt_fetch($checkStmt);
mysqli_stmt_close($checkStmt);

if ($count > 0) {
    // Record exists, update it
    if ($platform === 'youtube') {
        $updateQuery = "UPDATE SocialMedia SET followers = ?, post = ?, views = ? WHERE userName = ? AND mediaType = ?";
        $updateStmt = mysqli_prepare($con, $updateQuery);
        mysqli_stmt_bind_param($updateStmt, "iiiss", $followers, $posts, $views, $userName, $mediaType);
    } else {
        // Instagram doesn't have views field
        $updateQuery = "UPDATE SocialMedia SET followers = ?, post = ? WHERE userName = ? AND mediaType = ?";
        $updateStmt = mysqli_prepare($con, $updateQuery);
        mysqli_stmt_bind_param($updateStmt, "iiss", $followers, $posts, $userName, $mediaType);
    }
    mysqli_stmt_execute($updateStmt);
    mysqli_stmt_close($updateStmt);
    echo "Record updated successfully.";
} else {
    // No record exists, insert new
    if ($platform === 'youtube') {
        $insertQuery = "INSERT INTO SocialMedia (userName, followers, post, views, mediaType) VALUES (?, ?, ?, ?, ?)";
        $insertStmt = mysqli_prepare($con, $insertQuery);
        mysqli_stmt_bind_param($insertStmt, "siiss", $userName, $followers, $posts, $views, $mediaType);
    } else {
        // Instagram doesn't have views field
        $insertQuery = "INSERT INTO SocialMedia (userName, followers, post, mediaType) VALUES (?, ?, ?, ?)";
        $insertStmt = mysqli_prepare($con, $insertQuery);
        mysqli_stmt_bind_param($insertStmt, "siis", $userName, $followers, $posts, $mediaType);
    }
    mysqli_stmt_execute($insertStmt);
    mysqli_stmt_close($insertStmt);
    echo "New record inserted successfully.";
}

// Output the results for debugging/confirmation
echo "\n\nResults:\n";
echo "Platform: $mediaType\n";
echo "Username: $userName\n";
echo "Followers: $followers\n";
echo "Posts: $posts\n";
if ($platform === 'youtube') {
    echo "Views: $views\n";
}

mysqli_close($con);
?>