<?php

error_reporting(0);
session_start();
require_once '../config.php'; // Include the configuration file

$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

if (mysqli_connect_errno()) {
    echo "Failed to connect to MySQL: " . mysqli_connect_error();
    exit();
}

function strposX($haystack, $needle, $number = 0) {
    return strpos($haystack, $needle, $number > 1 ? strposX($haystack, $needle, $number - 1) + strlen($needle) : 0);
}

$userName = $_GET['UN']; 

$url = 'https://www.youtube.com/@' . $userName;
$data = file_get_contents($url);
$rawData = strip_tags($data);

$start_suffix = 'channel_id=';
$end_suffix = '","externalId":"';
$index_start = strposX($rawData, $start_suffix, 1) + strlen($start_suffix);
$index_end = strposX($rawData, $end_suffix, 1) - $index_start;
$id = substr($rawData, $index_start, $index_end);

if (strlen($id) > 25) {
    $id = substr($id, 0, 24);
}

$api_link = sprintf('https://www.googleapis.com/youtube/v3/channels?part=statistics&id=%s&key=AIzaSyDgStZHMBc3_7SYjKdqu0-IU6QYaNZ-RxU', $id);

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $api_link,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
]);

$result = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    echo "cURL Error #:" . $err;
    exit();
}

$data = json_decode($result, true);
$viewCount = isset($data['items'][0]['statistics']['viewCount']) ? $data['items'][0]['statistics']['viewCount'] : 0;
$subscriberCount = isset($data['items'][0]['statistics']['subscriberCount']) ? $data['items'][0]['statistics']['subscriberCount'] : 0;
$videoCount = isset($data['items'][0]['statistics']['videoCount']) ? $data['items'][0]['statistics']['videoCount'] : 0;
$mediaType = 'YouTube';

// Check if userName and mediaType exists
$checkQuery = "SELECT COUNT(*) as count FROM SocialMedia WHERE userName = ? AND mediaType = ?";
$checkStmt = mysqli_prepare($con, $checkQuery);
mysqli_stmt_bind_param($checkStmt, "ss", $userName, $mediaType);
mysqli_stmt_execute($checkStmt);
mysqli_stmt_bind_result($checkStmt, $count);
mysqli_stmt_fetch($checkStmt);
mysqli_stmt_close($checkStmt);

if ($count > 0) {
    // Record exists, update it
    $updateQuery = "UPDATE SocialMedia SET followers = ?, post = ?, views = ? WHERE userName = ? AND mediaType = ?";
    $updateStmt = mysqli_prepare($con, $updateQuery);
    mysqli_stmt_bind_param($updateStmt, "iiiss", $subscriberCount, $videoCount, $viewCount, $userName, $mediaType);
    mysqli_stmt_execute($updateStmt);
    mysqli_stmt_close($updateStmt);
} else {
    // No record exists, insert new
    $insertQuery = "INSERT INTO SocialMedia (userName, followers, post, views, mediaType) VALUES (?, ?, ?, ?, ?)";
    $insertStmt = mysqli_prepare($con, $insertQuery);
    mysqli_stmt_bind_param($insertStmt, "siiss", $userName, $subscriberCount, $videoCount, $viewCount, $mediaType);
    mysqli_stmt_execute($insertStmt);
    mysqli_stmt_close($insertStmt);
}

echo "Operation successful.";

mysqli_close($con);
?>
