<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/config.php';

// Create a PDO database connection.
try {
    $db = new PDO("mysql:host=$host_gscroll;dbname=$database_gscroll", $username_gscroll, $password_gscroll);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database Connection Error: " . $e->getMessage());
}

// MLB Teams lookup array
$Teams = array(
    array("id" => "29", "abbreviation" => "ARI", "color" => "aa182c", "alternateColor" => "e3d4ad", "name" => "DIAMONDBACKS"),
    array("id" => "15", "abbreviation" => "ATL", "color" => "0c2340", "alternateColor" => "ba0c2f", "name" => "BRAVES"),
    array("id" => "1",  "abbreviation" => "BAL", "color" => "df4601", "alternateColor" => "000000", "name" => "ORIOLES"),
    array("id" => "2",  "abbreviation" => "BOS", "color" => "0d2b56", "alternateColor" => "bd3039", "name" => "RED SOX"),
    array("id" => "16", "abbreviation" => "CHC", "color" => "0e3386", "alternateColor" => "cc3433", "name" => "CUBS"),
    array("id" => "4",  "abbreviation" => "CHW", "color" => "000000", "alternateColor" => "c4ced4", "name" => "WHITE SOX"),
    array("id" => "17", "abbreviation" => "CIN", "color" => "c6011f", "alternateColor" => "ffffff", "name" => "REDS"),
    array("id" => "5",  "abbreviation" => "CLE", "color" => "002b5c", "alternateColor" => "e31937", "name" => "GUARDIANS"),
    array("id" => "27", "abbreviation" => "COL", "color" => "33006f", "alternateColor" => "c4ced4", "name" => "ROCKIES"),
    array("id" => "6",  "abbreviation" => "DET", "color" => "0a2240", "alternateColor" => "ff4713", "name" => "TIGERS"),
    array("id" => "18", "abbreviation" => "HOU", "color" => "002d62", "alternateColor" => "eb6e1f", "name" => "ASTROS"),
    array("id" => "7",  "abbreviation" => "KC",  "color" => "004687", "alternateColor" => "7ab2dd", "name" => "ROYALS"),
    array("id" => "3",  "abbreviation" => "LAA", "color" => "ba0021", "alternateColor" => "c4ced4", "name" => "ANGELS"),
    array("id" => "19", "abbreviation" => "LAD", "color" => "005a9c", "alternateColor" => "ffffff", "name" => "DODGERS"),
    array("id" => "28", "abbreviation" => "MIA", "color" => "00a3e0", "alternateColor" => "ef3340", "name" => "MARLINS"),
    array("id" => "8",  "abbreviation" => "MIL", "color" => "13294b", "alternateColor" => "ffc72c", "name" => "BREWERS"),
    array("id" => "9",  "abbreviation" => "MIN", "color" => "031f40", "alternateColor" => "e20e32", "name" => "TWINS"),
    array("id" => "21", "abbreviation" => "NYM", "color" => "002d72", "alternateColor" => "ff5910", "name" => "METS"),
    array("id" => "10", "abbreviation" => "NYY", "color" => "132448", "alternateColor" => "c4ced4", "name" => "YANKEES"),
    array("id" => "22", "abbreviation" => "PHI", "color" => "e81828", "alternateColor" => "002d72", "name" => "PHILLIES"),
    array("id" => "23", "abbreviation" => "PIT", "color" => "000000", "alternateColor" => "fdb827", "name" => "PIRATES"),
    array("id" => "25", "abbreviation" => "SD",  "color" => "2f241d", "alternateColor" => "ffc425", "name" => "PADRES"),
    array("id" => "26", "abbreviation" => "SF",  "color" => "000000", "alternateColor" => "fa4616", "name" => "GIANTS"),
    array("id" => "12", "abbreviation" => "SEA", "color" => "005c5c", "alternateColor" => "0c2c56", "name" => "MARINERS"),
    array("id" => "24", "abbreviation" => "STL", "color" => "be0a14", "alternateColor" => "0c2340", "name" => "CARDINALS"),
    array("id" => "30", "abbreviation" => "TB",  "color" => "092c5c", "alternateColor" => "8fbce6", "name" => "RAYS"),
    array("id" => "13", "abbreviation" => "TEX", "color" => "003278", "alternateColor" => "c0111f", "name" => "RANGERS"),
    array("id" => "14", "abbreviation" => "TOR", "color" => "134a8e", "alternateColor" => "1d2d5c", "name" => "BLUE JAYS"),
    array("id" => "20", "abbreviation" => "WSH", "color" => "ab0003", "alternateColor" => "14225a", "name" => "NATIONALS"),
    array("id" => "11", "abbreviation" => "ATH", "color" => "003831", "alternateColor" => "ffffff", "name" => "ATHLETICS")
);

function curlFetch($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'cURL error when fetching ' . htmlspecialchars($url) . ': ' . curl_error($ch) . "<br>";
        curl_close($ch);
        return false;
    }
    curl_close($ch);
    return json_decode($response, true);
}

// Start HTML output
echo <<<HTML
<!DOCTYPE html>
<html>
<head>
    <title>MLB Leaders 2024</title>
    <style>
        .stats-container {
            max-width: 1200px;
            margin: 20px auto;
            font-family: Arial, sans-serif;
        }
        .stats-table {
            border-collapse: collapse;
            width: 100%;
            margin: 20px 0;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            background: white;
        }
        .stats-table th {
            background-color: #2c3e50;
            color: white;
            font-weight: bold;
            padding: 12px;
            text-align: left;
        }
        .stats-table td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
            vertical-align: middle;
        }
        .stats-table tr:hover {
            background-color: #f5f5f5;
            transition: background-color 0.3s;
        }
        .category-header {
            background-color: #3498db;
            color: white;
            font-size: 1.2em;
            padding: 15px;
            text-align: center;
            margin: 20px 0 10px 0;
        }
        .team-color {
            width: 20px;
            height: 20px;
            display: inline-block;
            border-radius: 50%;
            margin-right: 8px;
            vertical-align: middle;
        }
        .player-headshot {
            width: 30px;
            height: 30px;
            margin-right: 8px;
            vertical-align: middle;
        }
        .sql-statements {
            background-color: #f8f9fa;
            padding: 15px;
            margin: 20px 0;
            border-left: 4px solid #2c3e50;
            font-family: 'Courier New', Courier, monospace;
            white-space: pre-wrap;
            overflow-x: auto;
        }
    </style>
</head>
<body>
<div class="stats-container">
HTML;

$leadersUrl = "https://sports.core.api.espn.com/v2/sports/baseball/leagues/mlb/seasons/2025/types/2/leaders?lang=en&region=us";
$leadersData = curlFetch($leadersUrl);
if (!$leadersData) {
    die("Error fetching leaders data.</div></body></html>");
}

$playerIds = [];
$sqlStatements = [];

if (isset($leadersData['categories'])) {
    foreach ($leadersData['categories'] as $category) {
        // Use displayName for header; also prepare a comparison key by lowercasing and removing spaces.
        $categoryName = isset($category['displayName']) ? $category['displayName'] : 'N/A';
        $categoryCompare = str_replace(' ', '', strtolower($categoryName));

        echo "<div class='category-header'>" . htmlspecialchars($categoryName) . "</div>";
        echo "<table class='stats-table'>";
        echo "<tr><th>Rank</th><th>Player</th><th>Team</th><th>Stat Value</th></tr>";

        if (isset($category['leaders']) && is_array($category['leaders'])) {
            $rank = 1;
            foreach ($category['leaders'] as $leader) {
                if ($rank > 5) break;

                // Handle different stat formatting based on category
                if ($categoryCompare === 'homeruns' && isset($leader['value'])) {
                    $finalStat = $leader['value'];
                } elseif ($categoryCompare === 'battingaverage' && isset($leader['value'])) {
                    // Format batting average to 3 decimal places
                    $finalStat = number_format((float)$leader['value'], 3);
                } else {
                    $finalStat = $leader['value'] ?? 'N/A';
                }

                // Fetch athlete details.
                $athleteData = curlFetch($leader['athlete']['$ref'] ?? '');
                $playerName = $athleteData['fullName'] ?? 'N/A';

                $playerId = 'N/A';
                if (preg_match('/athletes\/(\d+)/', $leader['athlete']['$ref'] ?? '', $matches)) {
                    $playerId = $matches[1];
                    $playerIds[] = $playerId;
                }

                // Fetch team details.
                $teamData = curlFetch($leader['team']['$ref'] ?? '');
                $teamAbbr = $teamData['abbreviation'] ?? 'N/A';

                $red = $green = $blue = $redAlt = $greenAlt = $blueAlt = 0;
                $teamColor = '#000000';
                foreach ($Teams as $t) {
                    if ($t['abbreviation'] === $teamAbbr) {
                        $teamColor = '#' . $t['color'];
                        $main = $t['color'];
                        $alt = $t['alternateColor'];
                        $red = hexdec(substr($main, 0, 2));
                        $green = hexdec(substr($main, 2, 2));
                        $blue = hexdec(substr($main, 4, 2));
                        $redAlt = hexdec(substr($alt, 0, 2));
                        $greenAlt = hexdec(substr($alt, 2, 2));
                        $blueAlt = hexdec(substr($alt, 4, 2));
                        break;
                    }
                }

                // Generate and execute SQL UPDATE statement using the parsed finalStat.
                $sql = "UPDATE player_stats SET 
                    Player = '" . addslashes($playerName) . "',
                    Stat_Value = '" . addslashes($finalStat) . "',
                    Team = '" . addslashes($teamAbbr) . "',
                    Red = $red,
                    Green = $green,
                    Blue = $blue,
                    Red_ALT = $redAlt,
                    Green_ALT = $greenAlt,
                    Blue_ALT = $blueAlt,
                    ID = '" . addslashes($playerId) . "'
                    WHERE Rank = $rank 
                    AND Category = '" . addslashes($categoryName) . "' 
                    AND league = 'MLB'";
                $sqlStatements[] = $sql;

                try {
                    $db->exec($sql);
                } catch (PDOException $e) {
                    echo "Error updating record for player " . htmlspecialchars($playerName) . ": " . $e->getMessage() . "<br>";
                }

                // Output table row.
                echo "<tr>";
                echo "<td>" . $rank . "</td>";
                echo "<td><img src='Logos/HEADSHOTS/MLB/" . htmlspecialchars($playerId) . ".png' class='player-headshot' onerror='this.style.display=\"none\"'>" . htmlspecialchars($playerName) . "</td>";
                echo "<td><span class='team-color' style='background-color: " . $teamColor . "'></span>" . htmlspecialchars($teamAbbr) . "</td>";
                echo "<td>" . htmlspecialchars($finalStat) . "</td>";
                echo "</tr>";

                $rank++;
            }
        }
        echo "</table>";
    }

    // Output SQL statements (for debugging purposes)
    echo "<div class='sql-statements'>";
    echo "<h3>SQL UPDATE Statements:</h3>";
    foreach ($sqlStatements as $statement) {
        echo htmlspecialchars($statement) . ";<br><br>";
    }
    echo "</div>";
}

// Headshot Processing
$downloadedCount = 0;
$skippedCount = 0;

foreach ($playerIds as $playerId) {
    // Build the save path using the player ID.
    $savePath = SERVER_USERNAME . "getStockPanel/Logos/HEADSHOTS/MLB/" . $playerId . ".png"; 
    // Build the headshot image URL dynamically.
    $imageUrl = "https://a.espncdn.com/combiner/i?img=/i/headshots/mlb/players/full/" . $playerId . ".png&w=30&h=30"; 

    if (!file_exists($savePath)) {
        $ch = curl_init($imageUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $data = curl_exec($ch);
        curl_close($ch);
        if ($data !== false) {
            file_put_contents($savePath, $data);
            $downloadedCount++;
        } else {
            echo "Error downloading image for player " . htmlspecialchars($playerId) . "<br>";
            continue;
        }
    } else {
        $skippedCount++;
    }
}

// Output completion message
echo "<p style='text-align: center; margin: 20px;'>Headshot Processing Complete: Downloaded " . $downloadedCount . " images, Skipped " . $skippedCount . " images.</p>";
echo "</div></body></html>";
?>