<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/config.php';

// Create a PDO database connection.
try {
    $db = new PDO("mysql:host=$host_gscroll;dbname=$database_gscroll", $username_gscroll, $password_gscroll);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database Connection Error: " . $e->getMessage());
}

// NBA Teams lookup array
$nbaTeams = array(
  array("id" => "1",  "abbreviation" => "ATL",  "color" => "c8102e", "alternateColor" => "fdb927", "name" => "HAWKS"),
    array("id" => "2",  "abbreviation" => "BOS",  "color" => "008348", "alternateColor" => "ffffff", "name" => "CELTICS"),
    array("id" => "17", "abbreviation" => "BKN",  "color" => "ffffff", "alternateColor" => "ffffff", "name" => "NETS"),
    array("id" => "30", "abbreviation" => "CHA",  "color" => "008ca8", "alternateColor" => "1d1160", "name" => "HORNETS"),
    array("id" => "4",  "abbreviation" => "CHI",  "color" => "ce1141", "alternateColor" => "ffffff", "name" => "BULLS"),
    array("id" => "5",  "abbreviation" => "CLE",  "color" => "860038", "alternateColor" => "bc945c", "name" => "CAVS"),
    array("id" => "6",  "abbreviation" => "DAL",  "color" => "0064b1", "alternateColor" => "bbc4ca", "name" => "MAVS"),
    array("id" => "7",  "abbreviation" => "DEN",  "color" => "0e2240", "alternateColor" => "fec524", "name" => "NUGGETS"),
    array("id" => "8",  "abbreviation" => "DET",  "color" => "1d428a", "alternateColor" => "c8102e", "name" => "PISTONS"),
    array("id" => "9",  "abbreviation" => "GS",   "color" => "fdb927", "alternateColor" => "1d428a", "name" => "WARRIORS"),
    array("id" => "10", "abbreviation" => "HOU",  "color" => "ce1141", "alternateColor" => "ffffff", "name" => "ROCKETS"),
    array("id" => "11", "abbreviation" => "IND",  "color" => "002d62", "alternateColor" => "fdbb30", "name" => "PACERS"),
    array("id" => "12", "abbreviation" => "LAC",  "color" => "12173f", "alternateColor" => "c8102e", "name" => "CLIPPERS"),
    array("id" => "13", "abbreviation" => "LAL",  "color" => "552583", "alternateColor" => "fdb927", "name" => "LAKERS"),
    array("id" => "29", "abbreviation" => "MEM",  "color" => "5d76a9", "alternateColor" => "12173f", "name" => "GRIZZLIES"),
    array("id" => "14", "abbreviation" => "MIA",  "color" => "98002e", "alternateColor" => "ffffff", "name" => "HEAT"),
    array("id" => "15", "abbreviation" => "MIL",  "color" => "00471b", "alternateColor" => "eee1c6", "name" => "BUCKS"),
    array("id" => "16", "abbreviation" => "MIN",  "color" => "266092", "alternateColor" => "79bc43", "name" => "WOLVES"),
    array("id" => "3",  "abbreviation" => "NO",   "color" => "0a2240", "alternateColor" => "b4975a", "name" => "PELICANS"),
    array("id" => "18", "abbreviation" => "NY",   "color" => "1d428a", "alternateColor" => "f58426", "name" => "KNICKS"),
    array("id" => "25", "abbreviation" => "OKC",  "color" => "007ac1", "alternateColor" => "ef3b24", "name" => "THUNDER"),
    array("id" => "19", "abbreviation" => "ORL",  "color" => "0077c0", "alternateColor" => "c4ced4", "name" => "MAGIC"),
    array("id" => "20", "abbreviation" => "PHI",  "color" => "1d428a", "alternateColor" => "e01234", "name" => "SIXERS"),
    array("id" => "21", "abbreviation" => "PHX",  "color" => "29127a", "alternateColor" => "e56020", "name" => "SUNS"),
    array("id" => "22", "abbreviation" => "POR",  "color" => "e03a3e", "alternateColor" => "ffffff", "name" => "BLAZERS"),
    array("id" => "23", "abbreviation" => "SAC",  "color" => "5a2d81", "alternateColor" => "6a7a82", "name" => "KINGS"),
    array("id" => "24", "abbreviation" => "SA",   "color" => "c4ced4", "alternateColor" => "ffffff", "name" => "SPURS"),
    array("id" => "28", "abbreviation" => "TOR",  "color" => "d91244", "alternateColor" => "ffffff", "name" => "RAPTORS"),
    array("id" => "26", "abbreviation" => "UTAH", "color" => "fff21f", "alternateColor" => "002b5c", "name" => "JAZZ"),
    array("id" => "27", "abbreviation" => "WSH",  "color" => "e31837", "alternateColor" => "002b5c", "name" => "WIZARDS")
);

function curlFetch($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'cURL error when fetching ' . htmlspecialchars($url) . ': ' . curl_error($ch) . "<br>";
        curl_close($ch);
        return false;
    }
    curl_close($ch);
    return json_decode($response, true);
}

// Start HTML output
echo <<<HTML
<!DOCTYPE html>
<html>
<head>
    <title>NBA Leaders 2024</title>
    <style>
        .stats-container {
            max-width: 1200px;
            margin: 20px auto;
            font-family: Arial, sans-serif;
        }
        .stats-table {
            border-collapse: collapse;
            width: 100%;
            margin: 20px 0;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            background: white;
        }
        .stats-table th {
            background-color: #2c3e50;
            color: white;
            font-weight: bold;
            padding: 12px;
            text-align: left;
        }
        .stats-table td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
            vertical-align: middle;
        }
        .stats-table tr:hover {
            background-color: #f5f5f5;
            transition: background-color 0.3s;
        }
        .category-header {
            background-color: #3498db;
            color: white;
            font-size: 1.2em;
            padding: 15px;
            text-align: center;
            margin: 20px 0 10px 0;
        }
        .team-color {
            width: 20px;
            height: 20px;
            display: inline-block;
            border-radius: 50%;
            margin-right: 8px;
            vertical-align: middle;
        }
        .player-headshot {
            width: 30px;
            height: 30px;
            margin-right: 8px;
            vertical-align: middle;
        }
        .sql-statements {
            background-color: #f8f9fa;
            padding: 15px;
            margin: 20px 0;
            border-left: 4px solid #2c3e50;
            font-family: 'Courier New', Courier, monospace;
            white-space: pre-wrap;
            overflow-x: auto;
        }
    </style>
</head>
<body>
<div class="stats-container">
HTML;

$leadersUrl = "https://sports.core.api.espn.com/v2/sports/basketball/leagues/nba/seasons/2026/types/2/leaders?lang=en&region=us";
$leadersData = curlFetch($leadersUrl);
if (!$leadersData) {
    die("Error fetching leaders data.</div></body></html>");
}

$playerIds = [];
$sqlStatements = [];

if (isset($leadersData['categories'])) {
    foreach ($leadersData['categories'] as $category) {
        $categoryName = isset($category['displayName']) ? $category['displayName'] : 'N/A';
        $categoryName = str_replace('/', '-', $categoryName);

        echo "<div class='category-header'>" . htmlspecialchars($categoryName) . "</div>";
        echo "<table class='stats-table'>";
        echo "<tr><th>Rank</th><th>Player</th><th>Team</th><th>Stat Value</th></tr>";

        if (isset($category['leaders']) && is_array($category['leaders'])) {
            $rank = 1;
            foreach ($category['leaders'] as $leader) {
                if ($rank > 5) break;

                $displayValue = $leader['displayValue'] ?? 'N/A';
                $athleteData = curlFetch($leader['athlete']['$ref'] ?? '');
                $playerName = $athleteData['fullName'] ?? 'N/A';

                $playerId = 'N/A';
                if (preg_match('/athletes\/(\d+)/', $leader['athlete']['$ref'], $matches)) {
                    $playerId = $matches[1];
                    $playerIds[] = $playerId;
                }

                $teamData = curlFetch($leader['team']['$ref'] ?? '');
                $teamAbbr = $teamData['abbreviation'] ?? 'N/A';

                $red = $green = $blue = $redAlt = $greenAlt = $blueAlt = 0;
                $teamColor = '#000000';
                foreach ($nbaTeams as $t) {
                    if ($t['abbreviation'] === $teamAbbr) {
                        $teamColor = '#' . $t['color'];
                        $main = $t['color'];
                        $alt = $t['alternateColor'];
                        $red = hexdec(substr($main, 0, 2));
                        $green = hexdec(substr($main, 2, 2));
                        $blue = hexdec(substr($main, 4, 2));
                        $redAlt = hexdec(substr($alt, 0, 2));
                        $greenAlt = hexdec(substr($alt, 2, 2));
                        $blueAlt = hexdec(substr($alt, 4, 2));
                        break;
                    }
                }

                // Generate SQL UPDATE statement and execute it
                $sql = "UPDATE player_stats SET 
                    Player = '" . addslashes($playerName) . "',
                    Stat_Value = '" . addslashes($displayValue) . "',
                    Team = '" . addslashes($teamAbbr) . "',
                    Red = $red,
                    Green = $green,
                    Blue = $blue,
                    Red_ALT = $redAlt,
                    Green_ALT = $greenAlt,
                    Blue_ALT = $blueAlt,
                    ID = '" . addslashes($playerId) . "'
                    WHERE Rank = $rank 
                    AND Category = '" . addslashes($categoryName) . "' 
                    AND league = 'NBA'";
                $sqlStatements[] = $sql;

                try {
                    $db->exec($sql);
                } catch (PDOException $e) {
                    echo "Error updating record for player " . htmlspecialchars($playerName) . ": " . $e->getMessage() . "<br>";
                }

                // Output table row
                echo "<tr>";
                echo "<td>" . $rank . "</td>";
                echo "<td><img src='Logos/HEADSHOTS/NBA/" . htmlspecialchars($playerId) . ".png' class='player-headshot' onerror='this.style.display=\"none\"'>" . htmlspecialchars($playerName) . "</td>";
                echo "<td><span class='team-color' style='background-color: " . $teamColor . "'></span>" . htmlspecialchars($teamAbbr) . "</td>";
                echo "<td>" . htmlspecialchars($displayValue) . "</td>";
                echo "</tr>";

                $rank++;
            }
        }
        echo "</table>";
    }

    // Output all SQL statements (for debugging purposes)
    echo "<div class='sql-statements'>";
    echo "<h3>SQL UPDATE Statements:</h3>";
    foreach ($sqlStatements as $statement) {
        echo htmlspecialchars($statement) . ";<br><br>";
    }
    echo "</div>";
}

// Headshot Processing (updated)
$downloadedCount = 0;
$skippedCount = 0;

foreach ($playerIds as $playerId) {
    // Build the save path using the player ID.
    $savePath = SERVER_USERNAME . "getStockPanel/Logos/HEADSHOTS/NBA/" . $playerId . ".png"; 
    // Build the headshot image URL dynamically.
    $imageUrl = "https://a.espncdn.com/combiner/i?img=/i/headshots/nba/players/full/" . $playerId . ".png&w=30&h=30"; 

    if (!file_exists($savePath)) {
        $ch = curl_init($imageUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $data = curl_exec($ch);
        curl_close($ch);
        if ($data !== false) {
            file_put_contents($savePath, $data);
            $downloadedCount++;
        } else {
            echo "Error downloading image for player " . htmlspecialchars($playerId) . "<br>";
            continue;
        }
    } else {
        $skippedCount++;
    }
}

// Output completion message
echo "<p style='text-align: center; margin: 20px;'>Headshot Processing Complete: Downloaded " . $downloadedCount . " images, Skipped " . $skippedCount . " images.</p>";
echo "</div></body></html>";
?>
