<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once $_SERVER['DOCUMENT_ROOT'] . '/config.php';

// Create the database connection.
try {
    $db = new PDO("mysql:host=$host_gscroll;dbname=$database_gscroll", $username_gscroll, $password_gscroll);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database Connection Error: " . $e->getMessage());
}

$Teams = array(
    array("id" => "2", "abbreviation" => "AUB", "color" => "002b5c", "alternateColor" => "f26522", "name" => "TIGERS"),
    array("id" => "8", "abbreviation" => "ARK", "color" => "a41f35", "alternateColor" => "ffffff", "name" => "RAZORBACKS"),
    array("id" => "57", "abbreviation" => "FLA", "color" => "0021a5", "alternateColor" => "fa4616", "name" => "GATORS"),
    array("id" => "61", "abbreviation" => "UGA", "color" => "ba0c2f", "alternateColor" => "ffffff", "name" => "BULLDOGS"),
    array("id" => "96", "abbreviation" => "UK", "color" => "0033a0", "alternateColor" => "ffffff", "name" => "WILDCATS"),
    array("id" => "99", "abbreviation" => "LSU", "color" => "461d7c", "alternateColor" => "fdd023", "name" => "TIGERS"),
    array("id" => "142", "abbreviation" => "MIZ", "color" => "f1b82d", "alternateColor" => "000000", "name" => "TIGERS"),
    array("id" => "145", "abbreviation" => "MISS", "color" => "13294b", "alternateColor" => "c8102e", "name" => "REBELS"),
    array("id" => "201", "abbreviation" => "OU", "color" => "a32036", "alternateColor" => "ffffff", "name" => "SOONERS"),
    array("id" => "238", "abbreviation" => "VAN", "color" => "000000", "alternateColor" => "231f20", "name" => "COMMODORES"),
    array("id" => "245", "abbreviation" => "TA&M", "color" => "500000", "alternateColor" => "ffffff", "name" => "AGGIES"),
    array("id" => "251", "abbreviation" => "TEX", "color" => "c15d26", "alternateColor" => "ffffff", "name" => "LONGHORNS"),
    array("id" => "333", "abbreviation" => "ALA", "color" => "9e1632", "alternateColor" => "ffffff", "name" => "CRIMSON TI"),
    array("id" => "344", "abbreviation" => "MSST", "color" => "5d1725", "alternateColor" => "c1c6c8", "name" => "BULLDOGS"),
    array("id" => "2579", "abbreviation" => "SC", "color" => "73000a", "alternateColor" => "ffffff", "name" => "GAMECOCKS"),
    array("id" => "2633", "abbreviation" => "TENN", "color" => "ff8200", "alternateColor" => "58595b", "name" => "VOLUNTEERS"),



    // ACC teams

    array("id" => "24", "abbreviation" => "STAN", "color" => "8c1515", "alternateColor" => "ffffff", "name" => "CARDINAL"),
    array("id" => "25", "abbreviation" => "CAL", "color" => "031522", "alternateColor" => "ffc423", "name" => "GOLDEN BEA"),
    array("id" => "52", "abbreviation" => "FSU", "color" => "782f40", "alternateColor" => "ceb888", "name" => "SEMINOLES"),
    array("id" => "59", "abbreviation" => "GT", "color" => "003057", "alternateColor" => "b3a369", "name" => "YELLOW JAC"),
    array("id" => "97", "abbreviation" => "LOU", "color" => "c9001f", "alternateColor" => "000000", "name" => "CARDINALS"),
    array("id" => "103", "abbreviation" => "BC", "color" => "8c2232", "alternateColor" => "dbcca6", "name" => "EAGLES"),
    array("id" => "150", "abbreviation" => "DUKE", "color" => "013088", "alternateColor" => "ffffff", "name" => "BLUE DEVIL"),
    array("id" => "152", "abbreviation" => "NCSU", "color" => "cc0000", "alternateColor" => "ffffff", "name" => "WOLFPACK"),
    array("id" => "153", "abbreviation" => "UNC", "color" => "7bafd4", "alternateColor" => "13294b", "name" => "TAR HEELS"),
    array("id" => "154", "abbreviation" => "WAKE", "color" => "000000", "alternateColor" => "ceb888", "name" => "DEMON DEAC"),
    array("id" => "183", "abbreviation" => "SYR", "color" => "ff6500", "alternateColor" => "000e54", "name" => "ORANGE"),
    array("id" => "221", "abbreviation" => "PITT", "color" => "003263", "alternateColor" => "231f20", "name" => "PANTHERS"),
    array("id" => "228", "abbreviation" => "CLEM", "color" => "f56600", "alternateColor" => "522d80", "name" => "TIGERS"),
    array("id" => "258", "abbreviation" => "UVA", "color" => "232d4b", "alternateColor" => "f84c1e", "name" => "CAVALIERS"),
    array("id" => "259", "abbreviation" => "VT", "color" => "630031", "alternateColor" => "cf4520", "name" => "HOKIES"),
    array("id" => "2390", "abbreviation" => "MIA", "color" => "005030", "alternateColor" => "f47321", "name" => "HURRICANES"),
    array("id" => "2567", "abbreviation" => "SMU", "color" => "354ca1", "alternateColor" => "cc0035", "name" => "MUSTANGS"),



    // Big 12 teams

    array("id" => "9", "abbreviation" => "ASU", "color" => "8e0c3a", "alternateColor" => "ffc72c", "name" => "SUN DEVILS"),
    array("id" => "12", "abbreviation" => "ARIZ", "color" => "0c234b", "alternateColor" => "ab0520", "name" => "WILDCATS"),
    array("id" => "38", "abbreviation" => "COLO", "color" => "000000", "alternateColor" => "cfb87c", "name" => "BUFFALOES"),
    array("id" => "66", "abbreviation" => "ISU", "color" => "822433", "alternateColor" => "fdca2f", "name" => "CYCLONES"),
    array("id" => "197", "abbreviation" => "OKST", "color" => "000000", "alternateColor" => "dddddd", "name" => "COWBOYS"),
    array("id" => "239", "abbreviation" => "BAY", "color" => "154734", "alternateColor" => "ffb81c", "name" => "BEARS"),
    array("id" => "248", "abbreviation" => "HOU", "color" => "c92a39", "alternateColor" => "ffffff", "name" => "COUGARS"),
    array("id" => "252", "abbreviation" => "BYU", "color" => "003da5", "alternateColor" => "ffffff", "name" => "COUGARS"),
    array("id" => "254", "abbreviation" => "UTAH", "color" => "ea002a", "alternateColor" => "ffffff", "name" => "UTES"),
    array("id" => "277", "abbreviation" => "WVU", "color" => "002855", "alternateColor" => "eaaa00", "name" => "MOUNTAINEE"),
    array("id" => "2116", "abbreviation" => "UCF", "color" => "000000", "alternateColor" => "b4a269", "name" => "KNIGHTS"),
    array("id" => "2132", "abbreviation" => "CIN", "color" => "000000", "alternateColor" => "717073", "name" => "BEARCATS"),
    array("id" => "2305", "abbreviation" => "KU", "color" => "0051ba", "alternateColor" => "e8000d", "name" => "JAYHAWKS"),
    array("id" => "2306", "abbreviation" => "KSU", "color" => "3c0969", "alternateColor" => "e2e3e4", "name" => "WILDCATS"),
    array("id" => "2628", "abbreviation" => "TCU", "color" => "4d1979", "alternateColor" => "f1f2f3", "name" => "H-FROGS"),
    array("id" => "2641", "abbreviation" => "TTU", "color" => "000000", "alternateColor" => "da291c", "name" => "RED RAIDER"),



    // Big 10 teams

    array("id" => "26", "abbreviation" => "UCLA", "color" => "2774ae", "alternateColor" => "f2a900", "name" => "BRUINS"),
    array("id" => "30", "abbreviation" => "USC", "color" => "9e2237", "alternateColor" => "ffcc00", "name" => "TROJANS"),
    array("id" => "77", "abbreviation" => "NU", "color" => "582c83", "alternateColor" => "ffffff", "name" => "WILDCATS"),
    array("id" => "84", "abbreviation" => "IU", "color" => "990000", "alternateColor" => "edebeb", "name" => "HOOSIERS"),
    array("id" => "120", "abbreviation" => "MD", "color" => "D5002B", "alternateColor" => "ffcd00", "name" => "TERRAPINS"),
    array("id" => "127", "abbreviation" => "MSU", "color" => "18453b", "alternateColor" => "ffffff", "name" => "SPARTANS"),
    array("id" => "130", "abbreviation" => "MICH", "color" => "00274c", "alternateColor" => "ffcb05", "name" => "WOLVERINES"),
    array("id" => "135", "abbreviation" => "MINN", "color" => "5e0a2f", "alternateColor" => "fab41c", "name" => "GOLDEN GOP"),
    array("id" => "158", "abbreviation" => "NEB", "color" => "d00000", "alternateColor" => "ffffff", "name" => "CORNHUSKER"),
    array("id" => "164", "abbreviation" => "RUTG", "color" => "d21034", "alternateColor" => "ffffff", "name" => "SCARLET KN"),
    array("id" => "194", "abbreviation" => "OSU", "color" => "ce1141", "alternateColor" => "505056", "name" => "BUCKEYES"),
    array("id" => "213", "abbreviation" => "PSU", "color" => "00265D", "alternateColor" => "002e5c", "name" => "NITTANY LI"),
    array("id" => "264", "abbreviation" => "WASH", "color" => "33006f", "alternateColor" => "e8d3a2", "name" => "HUSKIES"),
    array("id" => "275", "abbreviation" => "WIS", "color" => "c4012f", "alternateColor" => "ffffff", "name" => "BADGERS"),
    array("id" => "356", "abbreviation" => "ILL", "color" => "ff5f05", "alternateColor" => "13294b", "name" => "FIGHTING I"),
    array("id" => "2294", "abbreviation" => "IOWA", "color" => "000000", "alternateColor" => "fcd116", "name" => "HAWKEYES"),
    array("id" => "2483", "abbreviation" => "ORE", "color" => "007030", "alternateColor" => "fee11a", "name" => "DUCKS"),
    array("id" => "2509", "abbreviation" => "PUR", "color" => "000000", "alternateColor" => "cfb991", "name" => "BOILERMAKE"),



    // MW teams
  array("id" => "21", "abbreviation" => "SDSU", "color" => "c41230", "alternateColor" => "000000", "name" => "AZTECS"),
    array("id" => "23", "abbreviation" => "SJSU", "color" => "005893", "alternateColor" => "fdba31", "name" => "SPARTANS"),
    array("id" => "36", "abbreviation" => "CSU", "color" => "1e4d2b", "alternateColor" => "c8c372", "name" => "RAMS"),
    array("id" => "62", "abbreviation" => "HAW", "color" => "003420", "alternateColor" => "ffffff", "name" => "RAINBOW WA"),
    array("id" => "68", "abbreviation" => "BOIS", "color" => "0033a0", "alternateColor" => "fa4616", "name" => "BRONCOS"),
    array("id" => "167", "abbreviation" => "UNM", "color" => "000000", "alternateColor" => "231f20", "name" => "LOBOS"),
    array("id" => "278", "abbreviation" => "FRES", "color" => "c41230", "alternateColor" => "13284c", "name" => "BULLDOGS"),
    array("id" => "328", "abbreviation" => "USU", "color" => "00263a", "alternateColor" => "949ca1", "name" => "AGGIES"),
    array("id" => "2005", "abbreviation" => "AFA", "color" => "004a7b", "alternateColor" => "ffffff", "name" => "FALCONS"),
    array("id" => "2439", "abbreviation" => "UNLV", "color" => "b10202", "alternateColor" => "ffffff", "name" => "REBELS"),
    array("id" => "2440", "abbreviation" => "NEV", "color" => "002d62", "alternateColor" => "ffffff", "name" => "WOLF PACK"),
    array("id" => "2751", "abbreviation" => "WYO", "color" => "492f24", "alternateColor" => "ffc425", "name" => "COWBOYS"),

    // Sunbelt teams

    array("id" => "6", "abbreviation" => "USA", "color" => "003E7E", "alternateColor" => "", "name" => "JAGUARS"),
    array("id" => "256", "abbreviation" => "JMU", "color" => "450084", "alternateColor" => "b5a068", "name" => "DUKES"),
    array("id" => "276", "abbreviation" => "MRSH", "color" => "00ae42", "alternateColor" => "be854c", "name" => "THUNDERING"),
    array("id" => "290", "abbreviation" => "GASO", "color" => "003775", "alternateColor" => "f0f0f0", "name" => "EAGLES"),
    array("id" => "295", "abbreviation" => "ODU", "color" => "00507d", "alternateColor" => "a1d2f1", "name" => "MONARCHS"),
    array("id" => "309", "abbreviation" => "UL", "color" => "ce181e", "alternateColor" => "ffffff", "name" => "RAGIN' CAJ"),
    array("id" => "324", "abbreviation" => "CCU", "color" => "007073", "alternateColor" => "876447", "name" => "CHANTICLEE"),
    array("id" => "326", "abbreviation" => "TXST", "color" => "4e1719", "alternateColor" => "b4975a", "name" => "BOBCATS"),
    array("id" => "2026", "abbreviation" => "APP", "color" => "000000", "alternateColor" => "ffcd00", "name" => "MOUNTAINEE"),
    array("id" => "2032", "abbreviation" => "ARST", "color" => "e81018", "alternateColor" => "000000", "name" => "RED WOLVES"),
    array("id" => "2247", "abbreviation" => "GAST", "color" => "1e539a", "alternateColor" => "ebebeb", "name" => "PANTHERS"),
    array("id" => "2433", "abbreviation" => "ULM", "color" => "231F20", "alternateColor" => "b18445", "name" => "WARHAWKS"),
    array("id" => "2572", "abbreviation" => "USM", "color" => "FFAA3C", "alternateColor" => "ffc423", "name" => "GOLDEN EAG"),
    array("id" => "2653", "abbreviation" => "TROY", "color" => "AE0210", "alternateColor" => "88898c", "name" => "TROJANS"),



    // AAC teams
   array("id" => "5", "abbreviation" => "UAB", "color" => "003b28", "alternateColor" => "ffc845", "name" => "BLAZERS"),
    array("id" => "58", "abbreviation" => "USF", "color" => "004A36", "alternateColor" => "231f20", "name" => "BULLS"),
    array("id" => "151", "abbreviation" => "ECU", "color" => "4b1869", "alternateColor" => "f0907b", "name" => "PIRATES"),
    array("id" => "202", "abbreviation" => "TLSA", "color" => "003595", "alternateColor" => "d0b787", "name" => "GOLDEN HUR"),
    array("id" => "218", "abbreviation" => "TEM", "color" => "A80532", "alternateColor" => "a7a9ac", "name" => "OWLS"),
    array("id" => "235", "abbreviation" => "MEM", "color" => "004991", "alternateColor" => "8e908f", "name" => "TIGERS"),
    array("id" => "242", "abbreviation" => "RICE", "color" => "d1d5d8", "alternateColor" => "003d7d", "name" => "OWLS"),
    array("id" => "249", "abbreviation" => "UNT", "color" => "ffffff", "alternateColor" => "000000", "name" => "MEAN GREEN"),
    array("id" => "349", "abbreviation" => "ARMY", "color" => "ce9c00", "alternateColor" => "231f20", "name" => "BLACK KNIG"),
    array("id" => "2226", "abbreviation" => "FAU", "color" => "00447c", "alternateColor" => "d31245", "name" => "OWLS"),
    array("id" => "2426", "abbreviation" => "NAVY", "color" => "00225b", "alternateColor" => "b5a67c", "name" => "MIDSHIPMEN"),
    array("id" => "2429", "abbreviation" => "CLT", "color" => "ffffff", "alternateColor" => "cfab7a", "name" => "49ERS"),
    array("id" => "2636", "abbreviation" => "UTSA", "color" => "002A5C", "alternateColor" => "f47321", "name" => "ROADRUNNER"),
    array("id" => "2655", "abbreviation" => "TULN", "color" => "006547", "alternateColor" => "468ac9", "name" => "GREEN WAVE"),

    // Final set (unlabeled)
    array("id" => "231",  "abbreviation" => "FUR",  "color" => "582c83", "alternateColor" => "808080", "name" => "PALADINS"),
    array("id" => "236",  "abbreviation" => "UTC",  "color" => "00386b", "alternateColor" => "eeb111", "name" => "MOCS"),
    array("id" => "2193", "abbreviation" => "ETSU", "color" => "002d61", "alternateColor" => "ffc72c", "name" => "BUCCANEERS"),
    array("id" => "2382", "abbreviation" => "MER",  "color" => "ff7f29", "alternateColor" => "000000", "name" => "BEARS"),
    array("id" => "2535", "abbreviation" => "SAM",  "color" => "005485", "alternateColor" => "bb133e", "name" => "BULLDOGS"),
    array("id" => "2643", "abbreviation" => "CIT",  "color" => "002b5c", "alternateColor" => "ffffff", "name" => "BULLDOGS"),
    array("id" => "2678", "abbreviation" => "VMI",  "color" => "ae122a", "alternateColor" => "ffcd00", "name" => "KEYDETS"),
    array("id" => "2717", "abbreviation" => "WCU",  "color" => "492F91", "alternateColor" => "d4af37", "name" => "CATAMOUNTS"),
    array("id" => "2747", "abbreviation" => "WOF",  "color" => "533B23", "alternateColor" => "000000", "name" => "TERRIERS"),
    array("id" => "87",   "abbreviation" => "ND",   "color" => "0C2340", "alternateColor" => "ae9142", "name" => "NOTRE DAME")
);


function curlFetch($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'cURL error when fetching ' . htmlspecialchars($url) . ': ' . curl_error($ch) . "<br>";
        curl_close($ch);
        return false;
    }
    curl_close($ch);
    return json_decode($response, true);
}

// Start HTML output
echo <<<HTML
<!DOCTYPE html>
<html>
<head>
    <title>NCAAF Leaders 2024</title>
    <style>
        .stats-container {
            max-width: 1200px;
            margin: 20px auto;
            font-family: Arial, sans-serif;
        }
        .stats-table {
            border-collapse: collapse;
            width: 100%;
            margin: 20px 0;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            background: white;
        }
        .stats-table th {
            background-color: #2c3e50;
            color: white;
            font-weight: bold;
            padding: 12px;
            text-align: left;
        }
        .stats-table td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
            vertical-align: middle;
        }
        .stats-table tr:hover {
            background-color: #f5f5f5;
            transition: background-color 0.3s;
        }
        .category-header {
            background-color: #3498db;
            color: white;
            font-size: 1.2em;
            padding: 15px;
            text-align: center;
            margin: 20px 0 10px 0;
        }
        .team-color {
            width: 20px;
            height: 20px;
            display: inline-block;
            border-radius: 50%;
            margin-right: 8px;
            vertical-align: middle;
        }
        .player-headshot {
            width: 30px;
            height: 30px;
            margin-right: 8px;
            vertical-align: middle;
        }
        .sql-statements {
            background-color: #f8f9fa;
            padding: 15px;
            margin: 20px 0;
            border-left: 4px solid #2c3e50;
            font-family: 'Courier New', Courier, monospace;
            white-space: pre-wrap;
            overflow-x: auto;
        }
    </style>
</head>
<body>
<div class="stats-container">
HTML;

$leadersUrl = "https://sports.core.api.espn.com/v2/sports/football/leagues/college-football/seasons/2025/types/2/leaders?lang=en&region=us";
$leadersData = curlFetch($leadersUrl);
if (!$leadersData) {
    die("Error fetching leaders data.</div></body></html>");
}

$playerIds = [];
$sqlStatements = [];

if (isset($leadersData['categories'])) {
    foreach ($leadersData['categories'] as $category) {
        // Use displayName for header; also prepare a comparison key by lowercasing and removing spaces.
        $categoryName = isset($category['displayName']) ? $category['displayName'] : 'N/A';
        $categoryCompare = str_replace(' ', '', strtolower($categoryName));

        echo "<div class='category-header'>" . htmlspecialchars($categoryName) . "</div>";
        echo "<table class='stats-table'>";
        echo "<tr><th>Rank</th><th>Player</th><th>Team</th><th>Stat Value</th></tr>";

        if (isset($category['leaders']) && is_array($category['leaders'])) {
            $rank = 1;
            foreach ($category['leaders'] as $leader) {
                if ($rank > 5) break;

                // For "Home Runs", use the numeric value instead of the displayValue.
                if ($categoryCompare === 'homeruns' && isset($leader['value'])) {
                    $finalStat = $leader['value'];
                } else {
                    $finalStat = $leader['value'] ?? 'N/A';
                }

                // Fetch athlete details.
                $athleteData = curlFetch($leader['athlete']['$ref'] ?? '');
                $playerName = $athleteData['fullName'] ?? 'N/A';

                $playerId = 'N/A';
                if (preg_match('/athletes\/(\d+)/', $leader['athlete']['$ref'] ?? '', $matches)) {
                    $playerId = $matches[1];
                    $playerIds[] = $playerId;
                }

                // Fetch team details.
                $teamData = curlFetch($leader['team']['$ref'] ?? '');
                $teamAbbr = $teamData['abbreviation'] ?? 'N/A';

            
                
                $red = $green = $blue = $redAlt = $greenAlt = $blueAlt = 0;
$teamColor = '#000000';
foreach ($Teams as $t) {
    if ($t['abbreviation'] === $teamAbbr) {
        $teamColor = '#' . $t['color'];
        $main = $t['color'];
        $alt = $t['alternateColor'];
        $red = hexdec(substr($main, 0, 2));
        $green = hexdec(substr($main, 2, 2));
        $blue = hexdec(substr($main, 4, 2));
        $redAlt = hexdec(substr($alt, 0, 2));
        $greenAlt = hexdec(substr($alt, 2, 2));
        $blueAlt = hexdec(substr($alt, 4, 2));

        // If main RGB is black, change to white.
        if ($red == 0 && $green == 0 && $blue == 0) {
            $red = 255;
            $green = 255;
            $blue = 255;
        }
        // If alternate RGB is black, change to white.
        if ($redAlt == 0 && $greenAlt == 0 && $blueAlt == 0) {
            $redAlt = 255;
            $greenAlt = 255;
            $blueAlt = 255;
        }
        break;
    }
}


                // Generate and execute SQL UPDATE statement using the parsed finalStat.
                $sql = "UPDATE player_stats SET 
                    Player = '" . addslashes($playerName) . "',
                    Stat_Value = '" . addslashes($finalStat) . "',
                    Team = '" . addslashes($teamAbbr) . "',
                    Red = $red,
                    Green = $green,
                    Blue = $blue,
                    Red_ALT = $redAlt,
                    Green_ALT = $greenAlt,
                    Blue_ALT = $blueAlt,
                    ID = '" . addslashes($playerId) . "'
                    WHERE Rank = $rank 
                    AND Category = '" . addslashes($categoryName) . "' 
                    AND league = 'NCAAF'";
                $sqlStatements[] = $sql;

                try {
                    $db->exec($sql);
                } catch (PDOException $e) {
                    echo "Error updating record for player " . htmlspecialchars($playerName) . ": " . $e->getMessage() . "<br>";
                }

                // Output table row.
                echo "<tr>";
                echo "<td>" . $rank . "</td>";
                echo "<td><img src='Logos/HEADSHOTS/NCAAF/" . htmlspecialchars($playerId) . ".png' class='player-headshot' onerror='this.style.display=\"none\"'>" . htmlspecialchars($playerName) . "</td>";
                echo "<td><span class='team-color' style='background-color: " . $teamColor . "'></span>" . htmlspecialchars($teamAbbr) . "</td>";
                echo "<td>" . htmlspecialchars($finalStat) . "</td>";
                echo "</tr>";

                $rank++;
            }
        }
        echo "</table>";
    }

    // Output SQL statements (for debugging purposes)
    echo "<div class='sql-statements'>";
    echo "<h3>SQL UPDATE Statements:</h3>";
    foreach ($sqlStatements as $statement) {
        echo htmlspecialchars($statement) . ";<br><br>";
    }
    echo "</div>";
}

// Headshot Processing
$downloadedCount = 0;
$skippedCount = 0;

foreach ($playerIds as $playerId) {
    // Build the save path using the player ID.
    $savePath = SERVER_USERNAME . "getStockPanel/Logos/HEADSHOTS/NCAAF/" . $playerId . ".png"; 
    // Build the headshot image URL dynamically.
    $imageUrl = "https://a.espncdn.com/combiner/i?img=/i/headshots/college-football/players/full/" . $playerId . ".png&w=30&h=30"; 

    if (!file_exists($savePath)) {
        $ch = curl_init($imageUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $data = curl_exec($ch);
        curl_close($ch);
        if ($data !== false) {
            file_put_contents($savePath, $data);
            $downloadedCount++;
        } else {
            echo "Error downloading image for player " . htmlspecialchars($playerId) . "<br>";
            continue;
        }
    } else {
        $skippedCount++;
    }
}

// Output completion message
echo "<p style='text-align: center; margin: 20px;'>Headshot Processing Complete: Downloaded " . $downloadedCount . " images, Skipped " . $skippedCount . " images.</p>";
echo "</div></body></html>";
?>
