<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/config.php';

// Create a PDO database connection.
try {
    $db = new PDO("mysql:host=$host_gscroll;dbname=$database_gscroll", $username_gscroll, $password_gscroll);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database Connection Error: " . $e->getMessage());
}

// NFL Teams lookup array
$nflTeams = array(
    array("id" => "22", "abbreviation" => "ARI", "color" => "a40227", "alternateColor" => "ffffff", "name" => "CARDINALS"),
    array("id" => "1",  "abbreviation" => "ATL", "color" => "a71930", "alternateColor" => "ffffff", "name" => "FALCONS"),
    array("id" => "33", "abbreviation" => "BAL", "color" => "29126f", "alternateColor" => "ffffff", "name" => "RAVENS"),
    array("id" => "2",  "abbreviation" => "BUF", "color" => "00338d", "alternateColor" => "d50a0a", "name" => "BILLS"),
    array("id" => "29", "abbreviation" => "CAR", "color" => "0085ca", "alternateColor" => "ffffff", "name" => "PANTHERS"),
    array("id" => "3",  "abbreviation" => "CHI", "color" => "0b1c3a", "alternateColor" => "e64100", "name" => "BEARS"),
    array("id" => "4",  "abbreviation" => "CIN", "color" => "fb4f14", "alternateColor" => "ffffff", "name" => "BENGALS"),
    array("id" => "5",  "abbreviation" => "CLE", "color" => "472a08", "alternateColor" => "ff3c00", "name" => "BROWNS"),
    array("id" => "6",  "abbreviation" => "DAL", "color" => "002a5c", "alternateColor" => "b0b7bc", "name" => "COWBOYS"),
    array("id" => "7",  "abbreviation" => "DEN", "color" => "0a2343", "alternateColor" => "fc4c02", "name" => "BRONCOS"),
    array("id" => "8",  "abbreviation" => "DET", "color" => "0076b6", "alternateColor" => "bbbbbb", "name" => "LIONS"),
    array("id" => "9",  "abbreviation" => "GB",  "color" => "204e32", "alternateColor" => "ffb612", "name" => "PACKERS"),
    array("id" => "34", "abbreviation" => "HOU", "color" => "00143f", "alternateColor" => "c41230", "name" => "TEXANS"),
    array("id" => "11", "abbreviation" => "IND", "color" => "003b75", "alternateColor" => "ffffff", "name" => "COLTS"),
    array("id" => "30", "abbreviation" => "JAX", "color" => "007487", "alternateColor" => "d7a22a", "name" => "JAGUARS"),
    array("id" => "12", "abbreviation" => "KC",  "color" => "e31837", "alternateColor" => "ffb612", "name" => "CHIEFS"),
    array("id" => "13", "abbreviation" => "LV",  "color" => "000000", "alternateColor" => "a5acaf", "name" => "RAIDERS"),
    array("id" => "24", "abbreviation" => "LAC", "color" => "0080c6", "alternateColor" => "ffc20e", "name" => "CHARGERS"),
    array("id" => "14", "abbreviation" => "LAR", "color" => "003594", "alternateColor" => "ffd100", "name" => "RAMS"),
    array("id" => "15", "abbreviation" => "MIA", "color" => "008e97", "alternateColor" => "fc4c02", "name" => "DOLPHINS"),
    array("id" => "16", "abbreviation" => "MIN", "color" => "4f2683", "alternateColor" => "ffc62f", "name" => "VIKINGS"),
    array("id" => "17", "abbreviation" => "NE",  "color" => "002a5c", "alternateColor" => "c60c30", "name" => "PATRIOTS"),
    array("id" => "18", "abbreviation" => "NO",  "color" => "d3bc8d", "alternateColor" => "ffffff", "name" => "SAINTS"),
    array("id" => "19", "abbreviation" => "NYG", "color" => "003c7f", "alternateColor" => "c9243f", "name" => "GIANTS"),
    array("id" => "20", "abbreviation" => "NYJ", "color" => "115740", "alternateColor" => "ffffff", "name" => "JETS"),
    array("id" => "21", "abbreviation" => "PHI", "color" => "06424d", "alternateColor" => "a5acaf", "name" => "EAGLES"),
    array("id" => "23", "abbreviation" => "PIT", "color" => "000000", "alternateColor" => "ffb612", "name" => "STEELERS"),
    array("id" => "25", "abbreviation" => "SF",  "color" => "aa0000", "alternateColor" => "b3995d", "name" => "49ERS"),
    array("id" => "26", "abbreviation" => "SEA", "color" => "002a5c", "alternateColor" => "69be28", "name" => "SEAHAWKS"),
    array("id" => "27", "abbreviation" => "TB",  "color" => "bd1c36", "alternateColor" => "d9d9d9", "name" => "BUCCS"),
    array("id" => "10", "abbreviation" => "TEN", "color" => "4b92db", "alternateColor" => "c8102e", "name" => "TITANS"),
    array("id" => "28", "abbreviation" => "WSH", "color" => "5a1414", "alternateColor" => "ffb612", "name" => "CMDRS")
);

function curlFetch($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'cURL error when fetching ' . htmlspecialchars($url) . ': ' . curl_error($ch) . "<br>";
        curl_close($ch);
        return false;
    }
    curl_close($ch);
    return json_decode($response, true);
}

// Start HTML output
echo <<<HTML
<!DOCTYPE html>
<html>
<head>
    <title>NFL Leaders 2024</title>
    <style>
        .stats-container {
            max-width: 1200px;
            margin: 20px auto;
            font-family: Arial, sans-serif;
        }
        .stats-table {
            border-collapse: collapse;
            width: 100%;
            margin: 20px 0;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            background: white;
        }
        .stats-table th {
            background-color: #2c3e50;
            color: white;
            font-weight: bold;
            padding: 12px;
            text-align: left;
        }
        .stats-table td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
            vertical-align: middle;
        }
        .stats-table tr:hover {
            background-color: #f5f5f5;
            transition: background-color 0.3s;
        }
        .category-header {
            background-color: #3498db;
            color: white;
            font-size: 1.2em;
            padding: 15px;
            text-align: center;
            margin: 20px 0 10px 0;
        }
        .team-color {
            width: 20px;
            height: 20px;
            display: inline-block;
            border-radius: 50%;
            margin-right: 8px;
            vertical-align: middle;
        }
        .player-headshot {
            width: 30px;
            height: 30px;
            margin-right: 8px;
            vertical-align: middle;
        }
        .sql-statements {
            background-color: #f8f9fa;
            padding: 15px;
            margin: 20px 0;
            border-left: 4px solid #2c3e50;
            font-family: 'Courier New', Courier, monospace;
            white-space: pre-wrap;
            overflow-x: auto;
        }
    </style>
</head>
<body>
<div class="stats-container">
HTML;

$leadersUrl = "https://sports.core.api.espn.com/v2/sports/football/leagues/nfl/seasons/2025/types/2/leaders?lang=en&region=us";
$leadersData = curlFetch($leadersUrl);
if (!$leadersData) {
    die("Error fetching leaders data.</div></body></html>");
}

$playerIds = [];
$sqlStatements = [];

if (isset($leadersData['categories'])) {
    foreach ($leadersData['categories'] as $category) {
        $categoryName = isset($category['displayName']) ? $category['displayName'] : 'N/A';
        $categoryName = str_replace('/', '-', $categoryName);

        echo "<div class='category-header'>" . htmlspecialchars($categoryName) . "</div>";
        echo "<table class='stats-table'>";
        echo "<tr><th>Rank</th><th>Player</th><th>Team</th><th>Stat Value</th></tr>";

        if (isset($category['leaders']) && is_array($category['leaders'])) {
            $rank = 1;
            foreach ($category['leaders'] as $leader) {
                if ($rank > 5) break;

                $displayValue = $leader['displayValue'] ?? 'N/A';
                $athleteData = curlFetch($leader['athlete']['$ref'] ?? '');
                $playerName = $athleteData['fullName'] ?? 'N/A';

                $playerId = 'N/A';
                if (preg_match('/athletes\/(\d+)/', $leader['athlete']['$ref'], $matches)) {
                    $playerId = $matches[1];
                    $playerIds[] = $playerId;
                }

                $teamData = curlFetch($leader['team']['$ref'] ?? '');
                $teamAbbr = $teamData['abbreviation'] ?? 'N/A';

                $red = $green = $blue = $redAlt = $greenAlt = $blueAlt = 0;
                $teamColor = '#000000';
                foreach ($nflTeams as $t) {
                    if ($t['abbreviation'] === $teamAbbr) {
                        $teamColor = '#' . $t['color'];
                        $main = $t['color'];
                        $alt = $t['alternateColor'];
                        $red = hexdec(substr($main, 0, 2));
                        $green = hexdec(substr($main, 2, 2));
                        $blue = hexdec(substr($main, 4, 2));
                        $redAlt = hexdec(substr($alt, 0, 2));
                        $greenAlt = hexdec(substr($alt, 2, 2));
                        $blueAlt = hexdec(substr($alt, 4, 2));
                        break;
                    }
                }

                // Generate SQL UPDATE statement and execute it
                $sql = "UPDATE player_stats SET 
                    Player = '" . addslashes($playerName) . "',
                    Stat_Value = '" . addslashes($displayValue) . "',
                    Team = '" . addslashes($teamAbbr) . "',
                    Red = $red,
                    Green = $green,
                    Blue = $blue,
                    Red_ALT = $redAlt,
                    Green_ALT = $greenAlt,
                    Blue_ALT = $blueAlt,
                    ID = '" . addslashes($playerId) . "'
                    WHERE Rank = $rank 
                    AND Category = '" . addslashes($categoryName) . "' 
                    AND league = 'NFL'";
                $sqlStatements[] = $sql;

                try {
                    $db->exec($sql);
                } catch (PDOException $e) {
                    echo "Error updating record for player " . htmlspecialchars($playerName) . ": " . $e->getMessage() . "<br>";
                }

                // Output table row
                echo "<tr>";
                echo "<td>" . $rank . "</td>";
                echo "<td><img src='Logos/HEADSHOTS/NFL/" . htmlspecialchars($playerId) . ".png' class='player-headshot' onerror='this.style.display=\"none\"'>" . htmlspecialchars($playerName) . "</td>";
                echo "<td><span class='team-color' style='background-color: " . $teamColor . "'></span>" . htmlspecialchars($teamAbbr) . "</td>";
                echo "<td>" . htmlspecialchars($displayValue) . "</td>";
                echo "</tr>";

                $rank++;
            }
        }
        echo "</table>";
    }

    // Output all SQL statements (for debugging purposes)
    echo "<div class='sql-statements'>";
    echo "<h3>SQL UPDATE Statements:</h3>";
    foreach ($sqlStatements as $statement) {
        echo htmlspecialchars($statement) . ";<br><br>";
    }
    echo "</div>";
}

// Headshot Processing (updated)
$downloadedCount = 0;
$skippedCount = 0;

foreach ($playerIds as $playerId) {
    // Build the save path using the player ID.
    $savePath = SERVER_USERNAME . "getStockPanel/Logos/HEADSHOTS/NFL/" . $playerId . ".png"; 
    // Build the headshot image URL dynamically.
    $imageUrl = "https://a.espncdn.com/combiner/i?img=/i/headshots/nfl/players/full/" . $playerId . ".png&w=30&h=30"; 

    if (!file_exists($savePath)) {
        $ch = curl_init($imageUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $data = curl_exec($ch);
        curl_close($ch);
        if ($data !== false) {
            file_put_contents($savePath, $data);
            $downloadedCount++;
        } else {
            echo "Error downloading image for player " . htmlspecialchars($playerId) . "<br>";
            continue;
        }
    } else {
        $skippedCount++;
    }
}

// Output completion message
echo "<p style='text-align: center; margin: 20px;'>Headshot Processing Complete: Downloaded " . $downloadedCount . " images, Skipped " . $skippedCount . " images.</p>";
echo "</div></body></html>";
?>
