<?php
/**
 * Fetch JSON data from a given URL using cURL.
 *
 * @param string $url The URL to fetch.
 * @return array|null The decoded JSON as an associative array or null if failed.
 */
function fetchJson($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // Optionally set a timeout:
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

/**
 * Abbreviates a team name to 10 characters or less.
 * This function converts the name to uppercase. If the name length is greater than 10,
 * it simply returns the first 10 characters.
 *
 * @param string $name The original team name.
 * @return string The abbreviated team name.
 */
function abbreviateName($name) {
    $name = strtoupper($name);
    if (strlen($name) > 10) {
        // Customize abbreviation logic as needed.
        return substr($name, 0, 10);
    }
    return $name;
}

// URL to get the list of college football teams (group 8, season 2024, type 3)
$initialUrl = 'https://sports.core.api.espn.com/v2/sports/football/leagues/nfl/seasons/2024/teams?lang=en&region=us';

// Fetch the initial list
$initialData = fetchJson($initialUrl);

// Initialize an empty array for the teams
$collegeTeams = array();

// Check that the initial data contains an "items" array
if (isset($initialData['items']) && is_array($initialData['items'])) {
    // Loop over each item (each contains a "$ref" URL)
    foreach ($initialData['items'] as $item) {
        if (isset($item['$ref'])) {
            $refUrl = $item['$ref'];
            // Fetch the team details from the $ref URL
            $teamData = fetchJson($refUrl);
            if ($teamData) {
                $collegeTeams[] = array(
                    "id"              => isset($teamData['id']) ? $teamData['id'] : '',
                    "abbreviation"    => isset($teamData['abbreviation']) ? $teamData['abbreviation'] : '',
                    "color"           => isset($teamData['color']) ? $teamData['color'] : '',
                    "alternateColor"  => isset($teamData['alternateColor']) ? $teamData['alternateColor'] : '',
                    "name"            => isset($teamData['name']) ? abbreviateName($teamData['name']) : ''
                );
            }
        }
    }
}

// Output the resulting array (or use it as needed)
print_r($collegeTeams);
?>
