<?php
// Set this flag to true to display the HTML output
$debug = true;

// Hard-coded API URL for Division I season 2025
$apiUrl = "https://site.api.espn.com/apis/site/v2/sports/basketball/mens-college-basketball/statistics?groups=50&season=2025";

// Fetch the JSON data via cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
if(curl_errno($ch)){
    die('cURL error: ' . curl_error($ch));
}
curl_close($ch);

// Decode the JSON response
$data = json_decode($response, true);

// Get season display info from the API response (if available)
$seasonDisplay = $data['season']['displayName'] ?? "2025 Season";

// Define the stat categories to output
$leaderCategories = [
    'PTS' => ['group' => 'Offensive Leaders', 'label' => 'Points'],
    'AST' => ['group' => 'Complete Leaders', 'label' => 'Assists'],
    '3PM' => ['group' => 'Complete Leaders', 'label' => '3-Pointers Made'],
    'REB' => ['group' => 'Defensive Leaders', 'label' => 'Rebounds'],
    'BLK' => ['group' => 'Defensive Leaders', 'label' => 'Blocks'],
    'STL' => ['group' => 'Defensive Leaders', 'label' => 'Steals']
];

// Define an array of team abbreviations known to be NCAA Division I.
// Adjust this list based on your lookup.
// Adjust this list based on your lookup.
$d1TeamAbbrevs = [
    // America East Conference
    'BING', // Binghamton Bearcats
    'BRY',  // Bryant Bulldogs
    'MAINE',// Maine Black Bears
    'NJIT', // NJIT Highlanders
    'UNH',  // New Hampshire Wildcats
    'UALB', // UAlbany Great Danes
    'UMBC', // UMBC Retrievers
    'UML',  // UMass Lowell River Hawks
    'UVM',  // Vermont Catamounts

    // American Athletic Conference (AAC)
    'CHAR', // Charlotte 49ers
    'ECU',  // East Carolina Pirates
    'FAU',  // Florida Atlantic Owls
    'MEM',  // Memphis Tigers
    'UNT',  // North Texas Mean Green
    'RICE', // Rice Owls
    'USF',  // South Florida Bulls
    'TEM',  // Temple Owls
    'TULN', // Tulane Green Wave
    'TLSA', // Tulsa Golden Hurricane
    'UAB',  // UAB Blazers
    'UTSA', // UTSA Roadrunners
    'WICH', // Wichita State Shockers

    // Atlantic Coast Conference (ACC)
    'BC',   // Boston College Eagles
    'CAL',  // California Golden Bears
    'CLEM', // Clemson Tigers
    'DUKE', // Duke Blue Devils
    'FSU',  // Florida State Seminoles
    'GT',   // Georgia Tech Yellow Jackets
    'LOU',  // Louisville Cardinals
    'MIA',  // Miami Hurricanes
    'NCST', // NC State Wolfpack
    'UNC',  // North Carolina Tar Heels
    'ND',   // Notre Dame Fighting Irish
    'PITT', // Pittsburgh Panthers
    'SMU',  // SMU Mustangs
    'STAN', // Stanford Cardinal
    'CUSE', // Syracuse Orange
    'UVA',  // Virginia Cavaliers
    'VT',   // Virginia Tech Hokies
    'WAKE', // Wake Forest Demon Deacons

    // Atlantic 10 Conference
    'DAV',  // Davidson Wildcats
    'DAY',  // Dayton Flyers
    'DUQ',  // Duquesne Dukes
    'FOR',  // Fordham Rams
    'GMU',  // George Mason Patriots
    'GW',   // George Washington Revolutionaries
    'LAS',  // La Salle Explorers
    'LUC',  // Loyola Chicago Ramblers
    'UMASS',// Massachusetts Minutemen
    'URI',  // Rhode Island Rams
    'RICH', // Richmond Spiders
    'SJU',  // Saint Joseph's Hawks
    'SLU',  // Saint Louis Billikens
    'SBON', // St. Bonaventure Bonnies
    'VCU',  // VCU Rams

    // ASUN Conference
    'APSU', // Austin Peay Governors
    'BEL',  // Bellarmine Knights
    'UCA',  // Central Arkansas Bears
    'EKU',  // Eastern Kentucky Colonels
    'FGCU', // Florida Gulf Coast Eagles
    'JAX',  // Jacksonville Dolphins
    'LIP',  // Lipscomb Bisons
    'UNA',  // North Alabama Lions
    'UNF',  // North Florida Ospreys
    'QUE',  // Queens University Royals
    'STET', // Stetson Hatters
    'WGA',  // West Georgia Wolves

    // Big 12 Conference
    'ASU',  // Arizona State Sun Devils
    'ARIZ', // Arizona Wildcats
    'BYU',  // BYU Cougars
    'BAY',  // Baylor Bears
    'CIN',  // Cincinnati Bearcats
    'COLO', // Colorado Buffaloes
    'HOU',  // Houston Cougars
    'ISU',  // Iowa State Cyclones
    'KU',   // Kansas Jayhawks
    'KSU',  // Kansas State Wildcats
    'OKST', // Oklahoma State Cowboys
    'TCU',  // TCU Horned Frogs
    'TTU',  // Texas Tech Red Raiders
    'UCF',  // UCF Knights
    'UTAH', // Utah Utes
    'WVU',  // West Virginia Mountaineers

    // Big East Conference
    'BUT',  // Butler Bulldogs
    'CREI', // Creighton Bluejays
    'DEP',  // DePaul Blue Demons
    'GTWN', // Georgetown Hoyas
    'MARQ', // Marquette Golden Eagles
    'PROV', // Providence Friars
    'SHU',  // Seton Hall Pirates
    'SJU',  // St. John's Red Storm
    'CONN', // UConn Huskies
    'VILL', // Villanova Wildcats
    'XAV',  // Xavier Musketeers

    // Big Sky Conference
    'EWU',  // Eastern Washington Eagles
    'IDST', // Idaho State Bengals
    'IDHO', // Idaho Vandals
    'MONT', // Montana Grizzlies
    'MTST', // Montana State Bobcats
    'NAU',  // Northern Arizona Lumberjacks
    'NCOL', // Northern Colorado Bears
    'PRST', // Portland State Vikings
    'SAC',  // Sacramento State Hornets
    'WEB',  // Weber State Wildcats

    // Big South Conference
    'CHSO', // Charleston Southern Buccaneers
    'GWU',  // Gardner-Webb Runnin' Bulldogs
    'HP',   // High Point Panthers
    'LONG', // Longwood Lancers
    'PRE',  // Presbyterian Blue Hose
    'RAD',  // Radford Highlanders
    'USCU', // South Carolina Upstate Spartans
    'UNCA', // UNC Asheville Bulldogs
    'WIN',  // Winthrop Eagles

    // Big Ten Conference
    'ILL',  // Illinois Fighting Illini
    'IND',  // Indiana Hoosiers
    'IOWA', // Iowa Hawkeyes
    'MD',   // Maryland Terrapins
    'MSU',  // Michigan State Spartans
    'MICH', // Michigan Wolverines
    'MINN', // Minnesota Golden Gophers
    'NEB',  // Nebraska Cornhuskers
    'NW',   // Northwestern Wildcats
    'OSU',  // Ohio State Buckeyes
    'ORE',  // Oregon Ducks
    'PSU',  // Penn State Nittany Lions
    'PUR',  // Purdue Boilermakers
    'RUTG', // Rutgers Scarlet Knights
    'UCLA', // UCLA Bruins
        'USC',  // USC Trojans
    'WASH', // Washington Huskies
    'WIS',  // Wisconsin Badgers

    // Big West Conference
    'CP',   // Cal Poly Mustangs
    'CSUB', // Cal State Bakersfield Roadrunners
    'CSF',  // Cal State Fullerton Titans
    'CSUN', // Cal State Northridge Matadors
    'HAW',  // Hawai'i Rainbow Warriors
    'LBSU', // Long Beach State Beach
    'UCD',  // UC Davis Aggies
    'UCI',  // UC Irvine Anteaters
    'UCR',  // UC Riverside Highlanders
    'UCSD', // UC San Diego Tritons
    'UCSB', // UC Santa Barbara Gauchos

    // Coastal Athletic Association (CAA)
    'CAM',  // Campbell Fighting Camels
    'COFC', // Charleston Cougars
    'DEL',  // Delaware Blue Hens
    'DREX', // Drexel Dragons
    'ELON', // Elon Phoenix
    'HAMP', // Hampton Pirates
    'HOF',  // Hofstra Pride
    'MON',  // Monmouth Hawks
    'NCAT', // North Carolina A&T Aggies
    'NE',   // Northeastern Huskies
    'SB',   // Stony Brook Seawolves
    'TOW',  // Towson Tigers
    'UNCW', // UNC Wilmington Seahawks
    'WM',   // William & Mary Tribe

    // Conference USA (C-USA)
    'FIU',  // Florida International Panthers
    'JVST', // Jacksonville State Gamecocks
    'KENN', // Kennesaw State Owls
    'LIB',  // Liberty Flames
    'LAT',  // Louisiana Tech Bulldogs
    'MTSU', // Middle Tennessee Blue Raiders
    'NMSU', // New Mexico State Aggies
    'SHSU', // Sam Houston Bearkats
    'UTEP', // UTEP Miners
    'WKU',  // Western Kentucky Hilltoppers

    // Horizon League
    'CSU',  // Cleveland State Vikings
    'DET',  // Detroit Mercy Titans
    'GB',   // Green Bay Phoenix
    'IUI',  // IU Indianapolis Jaguars
    'MIL',  // Milwaukee Panthers
    'NKU',  // Northern Kentucky Norse
    'OAK',  // Oakland Golden Grizzlies
    'PFW',  // Purdue Fort Wayne Mastodons
    'RMU',  // Robert Morris Colonials
    'WRST', // Wright State Raiders
    'YSU',  // Youngstown State Penguins

    // Ivy League
    'BRN',  // Brown Bears
    'COL',  // Columbia Lions
    'COR',  // Cornell Big Red
    'DART', // Dartmouth Big Green
    'HARV', // Harvard Crimson
    'PENN', // Pennsylvania Quakers
    'PRIN', // Princeton Tigers
    'YALE', // Yale Bulldogs

    // MAAC (Metro Atlantic)
    'CAN',  // Canisius Golden Griffins
    'FAIR', // Fairfield Stags
    'IONA', // Iona Gaels
    'MAN',  // Manhattan Jaspers
    'MAR',  // Marist Red Foxes
    'MERR', // Merrimack Warriors
    'MSM',  // Mount St. Mary's Mountaineers
    'NIAG', // Niagara Purple Eagles
    'QUIN', // Quinnipiac Bobcats
    'RID',  // Rider Broncs
    'SHU',  // Sacred Heart Pioneers
    'SPU',  // Saint Peter's Peacocks
    'SIE',  // Siena Saints
    
        // Mid-American Conference (MAC)
    'AKR',  // Akron Zips
    'BALL', // Ball State Cardinals
    'BGSU', // Bowling Green Falcons
    'BUF',  // Buffalo Bulls
    'CMU',  // Central Michigan Chippewas
    'EKEN', // Eastern Michigan Eagles
    'KENT', // Kent State Golden Flashes
    'MIAO', // Miami (OH) RedHawks
    'NIU',  // Northern Illinois Huskies
    'OHIO', // Ohio Bobcats
    'TOL',  // Toledo Rockets
    'WMU',  // Western Michigan Broncos

    // Mid-Eastern Athletic Conference (MEAC)
    'COPP', // Coppin State Eagles
    'DELST',// Delaware State Hornets
    'HOW',  // Howard Bison
    'MDES', // Maryland Eastern Shore Hawks
    'MORG', // Morgan State Bears
    'NCENT',// North Carolina Central Eagles
    'NORF', // Norfolk State Spartans
    'SCST', // South Carolina State Bulldogs

    // Missouri Valley Conference (MVC)
    'BRAD', // Bradley Braves
    'BELM', // Belmont Bruins
    'DU',   // Drake Bulldogs
    'EVAN', // Evansville Purple Aces
    'ILST', // Illinois State Redbirds
    'INST', // Indiana State Sycamores
    'MOST', // Missouri State Bears
    'MURR', // Murray State Racers
    'UNI',  // Northern Iowa Panthers
    'SIU',  // Southern Illinois Salukis
    'VALP', // Valparaiso Beacons

    // Mountain West Conference
    'AFA',  // Air Force Falcons
    'BSU',  // Boise State Broncos
    'CSU',  // Colorado State Rams
    'FRES', // Fresno State Bulldogs
    'NEV',  // Nevada Wolf Pack
    'UNM',  // New Mexico Lobos
    'SDSU', // San Diego State Aztecs
    'SJSU', // San Jose State Spartans
    'UNLV', // UNLV Rebels
    'UTST', // Utah State Aggies
    'WYO',  // Wyoming Cowboys

    // Northeast Conference (NEC)
    'CCSU', // Central Connecticut State Blue Devils
    'FDU',  // Fairleigh Dickinson Knights
    'LIU',  // LIU Sharks
    'MERR', // Merrimack Warriors
    'SHU',  // Sacred Heart Pioneers
    'SFNY', // St. Francis Brooklyn Terriers (note: discontinued after 2023, can omit)
    'SFB',  // Saint Francis (PA) Red Flash
    'STONE',// Stonehill Skyhawks
    'WAG',  // Wagner Seahawks

    // Ohio Valley Conference (OVC)
    'EILL', // Eastern Illinois Panthers
    'LIND', // Lindenwood Lions
    'LITR', // Little Rock Trojans
    'MORE', // Morehead State Eagles
    'SEMO', // Southeast Missouri State Redhawks
    'SIUE', // SIU Edwardsville Cougars
    'TENM', // Tennessee State Tigers
    'TENUT',// Tennessee Tech Golden Eagles
    'USI',  // Southern Indiana Screaming Eagles
    'WSTK', // Western Illinois Leathernecks

    // Pac-12 Conference (legacy members, mostly moved to Big Ten/ACC/Big 12)
    // Many teams now belong to Big Ten or ACC, but including historical abbreviations
    'ARIZ', // Arizona Wildcats
    'ASU',  // Arizona State Sun Devils
    'CAL',  // California Golden Bears
    'COLO', // Colorado Buffaloes
    'ORE',  // Oregon Ducks
    'ORST', // Oregon State Beavers
    'STAN', // Stanford Cardinal
    'UCLA', // UCLA Bruins
    'USC',  // USC Trojans
    'UTAH', // Utah Utes
    'WASH', // Washington Huskies
    'WSU',  // Washington State Cougars

    // Patriot League
    'AMER', // American University Eagles
    'ARMY', // Army Black Knights
    'BOSTU',// Boston University Terriers
    'BUCK', // Bucknell Bison
    'COLG', // Colgate Raiders
    'HC',   // Holy Cross Crusaders
    'LAF',  // Lafayette Leopards
    'LEH',  // Lehigh Mountain Hawks
    'LOYMD',// Loyola Maryland Greyhounds
    'NAVY', // Navy Midshipmen

    // SEC (Southeastern Conference)
    'ALA',  // Alabama Crimson Tide
    'ARK',  // Arkansas Razorbacks
    'AUB',  // Auburn Tigers
    'FLA',  // Florida Gators
    'UGA',  // Georgia Bulldogs
    'UK',   // Kentucky Wildcats
    'LSU',  // LSU Tigers
    'MISS', // Ole Miss Rebels
    'MSST', // Mississippi State Bulldogs
    'MIZZ', // Missouri Tigers
    'SCAR', // South Carolina Gamecocks
    'TENN', // Tennessee Volunteers
    'TAMU', // Texas A&M Aggies
    'VANDY',// Vanderbilt Commodores

    // Southern Conference (SoCon)
    'CHATT',// Chattanooga Mocs
    'CITA', // The Citadel Bulldogs
    'ETSU', // East Tennessee State Buccaneers
    'FUR',  // Furman Paladins
    'MER',  // Mercer Bears
    'SAMF', // Samford Bulldogs
    'UNCG', // UNC Greensboro Spartans
    'VMI',  // VMI Keydets
    'WCU',  // Western Carolina Catamounts
    'WOF',  // Wofford Terriers

    // Southland Conference
    'HCU',  // Houston Christian Huskies
    'INCW', // Incarnate Word Cardinals
    'LAM',  // Lamar Cardinals
    'MCNE', // McNeese Cowboys
    'NWST', // Northwestern State Demons
    'NICH', // Nicholls Colonels
    'NO',   // New Orleans Privateers
    'SELA', // Southeastern Louisiana Lions
    'TAMCC',// Texas A&M-Corpus Christi Islanders

    // Southwestern Athletic Conference (SWAC)
    'AAMU', // Alabama A&M Bulldogs
    'ALST', // Alabama State Hornets
    'ALCN', // Alcorn State Braves
    'BETH', // Bethune–Cookman Wildcats
    'FAMU', // Florida A&M Rattlers
    'GSU',  // Grambling State Tigers
    'JST',  // Jackson State Tigers
    'MVSU', // Mississippi Valley State Delta Devils
    'PVAM', // Prairie View A&M Panthers
    'SU',   // Southern Jaguars
    'TXSO', // Texas Southern Tigers
    'UAPB', // Arkansas–Pine Bluff Golden Lions

    // Summit League
    'DEN',  // Denver Pioneers
    'NDSU', // North Dakota State Bison
    'OMA',  // Omaha Mavericks
    'ORU',  // Oral Roberts Golden Eagles
    'SDSU', // South Dakota State Jackrabbits
    'STTHO',// St. Thomas (MN) Tommies
    'UND',  // North Dakota Fighting Hawks
    'USD',  // South Dakota Coyotes
    'WIU',  // Western Illinois Leathernecks

    // Sun Belt Conference
    'APP',  // Appalachian State Mountaineers
    'ARST', // Arkansas State Red Wolves
    'CCU',  // Coastal Carolina Chanticleers
    'GASO', // Georgia Southern Eagles
    'GAST', // Georgia State Panthers
    'JMU',  // James Madison Dukes
    'LA',   // Louisiana Ragin' Cajuns
    'LR',   // Little Rock Trojans (moved to OVC, but was Sun Belt)
    'MONRO',// ULM Warhawks
    'MRSH', // Marshall Thundering Herd
    'ODU',  // Old Dominion Monarchs
    'SALA', // South Alabama Jaguars
    'TROY', // Troy Trojans
    'TXST', // Texas State Bobcats

    // WAC (Western Athletic Conference)
    'ACU',  // Abilene Christian Wildcats
    'CBU',  // California Baptist Lancers
    'GCU',  // Grand Canyon Antelopes
    'SFA',  // Stephen F. Austin Lumberjacks
    'SUU',  // Southern Utah Thunderbirds
    'TARLT',// Tarleton State Texans
    'UTRGV',// UT Rio Grande Valley Vaqueros
    'UTU',  // Utah Tech Trailblazers
    'UTVAL',// Utah Valley Wolverines
    
    
    // others
    'GONZ',
    'LT',
    'PEPP',
    'SDST',
    'CREI',
    'LAF',
    'YSU',
    'MRSH',
    'QUC',
    'MRMK',
    'BGSU',
    'TROY',
    'UCSD',
    'ME',
    'MONM',
    'UIW',
    'UTC',
    'LOU',
    'ODU',
    'QUC'
    
    
    
    
];

/**
 * Searches for a "leaders" array for a given stat abbreviation.
 */
function findLeaders($data, $statAbbr) {
    $categories = null;
    if (isset($data['stats'])) {
        if (isset($data['stats']['categories'])) {
            $categories = $data['stats']['categories'];
        } else if (isset($data['stats'][0]['categories'])) {
            $categories = $data['stats'][0]['categories'];
        }
    }
    
    if ($categories && is_array($categories)) {
        foreach ($categories as $category) {
            if (isset($category['abbreviation']) && $category['abbreviation'] === $statAbbr && isset($category['leaders'])) {
                return $category['leaders'];
            }
            if (isset($category['stats']) && is_array($category['stats'])) {
                foreach ($category['stats'] as $stat) {
                    if (isset($stat['abbreviation']) && $stat['abbreviation'] === $statAbbr && isset($stat['leaders'])) {
                        return $stat['leaders'];
                    }
                }
            }
        }
    }
    return null;
}

if ($debug) {
    // Begin HTML output with improved styling
    echo "<html><head><title>ESPN Men's Basketball Leaders</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    background-color: #f5f5f5;
                    margin: 0;
                    padding: 20px;
                }
                h2 {
                    text-align: center;
                    color: #333;
                }
                table {
                    border-collapse: collapse;
                    width: 90%;
                    margin: 20px auto;
                    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
                    background-color: #fff;
                }
                th, td {
                    padding: 12px 15px;
                    text-align: center;
                }
                th {
                    background-color: #0077cc;
                    color: #fff;
                    text-transform: uppercase;
                    font-size: 14px;
                    letter-spacing: 0.03em;
                }
                tr:nth-child(even) {
                    background-color: #f2f2f2;
                }
                tr:hover {
                    background-color: #e0f7fa;
                }
                .section-header {
                    background-color: #005fa3;
                    color: #fff;
                    font-size: 16px;
                    font-weight: bold;
                    text-align: center;
                }
            </style>
          </head><body>";
    echo "<h2>Men's Basketball Leaders for Season {$seasonDisplay}</h2>";
    echo "<table>";

    // Loop over each defined stat category
    foreach ($leaderCategories as $abbr => $info) {
        $leaders = findLeaders($data, $abbr);
        if ($leaders) {
            echo "<tr class='section-header'><td colspan='5'>{$info['group']}<br>{$info['label']} ({$abbr})</td></tr>";
            echo "<tr>
                    <th>Rank</th>
                    <th>Player Name</th>
                    <th>Team</th>
                    <th>Stat Value</th>
                    <th>Player ID</th>
                  </tr>";
            $rankCounter = 1;
            $displayedCount = 0;
            foreach ($leaders as $leader) {
                // Limit to top 5 players per category
                if ($displayedCount >= 5) break;
                
                $playerName = $leader['athlete']['displayName'] ?? 'N/A';
                $teamAbbr   = $leader['team']['abbreviation'] ?? 'N/A';
                $statValue  = $leader['displayValue'] ?? 'N/A';
                $playerId   = $leader['athlete']['id'] ?? 'N/A';
                $actualRank = $leader['rank'] ?? $rankCounter;
                
                // Exclude players whose team abbreviation is not in the D-I lookup
                if (!in_array($teamAbbr, $d1TeamAbbrevs)) {
                    continue;
                }
                
                echo "<tr>
                        <td>{$actualRank}</td>
                        <td>{$playerName}</td>
                        <td>{$teamAbbr}</td>
                        <td>{$statValue}</td>
                        <td>{$playerId}</td>
                      </tr>";
                $displayedCount++;
                $rankCounter++;
            }
        } else {
            echo "<tr><td colspan='5'>No leaders found for stat {$abbr}.</td></tr>";
        }
    }

    echo "</table>";
    echo "</body></html>";
}
?>
