<?php
// Simple CRON JOB VERSION - Just echo, no logs

// Prevent script timeout
set_time_limit(0);
ignore_user_abort(true);

echo "=========================================\n";
echo "Leader Stats Update - Starting\n";
echo date('Y-m-d H:i:s') . "\n";
echo "=========================================\n\n";

// Define the URLs to curl
$urls = [
    'https://www.gscroll.us/updateAPIs/leader_stats/NFL/Leaders_Teams.php',
    'https://www.gscroll.us/updateAPIs/leader_stats/NFL/Leaders_Players.php',
    // Uncomment these as needed:
    // 'https://www.gscroll.us/updateAPIs/leader_stats/NBA/Leaders_Teams.php',
    // 'https://www.gscroll.us/updateAPIs/leader_stats/NBA/Leaders_Players.php',
    // 'https://www.gscroll.us/updateAPIs/leader_stats/MLB/Leaders_Teams.php',
    // 'https://www.gscroll.us/updateAPIs/leader_stats/MLB/Leaders_Players.php',
    // 'https://www.gscroll.us/updateAPIs/leader_stats/NHL/Leaders_Teams.php',
    // 'https://www.gscroll.us/updateAPIs/leader_stats/NHL/Leaders_Players.php',
    // 'https://www.gscroll.us/updateAPIs/leader_stats/NCAAF/Leaders_Teams.php',
    // 'https://www.gscroll.us/updateAPIs/leader_stats/NCAAF/Leaders_Players.php',
    // 'https://gscroll.us/Scrolling/App_Output/API/Stats/PlayerStats.php',
    // 'https://gscroll.us/Scrolling/App_Output/API/Stats/TeamRanks.php'
];

$totalUrls = count($urls);
$startTime = microtime(true);
$successCount = 0;
$failCount = 0;

// Process each URL
foreach ($urls as $index => $url) {
    $currentNumber = $index + 1;
    $scriptName = basename($url);
    
    // Extract sport name if present
    if (preg_match('/leader_stats\/([^\/]+)\/(.+)/', $url, $matches)) {
        $scriptName = $matches[1] . '/' . $matches[2];
    }
    
    echo "[$currentNumber/$totalUrls] Processing: $scriptName\n";
    
    // Make the curl request
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 90); // Increased from 30 to 90 seconds
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30); // Increased from 10 to 30 seconds
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $startRequest = microtime(true);
    $response = curl_exec($ch);
    $error = curl_error($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $requestTime = round(microtime(true) - $startRequest, 2);
    curl_close($ch);
    
    // Output result
    if ($error) {
        echo "  ✗ FAILED: $error ({$requestTime}s)\n";
        $failCount++;
    } elseif ($httpCode == 200) {
        $size = strlen($response);
        echo "  ✓ SUCCESS: HTTP $httpCode, {$size} bytes ({$requestTime}s)\n";
        $successCount++;
    } else {
        echo "  ✗ ERROR: HTTP $httpCode ({$requestTime}s)\n";
        $failCount++;
    }
    
    // Small delay between requests
    if ($index < $totalUrls - 1) {
        sleep(2);
    }
}

// Summary
$totalTime = round(microtime(true) - $startTime, 2);

echo "\n=========================================\n";
echo "EXECUTION COMPLETE\n";
echo "Total Scripts: $totalUrls\n";
echo "Successful: $successCount\n";
echo "Failed: $failCount\n";
echo "Total Time: {$totalTime}s\n";
echo "Completed: " . date('Y-m-d H:i:s') . "\n";
echo "=========================================\n";

// Exit with appropriate code
exit($failCount > 0 ? 1 : 0);
?>