<?php
$offsetFile = __DIR__ . '/run_stock_ticker_batch_offset.txt';
$batchSize = 50;

session_start();
require_once '../config.php'; // Your DB config file


// Load offset
$offset = (file_exists($offsetFile)) ? (int)file_get_contents($offsetFile) : 0;

// Call the main script with this offset
$updateScriptUrl = SERVER_URL . "updateAPIs/update_stock_prices_batch.php?value_for_loop=$offset";

// Run it
$response = file_get_contents($updateScriptUrl);

// Optional: log output or errors if needed
// file_put_contents(__DIR__ . '/run_stock_batch_log.txt', "[".date('Y-m-d H:i:s')."] Ran batch at offset $offset\n", FILE_APPEND);

// Get total number of tickers from DB (you could also hardcode this)
require_once '../config.php';
require_once '../meekrodb.2.4.class.php';
DB::$host = $host_gscroll;
DB::$user = $username_gscroll;
DB::$password = $password_gscroll;
DB::$dbName = $database_gscroll;

$total = DB::queryFirstField("SELECT COUNT(*) FROM stock_list");

// Update offset
$nextOffset = $offset + $batchSize;
if ($nextOffset >= $total) {
    $nextOffset = 0; // Loop back to start
}
file_put_contents($offsetFile, $nextOffset);
?>