<?php

// error_reporting(0);
require_once '../../config.php';

session_start();
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

// LaLiga standings API URL
$url = 'https://site.api.espn.com/apis/v2/sports/soccer/esp.1/standings';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);
if ($data === null) {
    echo "Failed to decode JSON.\n";
    echo "Response:\n";
    echo $response;
    exit;
}

// Helper functions
function get_stat_value($stats, $name) {
    foreach ($stats as $stat) {
        if ($stat['name'] === $name) {
            return $stat['value'];
        }
    }
    return null;
}

function addZeros($rgb) {
    return str_pad($rgb, 3, '0', STR_PAD_LEFT);
}

function normalize_team_name($name) {
    return strtoupper(preg_replace('/[^A-Za-z0-9 ]/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $name)));
}

// Mapping to correct API team names to match our local keys
$teamNameCorrections = array(
    'ATLETICO MADRID' => 'ATLETICO',
    'ATHLETIC BILBAO' => 'ATHLETIC CLUB',
    'ATHLETIC CLUB BILBAO' => 'ATHLETIC CLUB',
    'REAL MADRID CF' => 'REAL MADRID',
    'FC BARCELONA' => 'BARCELONA',
    'RCD MALLORCA' => 'MALLORCA',
    'RC CELTA DE VIGO' => 'CELTA VIGO',
    'CELTA VIGO' => 'CELTA',
    'RCD ESPANYOL' => 'ESPANYOL',
    'CD LEGANES' => 'LEGANES',
    'UD LAS PALMAS' => 'LAS PALMAS',
    'REAL VALLADOLID' => 'VALLADOLID',
    'REAL VALLADOLID CF' => 'VALLADOLID',
    'DEPORTIVO ALAVES' => 'ALAVES',
    'REAL SOCIEDAD DE FUTBOL' => 'REAL SOCIEDAD',
    'CA OSASUNA' => 'OSASUNA',
    'RAYO VALLECANO' => 'RAYO',
    'ELCHE CF'   => 'ELCHE',
    'LEVANTE UD' => 'LEVANTE'
);

// LaLiga team colors and abbreviations (20 teams)
$teamColors = array(
    "BARCELONA"      => array(0, 51, 153),      // Blue and Red
    "ATLETICO"       => array(213, 0, 0),       // Red and White
    "REAL MADRID"    => array(255, 255, 255),   // White
    "ATHLETIC CLUB"  => array(237, 28, 36),     // Red and White
    "VILLARREAL"     => array(255, 204, 0),     // Yellow
    "REAL BETIS"     => array(0, 158, 73),      // Green and White
    "RAYO"           => array(255, 0, 0),       // Red and White
    "MALLORCA"       => array(237, 28, 36),     // Red
    "REAL SOCIEDAD"  => array(0, 51, 153),      // Blue and White
    "CELTA"          => array(120, 190, 220),   // Sky Blue
    "OSASUNA"        => array(204, 0, 0),       // Red
    "SEVILLA"        => array(255, 0, 0),       // Red and White
    "GIRONA"         => array(255, 0, 0),       // Red and White
    "GETAFE"         => array(0, 93, 170),      // Blue
    "ESPANYOL"       => array(0, 51, 153),      // Blue and White
    "LEGANES"        => array(0, 51, 153),      // Blue and White
    "LAS PALMAS"     => array(255, 204, 0),     // Yellow and Blue
    "VALENCIA"       => array(255, 128, 0),     // Orange and Black
    "ALAVES"         => array(0, 51, 153),      // Blue and White
    "VALLADOLID"     => array(102, 0, 102),      // Purple and White
    "ELCHE"        => array(5, 100, 44),   // green
    "LEVANTE"      => array(180, 5, 63),   // claret
    "REAL OVIEDO"  => array(9, 76, 161)    // blue
);

$teamAbbreviations = array(
    "BARCELONA"      => "BAR",
    "ATLETICO"       => "ATM",
    "REAL MADRID"    => "RMA",
    "ATHLETIC CLUB"  => "ATH",
    "VILLARREAL"     => "VIL",
    "REAL BETIS"     => "BET",
    "RAYO"           => "RAY",
    "MALLORCA"       => "MLL",
    "REAL SOCIEDAD"  => "RSO",
    "CELTA"          => "CEL",
    "OSASUNA"        => "OSA",
    "SEVILLA"        => "SEV",
    "GIRONA"         => "GIR",
    "GETAFE"         => "GET",
    "ESPANYOL"       => "ESP",
    "LEGANES"        => "LEG",
    "LAS PALMAS"     => "LPA",
    "VALENCIA"       => "VAL",
    "ALAVES"         => "ALA",
    "VALLADOLID"     => "VLD",
    "ELCHE"        => 'ELC',
    "LEVANTE"      => 'LEV',
    "REAL OVIEDO"  => 'OVI'
);

// Build lookup arrays by normalized full name
$team_colors = array();
$abbrByFullName = array();
foreach ($teamColors as $fullName => $colors) {
    $normalizedFullName = normalize_team_name($fullName);
    $team_colors[$normalizedFullName] = $colors;
    $abbrByFullName[$normalizedFullName] = $teamAbbreviations[$fullName];
}

// Process API data
$apiTeams = array();
$unmatchedTeams = array();

// LaLiga has only one table (no conferences)
if (isset($data['children']) && !empty($data['children'][0]['standings']['entries'])) {
    foreach ($data['children'][0]['standings']['entries'] as $entry) {
        $full_team_name = $entry['team']['displayName'];
        $normalizedFullName = normalize_team_name($full_team_name);
        
        // Apply correction if API name differs from our standard
        if (isset($teamNameCorrections[$normalizedFullName])) {
            $normalizedFullName = normalize_team_name($teamNameCorrections[$normalizedFullName]);
        }
        
        $wins = get_stat_value($entry['stats'], 'wins');
        $losses = get_stat_value($entry['stats'], 'losses');
        $ties = get_stat_value($entry['stats'], 'ties'); // Draws in football/soccer
        
        // Format: W-D-L (Wins-Draws-Losses)
        $record = "$wins-$ties-$losses";
        $ranking = get_stat_value($entry['stats'], 'rank');
        
        if (array_key_exists($normalizedFullName, $team_colors)) {
            $apiTeams[$normalizedFullName] = array(
                'wins' => $wins,
                'losses' => $losses,
                'ties' => $ties,
                'record' => $record,
                'ranking' => $ranking,
                'abbrev' => $entry['team']['abbreviation']
            );
        } else {
            $unmatchedTeams[] = "Rank $ranking: $full_team_name (Normalized: $normalizedFullName)";
        }
    }
}

// Debug unmatched teams
if (!empty($unmatchedTeams)) {
    echo "<h3>Unmatched Teams from API:</h3><ul>";
    foreach ($unmatchedTeams as $unmatched) {
        echo "<li>$unmatched</li>";
    }
    echo "</ul>";
}

// --- Create a mapping of normalized team names to unique_count values ---
// For LaLiga teams (20 teams)
$uniqueCountsMapping = array(
    normalize_team_name("BARCELONA")      => array(6100),
    normalize_team_name("ATLETICO")       => array(6101),
    normalize_team_name("REAL MADRID")    => array(6102),
    normalize_team_name("ATHLETIC CLUB")  => array(6103),
    normalize_team_name("VILLARREAL")     => array(6104),
    normalize_team_name("REAL BETIS")     => array(6105),
    normalize_team_name("RAYO")           => array(6106),
    normalize_team_name("MALLORCA")       => array(6107),
    normalize_team_name("REAL SOCIEDAD")  => array(6108),
    normalize_team_name("CELTA")          => array(6109),
    normalize_team_name("OSASUNA")        => array(6110),
    normalize_team_name("SEVILLA")        => array(6111),
    normalize_team_name("GIRONA")         => array(6112),
    normalize_team_name("GETAFE")         => array(6113),
    normalize_team_name("ESPANYOL")       => array(6114),
    normalize_team_name("LEVANTE")      => array(6115),
    normalize_team_name("ELCHE")        => array(6116),
    normalize_team_name("VALENCIA")       => array(6117),
    normalize_team_name("ALAVES")         => array(6118),
    normalize_team_name("REAL OVIEDO")  => array(6119)
);

// --- Now update the database using unique_count as the identifier ---
echo "<table border='1'>";
echo "<tr><th>Team Name</th><th>Record (W-D-L)</th><th>Rank</th><th>Red</th><th>Green</th><th>Blue</th><th>SQL Query</th><th>Status</th></tr>";

foreach ($uniqueCountsMapping as $normalizedFullName => $uniqueCountsArray) {
    // Get team colors and abbreviation from our lookup arrays
    if (!isset($team_colors[$normalizedFullName])) {
        // If the team is not in our color mapping, skip it.
        continue;
    }
    $colors = $team_colors[$normalizedFullName];
    $red = $colors[0];
    $green = $colors[1];
    $blue = $colors[2];
    $abbr = $abbrByFullName[$normalizedFullName] ?? '';

    // If API data is available, use it; otherwise use default values.
    if (isset($apiTeams[$normalizedFullName])) {
        $record = $apiTeams[$normalizedFullName]['record'];
        $ranking = $apiTeams[$normalizedFullName]['ranking'];
    } else {
        $record = "0-0-0";
        $ranking = 0;
    }
    
    // Execute an update for each unique_count
    foreach ($uniqueCountsArray as $uniqueCount) {
        $query = "UPDATE leader_board SET 
            current_team = '$normalizedFullName', 
            winLossRecord = '$record', 
            Abbrev = '$abbr',
            Red = $red, 
            Green = $green, 
            Blue = $blue,
            team_rank = $ranking
            WHERE unique_count = $uniqueCount;";
            
        $status = mysqli_query($conn, $query) ? "Query executed successfully." : "Error: " . mysqli_error($conn);
        
        echo "<tr>";
        echo "<td>$normalizedFullName</td>";
        echo "<td>$record</td>";
        echo "<td>$ranking</td>";
        echo "<td>" . addZeros($red) . "</td>";
        echo "<td>" . addZeros($green) . "</td>";
        echo "<td>" . addZeros($blue) . "</td>";
        echo "<td>$query</td>";
        echo "<td>$status (unique_count: $uniqueCount)</td>";
        echo "</tr>";
    }
}
echo "</table>";

mysqli_close($conn);
?>