<?php
// show all errors
error_reporting(E_ALL);
ini_set('display_errors', 1);

// output HTML
header('Content-Type: text/html; charset=UTF-8');

// ESPN standings endpoint
define('MLB_STANDINGS_URL', 'https://site.api.espn.com/apis/v2/sports/baseball/mlb/standings');

// map of Abbrev → [name, [R,G,B], division]
$TEAM_INFO = [
  'LAA'=>['name'=>'Angels',     'colors'=>[186,  0,  33],'division'=>'AMERICAN'],
  'ARI'=>['name'=>'Dbacks',     'colors'=>[167, 25,  48],'division'=>'NATIONAL'],
  'BAL'=>['name'=>'Orioles',    'colors'=>[252, 76,   2],'division'=>'AMERICAN'],
  'BOS'=>['name'=>'Red Sox',    'colors'=>[189, 48,  57],'division'=>'AMERICAN'],
  'CHC'=>['name'=>'Cubs',       'colors'=>[  0, 47, 108],'division'=>'NATIONAL'],
  'CHW'=>['name'=>'White Sox',  'colors'=>[  0,  0,   0],'division'=>'AMERICAN'],
  'CIN'=>['name'=>'Reds',       'colors'=>[198,  1,  31],'division'=>'NATIONAL'],
  'CLE'=>['name'=>'Guardians',  'colors'=>[ 12, 35,  64],'division'=>'AMERICAN'],
  'COL'=>['name'=>'Rockies',    'colors'=>[ 51,  0, 111],'division'=>'NATIONAL'],
  'DET'=>['name'=>'Tigers',     'colors'=>[ 12, 35,  64],'division'=>'AMERICAN'],
  'HOU'=>['name'=>'Astros',     'colors'=>[  0, 45,  98],'division'=>'AMERICAN'],
  'KC' =>['name'=>'Royals',     'colors'=>[  0, 32,  91],'division'=>'AMERICAN'],
  'LAD'=>['name'=>'Dodgers',    'colors'=>[  0, 47, 108],'division'=>'NATIONAL'],
  'WSH'=>['name'=>'Nationals',  'colors'=>[171,  0,   3],'division'=>'NATIONAL'],
  'NYM'=>['name'=>'Mets',       'colors'=>[  0, 45, 114],'division'=>'NATIONAL'],
  'ATH'=>['name'=>'Athletics',  'colors'=>[  0, 56,  49],'division'=>'AMERICAN'],
  'PIT'=>['name'=>'Pirates',    'colors'=>[253,184,  39],'division'=>'NATIONAL'],
  'SD' =>['name'=>'Padres',     'colors'=>[  0, 45,  98],'division'=>'NATIONAL'],
  'SEA'=>['name'=>'Mariners',   'colors'=>[  0,104,  71],'division'=>'AMERICAN'],
  'SF' =>['name'=>'Giants',     'colors'=>[255, 75,  31],'division'=>'NATIONAL'],
  'STL'=>['name'=>'Cardinals',  'colors'=>[196, 30,  58],'division'=>'NATIONAL'],
  'TB' =>['name'=>'Rays',       'colors'=>[  9, 43,  94],'division'=>'AMERICAN'],
  'TEX'=>['name'=>'Rangers',    'colors'=>[  2, 45,  92],'division'=>'AMERICAN'],
  'TOR'=>['name'=>'Blue Jays',  'colors'=>[ 19, 74, 142],'division'=>'AMERICAN'],
  'MIN'=>['name'=>'Twins',      'colors'=>[  0, 43,  92],'division'=>'AMERICAN'],
  'PHI'=>['name'=>'Phillies',   'colors'=>[239, 51,  64],'division'=>'NATIONAL'],
  'ATL'=>['name'=>'Braves',     'colors'=>[186, 12,  47],'division'=>'NATIONAL'],
  'MIL'=>['name'=>'Brewers',    'colors'=>[ 19, 46,  94],'division'=>'NATIONAL'],
  'MIA'=>['name'=>'Marlins',    'colors'=>[  0,  0, 139],'division'=>'NATIONAL'],
  'NYY'=>['name'=>'Yankees',    'colors'=>[ 12, 35,  64],'division'=>'AMERICAN'],
];

// fetch + decode ESPN JSON
function get_mlb_standings(){
  $resp = @file_get_contents(MLB_STANDINGS_URL);
  if($resp===FALSE) return [];
  $data = json_decode($resp, true);
  return json_last_error()===JSON_ERROR_NONE ? $data : [];
}

// ——————————————————————————
// 1) DB connect
// ——————————————————————————
require_once '../../config.php';  // $host, $username, $password, $database
$conn = mysqli_connect($host_gscroll,$username_gscroll,$password_gscroll,$database_gscroll);
if(!$conn) die("<h2>DB connection failed: ".mysqli_connect_error()."</h2>");

// ——————————————————————————
// 2) Pull data
// ——————————————————————————
$data = get_mlb_standings();
if(empty($data['children'])) {
  die("<h2>Could not fetch standings.</h2>");
}

// ——————————————————————————
// 3) Process & UPDATE by team_rank
// ——————————————————————————
$results = [];
foreach($data['children'] as $group){
  if(empty($group['standings']['entries'])) continue;
  foreach($group['standings']['entries'] as $entry){
    $abbr = strtoupper($entry['team']['abbreviation']);
    if(!isset($TEAM_INFO[$abbr])){
      $results[] = ['abbr'=>$abbr,'rank'=>'','team'=>'','division'=>'','record'=>'','status'=>'<span class="skipped">SKIPPED</span>','query'=>'no mapping'];
      continue;
    }
    $info     = $TEAM_INFO[$abbr];
    $team     = strtoupper($info['name']);
    $division = $info['division'];
    list($r,$g,$b) = $info['colors'];
    // wins, losses, seed
    $wins=$losses=$seed=0;
    foreach($entry['stats'] as $s){
      if($s['name']==='wins')       $wins   =(int)$s['value'];
      if($s['name']==='losses')     $losses =(int)$s['value'];
      if($s['name']==='playoffSeed')$seed   =(int)$s['value'];
    }
    $record = "$wins-$losses";

    // now update *by team_rank=seed*
    $sql = sprintf(
      "UPDATE leader_board
          SET current_team  = '%s',
              winLossRecord = '%s',
              Abbrev        = '%s',
              Red           = %d,
              Green         = %d,
              Blue          = %d
        WHERE league    = 'MLB'
          AND division  = '%s'
          AND team_rank = %d;",
      mysqli_real_escape_string($conn,$team),
      mysqli_real_escape_string($conn,$record),
      mysqli_real_escape_string($conn,$abbr),
      $r,$g,$b,
      mysqli_real_escape_string($conn,$division),
      $seed
    );

    if(mysqli_query($conn,$sql)){
      $status = '<span class="success">UPDATED</span>';
    } else {
      $status = '<span class="error">ERROR</span>: '.htmlspecialchars(mysqli_error($conn));
    }

    $results[] = [
      'abbr'=>$abbr,
      'rank'=>$seed,
      'team'=>$team,
      'division'=>$division,
      'record'=>$record,
      'status'=>$status,
      'query'=>$sql
    ];
  }
}

// close & render
mysqli_close($conn);
?>
<!DOCTYPE html>
<html>
<head><meta charset="utf-8"><title>MLB Update Results</title>
<style>
  body{font-family:Arial,sans-serif;margin:20px}
  table{width:100%;border-collapse:collapse;margin-top:1em}
  th,td{border:1px solid #ddd;padding:8px;text-align:left}
  th{background:#f4f4f4}
  .success{color:green;font-weight:bold}
  .error{color:red;font-weight:bold}
  .skipped{color:orange;font-weight:bold}
  textarea{width:100%;height:60px}
</style>
</head>
<body>
  <h1>MLB Standings Update</h1>
  <table>
    <thead>
      <tr>
        <th>Abbrev</th><th>Rank</th><th>Team</th><th>Division</th><th>Record</th><th>Status</th><th>SQL</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($results as $r): ?>
      <tr>
        <td><?=$r['abbr']?></td>
        <td><?=$r['rank']?></td>
        <td><?=$r['team']?></td>
        <td><?=$r['division']?></td>
        <td><?=$r['record']?></td>
        <td><?=$r['status']?></td>
        <td><textarea readonly><?=htmlspecialchars($r['query'])?></textarea></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</body>
</html>
