<?php

error_reporting(0);
require_once '../../config.php';

session_start();
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

// MLS standings API URL
$url = 'https://site.api.espn.com/apis/v2/sports/soccer/usa.1/standings';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);
if ($data === null) {
    echo "Failed to decode JSON.\n";
    echo "Response:\n";
    echo $response;
    exit;
}

// Helper functions
function get_stat_value($stats, $name) {
    foreach ($stats as $stat) {
        if ($stat['name'] === $name) {
            return $stat['value'];
        }
    }
    return null;
}

function addZeros($rgb) {
    return str_pad($rgb, 3, '0', STR_PAD_LEFT);
}

function normalize_team_name($name) {
    return strtoupper(preg_replace('/[^A-Za-z0-9 ]/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $name)));
}

// Mapping to correct API team names to match our local keys
$teamNameCorrections = array(
    'VANCOUVER WHITECAPS' => 'VANCOUVER WHITECAPS FC',
    'LAFC'               => 'LOS ANGELES FC'
);

// MLS team colors and abbreviations (29 teams, updated for consistency)
$teamColors = array(
    "ATLANTA UNITED FC"      => array(186, 12, 47),
    "AUSTIN FC"              => array(0, 163, 86),
    "CHARLOTTE FC"           => array(33, 150, 243),
    "CHICAGO FIRE FC"        => array(206, 0, 36),
    "FC CINCINNATI"          => array(0, 71, 171),
    "COLORADO RAPIDS"        => array(111, 0, 48),
    "COLUMBUS CREW"          => array(255, 215, 0),
    "DC UNITED"              => array(239, 65, 54),
    "FC DALLAS"              => array(227, 33, 46),
    "HOUSTON DYNAMO FC"      => array(255, 102, 0),
    "SPORTING KANSAS CITY"   => array(137, 175, 223),
    "LA GALAXY"              => array(0, 48, 98),
    "LOS ANGELES FC"         => array(0, 0, 0),
    "INTER MIAMI CF"         => array(246, 128, 154),
    "MINNESOTA UNITED FC"    => array(15, 82, 139),
    "CF MONTREAL"            => array(0, 41, 96),
    "NASHVILLE SC"           => array(236, 171, 18),
    "NEW ENGLAND REVOLUTION" => array(0, 28, 91),
    "NEW YORK CITY FC"       => array(108, 172, 228),
    "NEW YORK RED BULLS"     => array(237, 28, 36),
    "ORLANDO CITY SC"        => array(102, 44, 145),
    "PHILADELPHIA UNION"     => array(0, 33, 66),
    "PORTLAND TIMBERS"       => array(0, 78, 47),
    "REAL SALT LAKE"         => array(177, 12, 34),
    "SAN DIEGO FC"           => array(220, 20, 60),  // Added San Diego FC
    "SAN JOSE EARTHQUAKES"   => array(0, 44, 99),
    "SEATTLE SOUNDERS FC"    => array(0, 106, 63),
    "ST LOUIS CITY SC"       => array(181, 0, 50),
    "TORONTO FC"             => array(163, 28, 38),
    "VANCOUVER WHITECAPS FC" => array(0, 38, 95)
);

$teamAbbreviations = array(
    "ATLANTA UNITED FC"      => "ATL",
    "AUSTIN FC"              => "ATX",
    "CHARLOTTE FC"           => "CLT",
    "CHICAGO FIRE FC"        => "CHI",
    "FC CINCINNATI"          => "CIN",
    "COLORADO RAPIDS"        => "COL",
    "COLUMBUS CREW"          => "CLB",
    "DC UNITED"              => "DC",
    "FC DALLAS"              => "DAL",
    "HOUSTON DYNAMO FC"      => "HOU",
    "SPORTING KANSAS CITY"   => "SKC",
    "LA GALAXY"              => "LA",
    "LOS ANGELES FC"         => "LAFC",
    "INTER MIAMI CF"         => "MIA",
    "MINNESOTA UNITED FC"    => "MIN",
    "CF MONTREAL"            => "MTL",
    "NASHVILLE SC"           => "NSH",
    "NEW ENGLAND REVOLUTION" => "NE",
    "NEW YORK CITY FC"       => "NYC",
    "NEW YORK RED BULLS"     => "NY",
    "ORLANDO CITY SC"        => "ORL",
    "PHILADELPHIA UNION"     => "PHI",
    "PORTLAND TIMBERS"       => "POR",
    "REAL SALT LAKE"         => "RSL",
    "SAN DIEGO FC"           => "SDC",  // Added San Diego FC
    "SAN JOSE EARTHQUAKES"   => "SJ",
    "SEATTLE SOUNDERS FC"    => "SEA",
    "ST LOUIS CITY SC"       => "STL",
    "TORONTO FC"             => "TOR",
    "VANCOUVER WHITECAPS FC" => "VAN"
);

// Display name mapping (for shortened display names)
$displayNameMapping = array(
    "ATLANTA UNITED FC"      => "ATLANTA",
    "AUSTIN FC"              => "AUSTIN",
    "CHARLOTTE FC"           => "CHARLOTTE",
    "CHICAGO FIRE FC"        => "CHICAGO",
    "FC CINCINNATI"          => "CINCINNATI",
    "COLORADO RAPIDS"        => "COLORADO",
    "COLUMBUS CREW"          => "COLUMBUS",
    "DC UNITED"              => "DC UNITED",
    "FC DALLAS"              => "DALLAS",
    "HOUSTON DYNAMO FC"      => "HOUSTON",
    "SPORTING KANSAS CITY"   => "KANSAS CITY",
    "LA GALAXY"              => "LA GALAXY",
    "LOS ANGELES FC"         => "LA FC",
    "INTER MIAMI CF"         => "MIAMI",
    "MINNESOTA UNITED FC"    => "MINNESOTA",
    "CF MONTREAL"            => "MONTREAL",
    "NASHVILLE SC"           => "NASHVILLE",
    "NEW ENGLAND REVOLUTION" => "NEW ENGLAND",
    "NEW YORK CITY FC"       => "NYC",
    "NEW YORK RED BULLS"     => "NY RED BULLS",
    "ORLANDO CITY SC"        => "ORLANDO",
    "PHILADELPHIA UNION"     => "PHILADELPHIA",
    "PORTLAND TIMBERS"       => "PORTLAND",
    "REAL SALT LAKE"         => "SALT LAKE",
    "SAN DIEGO FC"           => "SAN DIEGO",
    "SAN JOSE EARTHQUAKES"   => "SAN JOSE",
    "SEATTLE SOUNDERS FC"    => "SEATTLE",
    "ST LOUIS CITY SC"       => "ST LOUIS",
    "TORONTO FC"             => "TORONTO",
    "VANCOUVER WHITECAPS FC" => "VANCOUVER"
);

// Build lookup arrays by normalized full name
$team_colors = array();
$abbrByFullName = array();
$displayNameByFullName = array();
foreach ($teamColors as $fullName => $colors) {
    $normalizedFullName = normalize_team_name($fullName);
    $team_colors[$normalizedFullName] = $colors;
    $abbrByFullName[$normalizedFullName] = $teamAbbreviations[$fullName];
    $displayNameByFullName[$normalizedFullName] = normalize_team_name($displayNameMapping[$fullName]);
}

// Process API data
$apiTeams = array();
$unmatchedTeams = array();
if (isset($data['children'])) {
    foreach ($data['children'] as $conferenceData) {
        $conference = (strpos($conferenceData['name'], 'Eastern') !== false) ? 'EASTERN' : 'WESTERN';
        if (isset($conferenceData['standings']['entries'])) {
            foreach ($conferenceData['standings']['entries'] as $entry) {
                $full_team_name = $entry['team']['displayName'];
                $normalizedFullName = normalize_team_name($full_team_name);
                // Apply correction if API name differs from our standard.
                if (isset($teamNameCorrections[$normalizedFullName])) {
                    $normalizedFullName = normalize_team_name($teamNameCorrections[$normalizedFullName]);
                }
                $wins = get_stat_value($entry['stats'], 'wins');
                $losses = get_stat_value($entry['stats'], 'losses');
                $ties = get_stat_value($entry['stats'], 'ties');
                $record = "$wins-$losses-$ties";
                $ranking = get_stat_value($entry['stats'], 'rank');
                if (array_key_exists($normalizedFullName, $team_colors)) {
                    $apiTeams[$normalizedFullName] = array(
                        'wins' => $wins,
                        'losses' => $losses,
                        'ties' => $ties,
                        'record' => $record,
                        'ranking' => $ranking,
                        'conference' => $conference,
                        'abbrev' => $entry['team']['abbreviation']
                    );
                } else {
                    $unmatchedTeams[] = "$conference Rank $ranking: $full_team_name (Normalized: $normalizedFullName)";
                }
            }
        }
    }
}

// Debug unmatched teams
if (!empty($unmatchedTeams)) {
    echo "<h3>Unmatched Teams from API:</h3><ul>";
    foreach ($unmatchedTeams as $unmatched) {
        echo "<li>$unmatched</li>";
    }
    echo "</ul>";
}

// --- Create a mapping of normalized team names to unique_count values ---
// For teams with duplicates (e.g. VANCOUVER WHITECAPS FC), provide an array of unique_count values.
$uniqueCountsMapping = array(
    // Eastern teams (15 teams)
    normalize_team_name("COLUMBUS CREW")          => array(4029),
    normalize_team_name("PHILADELPHIA UNION")       => array(4030),
    normalize_team_name("ATLANTA UNITED FC")        => array(4031),
    normalize_team_name("FC CINCINNATI")              => array(4032),
    normalize_team_name("CHARLOTTE FC")               => array(4033),
    normalize_team_name("DC UNITED")                  => array(4034),
    normalize_team_name("NEW YORK CITY FC")           => array(4035),
    normalize_team_name("TORONTO FC")                 => array(4036),
    normalize_team_name("INTER MIAMI CF")             => array(4037),
    normalize_team_name("NASHVILLE SC")               => array(4038),
    normalize_team_name("NEW ENGLAND REVOLUTION")     => array(4039),
    normalize_team_name("CF MONTREAL")                => array(4040),
    normalize_team_name("NEW YORK RED BULLS")         => array(4041),
    normalize_team_name("ORLANDO CITY SC")            => array(4042),
    normalize_team_name("CHICAGO FIRE FC")            => array(4043),
    // Western teams (15 teams)
    normalize_team_name("SAN JOSE EARTHQUAKES")       => array(4044),
    normalize_team_name("VANCOUVER WHITECAPS FC")     => array(4045, 4046), // duplicate rows
    normalize_team_name("FC DALLAS")                  => array(4047),
    normalize_team_name("LOS ANGELES FC")             => array(4048),
    normalize_team_name("AUSTIN FC")                  => array(4049),
    normalize_team_name("SEATTLE SOUNDERS FC")        => array(4050),
    normalize_team_name("COLORADO RAPIDS")            => array(4051),
    normalize_team_name("ST LOUIS CITY SC")           => array(4052),
    normalize_team_name("HOUSTON DYNAMO FC")          => array(4053),
    normalize_team_name("MINNESOTA UNITED FC")        => array(4054),
    normalize_team_name("SPORTING KANSAS CITY")       => array(4055),
    normalize_team_name("LA GALAXY")                  => array(4056),
    normalize_team_name("PORTLAND TIMBERS")           => array(4057),
    normalize_team_name("REAL SALT LAKE")             => array(4058),
    normalize_team_name("SAN DIEGO FC")               => array(4059)
);

// --- Now update the database using unique_count as the identifier ---
echo "<table border='1'>";
echo "<tr><th>Team Name</th><th>Display Name</th><th>Record (W-L-T)</th><th>Rank</th><th>Red</th><th>Green</th><th>Blue</th><th>SQL Query</th><th>Status</th></tr>";

foreach ($uniqueCountsMapping as $normalizedFullName => $uniqueCountsArray) {
    // Get team colors and abbreviation from our lookup arrays
    if (!isset($team_colors[$normalizedFullName])) {
        // If the team is not in our color mapping, skip it.
        continue;
    }
    $colors = $team_colors[$normalizedFullName];
    $red = $colors[0];
    $green = $colors[1];
    $blue = $colors[2];
    $abbr = $abbrByFullName[$normalizedFullName] ?? '';
    
    // Get the display name (shortened version for database)
    $displayName = $displayNameByFullName[$normalizedFullName] ?? $normalizedFullName;

    // If API data is available, use it; otherwise use default values.
    if (isset($apiTeams[$normalizedFullName])) {
        $record = $apiTeams[$normalizedFullName]['record'];
        $ranking = $apiTeams[$normalizedFullName]['ranking'];
    } else {
        $record = "0-0-0";
        $ranking = 0;
    }
    
    // Execute an update for each unique_count (this handles duplicate rows)
    foreach ($uniqueCountsArray as $uniqueCount) {
        $query = "UPDATE leader_board SET 
            current_team = '$displayName', 
            winLossRecord = '$record', 
            Abbrev = '$abbr',
            Red = $red, 
            Green = $green, 
            Blue = $blue,
            team_rank = $ranking
            WHERE unique_count = $uniqueCount;";
            
        $status = mysqli_query($conn, $query) ? "Query executed successfully." : "Error: " . mysqli_error($conn);
        
        echo "<tr>";
        echo "<td>$normalizedFullName</td>";
        echo "<td>$displayName</td>";
        echo "<td>$record</td>";
        echo "<td>$ranking</td>";
        echo "<td>" . addZeros($red) . "</td>";
        echo "<td>" . addZeros($green) . "</td>";
        echo "<td>" . addZeros($blue) . "</td>";
        echo "<td>$query</td>";
        echo "<td>$status (unique_count: $uniqueCount)</td>";
        echo "</tr>";
    }
}
echo "</table>";

mysqli_close($conn);
?>