<?php

error_reporting(0);
/*************** 🌟 START OF HELPER FUNCTIONS 🌟 ***************/

// Verison 1 : Written by Jebelli

// function to find the instance a word shows up
function strposX($haystack, $needle, $number = 0)
{
    return strpos($haystack, $needle,
        $number > 1 ?
        strposX($haystack, $needle, $number - 1) + strlen($needle) : 0
    );
}

$current_active_games = 0 ;
// function to clear out special chars 
function clean($string) {
  $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.

  return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
}



// function to add leading zeros
function addZeros($rgb) {
    
  $rgb = str_pad($rgb, 3, '0', STR_PAD_LEFT);
  
 return $rgb;
}



// function to get strings in between strings 
function getBetween($string, $start = "", $end = ""){
    if (strpos($string, $start)) { // required if $start not exist in $string
        $startCharCount = strpos($string, $start) + strlen($start);
        $firstSubStr = substr($string, $startCharCount, strlen($string));
        $endCharCount = strpos($firstSubStr, $end);
        if ($endCharCount == 0) {
            $endCharCount = strlen($firstSubStr);
        }
        return substr($firstSubStr, 0, $endCharCount);
    } else {
        return '';
    }
}

// function to convert time 

function dateToTimezone($timeZone = 'UTC', $dateTimeUTC = null, $dateFormat = 'Y-m-d H:i:s'){

    $dateTimeUTC = $dateTimeUTC ? $dateTimeUTC : date("Y-m-d H:i:s");

    $date = new DateTime($dateTimeUTC, new DateTimeZone('UTC'));
    $date->setTimeZone(new DateTimeZone($timeZone));

    return $date->format($dateFormat);
}





function formatNumber($number) {
  if ($number >= 1000000000) {
    // Number is in billions
    $formattedNumber = round($number / 1000000000, 1) . 'B';
  } elseif ($number >= 1000000) {
    // Number is in millions
    $formattedNumber = round($number / 1000000, 1) . 'M';
  } elseif ($number >= 1000) {
    // Number is in thousands
    $formattedNumber = round($number / 1000, 1) . 'K';
  } else {
    // Number is less than 1000
    $formattedNumber = $number;
  }

  return $formattedNumber;
}


/*************** 🌟 END OF HELPER FUNCTIONS 🌟 ***************/

/// START OF FUNCTION // 


$url = 'http://site.api.espn.com/apis/site/v2/sports/football/college-football/rankings';
$data = file_get_contents($url);
$result = strip_tags($data);



$NUM_TEAMS = 25; // Top 25 College Football Teams


for ($i=1; $i <= $NUM_TEAMS ; $i++)
{

// $i = 1;

// extract team data
$start_suffix = '"current":' ;
$index_start = strposX($result, $start_suffix, $i);
$index_end = strposX($result, $start_suffix, $i+1)-$index_start ;
$team_result= substr($result, $index_start,$index_end);



$string = $team_result;

preg_match('/"current":(\d+)/', $string, $matches);
$team_ranking = $matches[1];


// Define the pattern to match the nickname
$pattern = '/"nickname":"([^"]+)"/';
// Perform the regex match
preg_match($pattern, $string, $matches);
$current_team = $matches[1];
$current_team = strtoupper($current_team);

// Extract win-loss record
preg_match('/"recordSummary":"([^"]+)"/', $string, $matches);
$winLossRecord = $matches[1];


// abbrev
// Regular expression to match the abbreviation
$pattern = '/"abbreviation":"([A-Z]+)"/';
// Perform the regex match for abbreviation
preg_match($pattern, $string, $matches);
$teamAbbrev = $matches[1];



// Extract color in hex format
preg_match('/"color":"([^"]+)"/', $string, $matches);
$hexColor = $matches[1];

// Convert hex color to RGB components
list($red, $green, $blue) = sscanf($hexColor, "%02x%02x%02x");


// echo $team_result;

$division = 'TOP25';


$league = 'NCAAF';
$current_team = str_ireplace("STATE", "ST", $current_team);

if($current_team == "NOTRE DAME")
{
 $current_team = "N.DAME";   
}

if($current_team == "WASHINGTON")
{
 $current_team = "WASH";   
}

if($current_team == "MARQUETTE")
{
 $current_team = "MARQ";   
}

if ($current_team == "TEXAS A&M") {
    echo $current_team;
    $current_team = "TAMU";   
    $teamAbbrev = "TAMU";   
}

// Construct SQL query using updated values
$query = "UPDATE leader_board SET 
            current_team = '$current_team', 
            winLossRecord = '$wins-$losses', 
            Abbrev = '$teamAbbrev',
            Red = {$colors[0]}, 
            Green = {$colors[1]}, 
            Blue = {$colors[2]} 
          WHERE team_rank = $ranking 
          AND division = '$division' 
          AND league = 'MLB';";


// Strip all spaces
$current_team = str_replace(' ', '', $current_team);

$query = "UPDATE leader_board 
          SET current_team = '".$current_team."', 
              winLossRecord = '".$winLossRecord."', 
              Red = '".$red."', 
              Green = '".$green."', 
              Blue = '".$blue."', 
              Abbrev = '".$teamAbbrev."' 
          WHERE team_rank = '".$i."' 
            AND division = '".$division."' 
            AND league = 'NCAAF'";



require_once '../../config.php'; // Include the configuration file

///////////// INITIALIZE SQL DATABASE ///////////////////
session_start();
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);


// delete all data from the scoreBoard table
mysqli_query($conn, $query);
echo $query;
echo " ";
}