<?php
// Enable error reporting for debugging (disable these in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include the configuration file
require_once '../../config.php';

// Initialize SQL database
session_start();
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

// Check connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Helper function to convert hex color to RGB (returns an associative array)
function hexToRGB($hex) {
    $hex = ltrim($hex, '#');
    if (strlen($hex) == 3) {
        $r = hexdec(str_repeat(substr($hex, 0, 1), 2));
        $g = hexdec(str_repeat(substr($hex, 1, 1), 2));
        $b = hexdec(str_repeat(substr($hex, 2, 1), 2));
    } else {
        $r = hexdec(substr($hex, 0, 2));
        $g = hexdec(substr($hex, 2, 2));
        $b = hexdec(substr($hex, 4, 2));
    }
    return array('red' => $r, 'green' => $g, 'blue' => $b);
}

// API call for NCAA college baseball rankings
$url = 'https://site.api.espn.com/apis/site/v2/sports/baseball/college-baseball/rankings';
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL            => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_TIMEOUT        => 30,
]);
$result = curl_exec($curl);
$err    = curl_error($curl);
curl_close($curl);

if ($err) {
    die("cURL Error: " . $err);
}

$jsonData = json_decode($result, true);
if (!$jsonData) {
    die("Error decoding JSON: " . json_last_error_msg());
}

if (!isset($jsonData['rankings'][0]['ranks']) || !is_array($jsonData['rankings'][0]['ranks'])) {
    die("No ranking data found.");
}

$ranks = $jsonData['rankings'][0]['ranks'];

// Begin HTML output
echo "<html>
<head>
    <title>2025 Rankings</title>
    <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: center; }
        th { background-color: #f2f2f2; }
        pre { text-align: left; margin: 0; }
    </style>
</head>
<body>
    <h2>2025 Rankings</h2>
    <table>
        <tr>
            <th>RK</th>
            <th>TEAM</th>
            <th>RECORD</th>
            <th>PVS</th>
            <th>R</th>
            <th>G</th>
            <th>B</th>
            <th>ABBREV</th>
            <th>QUERY</th>
        </tr>";

foreach ($ranks as $index => $item) {
    // Use a sequential ranking (RK) starting at 1
    $rk = $index + 1;
    
    // Set the unique count based on rank: 4003 + rk will give 4004 for rank 1, etc.
    $unique_count = 4003 + $rk;

    // Extract team details; fallback to team name if nickname is not available
    $team     = isset($item['team']) ? $item['team'] : [];
    $teamName = isset($team['nickname']) ? $team['nickname'] : (isset($team['name']) ? $team['name'] : 'N/A');

    // Get record summary and previous rank value
    $record   = isset($item['recordSummary']) ? $item['recordSummary'] : '';
    $previous = isset($item['previous']) ? $item['previous'] : '';

    // Get team abbreviation from API data
    $abbrev = isset($team['abbreviation']) ? $team['abbreviation'] : 'N/A';

    // Set current team name and apply renaming logic
    $current_team = $teamName;
    $current_team = strtoupper($current_team); // make caps 
    if ($current_team == "TEXAS A&M") {
        $current_team = "TAMU";
        $abbrev = "TAMU";
    }
    if ($current_team == "TENNESSEE") {
        $current_team = "TENN";
    }
    if ($current_team == "MICHIGAN ST") {
        $current_team = "MICH ST";
    }
    if ($current_team == "MARQUETTE") {
        $current_team = "MARQ";
    }
    if ($current_team == "FLORIDA") {
        $current_team = "FLORIDA";
    }
      if ($current_team == "FLORIDA ST") {
        $current_team = "FSU";
    }

    // Convert team hex color to RGB and split into components
    $hexColor = isset($team['color']) ? $team['color'] : '';
    if ($hexColor) {
        $rgb = hexToRGB($hexColor);
        $r   = $rgb['red'];
        $g   = $rgb['green'];
        $b   = $rgb['blue'];
    } else {
        $r = $g = $b = 'N/A';
    }

    // Build the UPDATE query statement using the new unique count and renaming values.
    $queryStatement = "UPDATE leader_board SET 
                team_rank='$rk',
                current_team='$current_team',
                winLossRecord='$record',
                Abbrev='$abbrev',
                Red='$r',
                Green='$g',
                Blue='$b'
              WHERE unique_count='$unique_count'";

    // Optionally, execute the query (uncomment the line below to update the DB)
    $conn->query($queryStatement);

    // Output the table row including the update query
    echo "<tr>
            <td>{$rk}</td>
            <td>{$current_team}</td>
            <td>{$record}</td>
            <td>{$previous}</td>
            <td>{$r}</td>
            <td>{$g}</td>
            <td>{$b}</td>
            <td>{$abbrev}</td>
            <td><pre>{$queryStatement}</pre></td>
          </tr>";
}

echo "    </table>
</body>
</html>";

// Close the database connection
$conn->close();
?>
