<?php
// Include your DB config file.
require_once '../../config.php'; // Include the configuration file

session_start();
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (!$conn) {
    die("Database connection error: " . mysqli_connect_error());
}

/**
 * Mapping of full driver names to their vehicle (car) numbers.
 */
$driverCarNumbers = array(
    "Ryan Blaney"           => 12,
    "William Byron"          => 24,
    "Austin Cindric"         => 2,
    "Tyler Reddick"          => 45,
    "Alex Bowman"            => 48,
    "Chris Buescher"         => 17,
    "Erik Jones"             => 43,
    "Jimmie Johnson"         => 84,
    "John H. Nemechek"       => 42,
    "Chase Briscoe"          => 19,
    "Chase Elliott"          => 9,
    "Ty Dillon"              => 10,
    "Daniel Suárez"          => 99,
    "Daniel Suarez"          => 99, // Alternative without accent.
    "Michael McDowell"       => 71,
    "Ricky Stenhouse Jr"     => 47,
    "Ricky Stenhouse Jr."    => 47, // Alternative with trailing period.
    "Ty Gibbs"               => 54,
    "Joey Logano"            => 22,
    "Riley Herbst"           => 35,
    "Corey LaJoie"           => 1,
    "Denny Hamlin"           => 11,
    "Brad Keselowski"        => 6,
    "Todd Gilliland"         => 34,
    "Bubba Wallace"          => 23,
    "Justin Haley"           => 7,
    "Austin Dillon"          => 3,
    "Kyle Larson"            => 5,
    "Cole Custer"            => 41,
    "Christopher Bell"       => 20,
    "Cody Ware"              => 51,
    "Noah Gragson"           => 4,
    "Ross Chastain"          => 1,
    "Carson Hocevar"         => 77,
    "AJ Allmendinger"        => 16,
    "Ryan Preece"            => 60,
    "Kyle Busch"             => 8,
    "Shane Van Gisbergen"    => 88,
    "Zane Smith"             => 38,
    "Josh Berry"             => 21,
    "Martin Truex Jr"        => 56,
);

// The URL of the ESPN NASCAR standings API
$apiUrl = "https://site.api.espn.com/apis/v2/sports/racing/nascar-premier/standings";

// Initialize a cURL session
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

// Execute the cURL request and store the response
$response = curl_exec($ch);
if (curl_errno($ch)) {
    echo 'cURL Error: ' . curl_error($ch);
    exit;
}
curl_close($ch);

// Decode the JSON response into an associative array
$data = json_decode($response, true);

// Attempt to extract the standings entries from the JSON structure.
if (isset($data['children'][0]['standings']['entries']) && is_array($data['children'][0]['standings']['entries'])) {
    $entries = $data['children'][0]['standings']['entries'];
} else {
    echo "Error: Unexpected data format. Could not find standings entries.";
    exit;
}

// Prepare the UPDATE statement.
// This query updates ranking, abbreviated name, points, and car_number based on the ranking.
$stmt = $conn->prepare("UPDATE nascar_leaderboard SET ranking = ?, name = ?, points = ?, car_number = ? WHERE ranking = ?");
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>NASCAR Standings</title>
    <style>
        /* Basic CSS styling for the table */
        body {
            font-family: Arial, sans-serif;
            background-color: #fafafa;
            margin: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
        table {
            border-collapse: collapse;
            margin: 0 auto;
            width: 90%;
            max-width: 600px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            background-color: #fff;
        }
        th, td {
            padding: 12px 15px;
            border: 1px solid #ddd;
            text-align: center;
        }
        th {
            background-color: #0073e6;
            color: #fff;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f3f3f3;
        }
    </style>
</head>
<body>
    <h1>NASCAR Standings - Top 25 Racers</h1>
    <table>
        <thead>
            <tr>
                <th>RK</th>
                <th>DRIVER</th>
                <th>CAR #</th>
                <th>POINTS</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Process only the top 25 entries.
            $counter = 0;
            foreach ($entries as $entry) {
                if ($counter >= 25) {
                    break;
                }
                $counter++;

                // Get the full driver name from the API.
                $fullDriverName = isset($entry['athlete']['displayName']) ? $entry['athlete']['displayName'] : 'N/A';

                // Look up the car number using the full name.
                $carNumber = isset($driverCarNumbers[$fullDriverName]) ? $driverCarNumbers[$fullDriverName] : 0;

                // Abbreviate the driver's name: first letter of first name, dot, then full last name.
                $parts = explode(" ", $fullDriverName);
                if (count($parts) >= 2) {
                    $abbreviatedName = substr($parts[0], 0, 1) . '.' . end($parts);
                } else {
                    $abbreviatedName = $fullDriverName;
                }
                
                // Hard-code the car number for "J.Nemechek" if needed.
                if ($abbreviatedName === "J.Nemechek") {
                    $carNumber = 42;
                }

                // Initialize default stats.
                $rank   = 0;
                $points = 0;

                // Extract statistics from the "stats" array.
                if (isset($entry['stats']) && is_array($entry['stats'])) {
                    foreach ($entry['stats'] as $stat) {
                        if (!isset($stat['name'])) {
                            continue;
                        }
                        $statName = strtolower($stat['name']);
                        switch ($statName) {
                            case 'rank':
                                $rank = isset($stat['value']) ? $stat['value'] : 0;
                                break;
                            case 'championshippts':
                                $points = isset($stat['value']) ? $stat['value'] : 0;
                                break;
                        }
                    }
                }

                // Update the database.
                // Bind the parameters as follows:
                // 1. ranking (integer)
                // 2. name (string) — abbreviated name
                // 3. points (integer)
                // 4. car_number (integer)
                // 5. ranking (integer) for the WHERE clause.
                $stmt->bind_param("isiii", $rank, $abbreviatedName, $points, $carNumber, $rank);
                if (!$stmt->execute()) {
                    echo "Database update failed for ranking {$rank}: " . $stmt->error;
                }

                // Display only the inserted data in the HTML table.
                echo "<tr>";
                echo "<td>" . htmlspecialchars($rank) . "</td>";
                echo "<td>" . htmlspecialchars($abbreviatedName) . "</td>";
                echo "<td>" . htmlspecialchars($carNumber) . "</td>";
                echo "<td>" . htmlspecialchars($points) . "</td>";
                echo "</tr>";
            }
            // Close the statement and connection.
            $stmt->close();
            mysqli_close($conn);
            ?>
        </tbody>
    </table>
</body>
</html>
