<?php

error_reporting(0);
// Include the configuration file
require_once '../../config.php';

// Initialize SQL database
session_start();
$conn = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);

// Check the database connection
if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

// API URL for WNBA standings
$url = 'https://site.api.espn.com/apis/v2/sports/basketball/wnba/standings';

// Initialize a CURL session
$ch = curl_init();

// Set CURL options
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Accept: application/json'
));

// Execute the CURL session and fetch the data
$response = curl_exec($ch);

// Close the CURL session
curl_close($ch);

// Decode the JSON response
$data = json_decode($response, true);

// Check if the response is not null
if ($data === null) {
    echo "Failed to decode JSON.\n";
    echo "Response:\n";
    echo $response;
    exit;
}

/*************** START OF HELPER FUNCTIONS ***************/

// Helper function to get a specific stat from an array
function get_stat_value($stats, $name) {
    foreach ($stats as $stat) {
        if ($stat['name'] === $name) {
            return $stat['value'];
        }
    }
    return null;
}

// Add leading zeros to a number (for RGB display)
function addZeros($rgb) {
    return str_pad($rgb, 3, '0', STR_PAD_LEFT);
}

/*************** END OF HELPER FUNCTIONS ***************/

/*
   Define the master list for team colors and abbreviations.
   (These arrays now include all teams you expect.)
*/
// Full names as keys
$teamColors = array(
    // Eastern Conference (6 teams)
    "ATLANTA DREAM"         => array(224, 58, 62),
    "CHICAGO SKY"           => array(135, 206, 235),
    "CONNECTICUT SUN"       => array(255, 103, 31),
    "INDIANA FEVER"         => array(194, 39, 45),
    "NEW YORK LIBERTY"      => array(0, 43, 92),
    "WASHINGTON MYSTICS"    => array(152, 0, 46),
    // Western Conference (7 teams)
    "DALLAS WINGS"          => array(0, 43, 92),
    "GOLDEN STATE VALKYRIES" => array(218, 165, 32),
    "LAS VEGAS ACES"        => array(255, 215, 0),
    "LOS ANGELES SPARKS"    => array(85, 37, 130),
    "MINNESOTA LYNX"        => array(0, 128, 128),
    "PHOENIX MERCURY"       => array(107, 63, 160),
    "SEATTLE STORM"         => array(0, 178, 169)
);

$teamAbbreviations = array(
    // Eastern Conference
    "ATLANTA DREAM"         => "ATL",
    "CHICAGO SKY"           => "CHI",
    "CONNECTICUT SUN"       => "CONN",
    "INDIANA FEVER"         => "IND",
    "NEW YORK LIBERTY"      => "NY",
    "WASHINGTON MYSTICS"    => "WSH",
    // Western Conference
    "DALLAS WINGS"          => "DAL",
    "GOLDEN STATE VALKYRIES" => "GSV",
    "LAS VEGAS ACES"        => "LV",
    "LOS ANGELES SPARKS"    => "LA",
    "MINNESOTA LYNX"        => "MIN",
    "PHOENIX MERCURY"       => "PHX",
    "SEATTLE STORM"         => "SEA"
);

/*
   Rebuild lookup arrays keyed by the team nickname.
   We extract the nickname as the last word of the full team name.
*/
$team_colors = array();
$abbrByNickname = array();
foreach ($teamColors as $fullName => $colors) {
    $parts = explode(" ", strtoupper($fullName));
    $nickname = array_pop($parts);
    $team_colors[$nickname] = $colors;
}
foreach ($teamAbbreviations as $fullName => $abbr) {
    $parts = explode(" ", strtoupper($fullName));
    $nickname = array_pop($parts);
    $abbrByNickname[$nickname] = $abbr;
}

/*
   Build a lookup of API team data by nickname.
   (If a team isnt found in the API, it will be missing from this array.)
*/
$apiTeams = array();
if (isset($data['children'])) {
    foreach ($data['children'] as $conferenceData) {
        // Determine conference from the parents name
        $conference = (strpos($conferenceData['name'], 'Eastern') !== false) ? 'EASTERN' : 'WESTERN';
        if (isset($conferenceData['standings']) && isset($conferenceData['standings']['entries'])) {
            foreach ($conferenceData['standings']['entries'] as $entry) {
                $full_team_name = $entry['team']['displayName'];
                $parts = explode(" ", strtoupper($full_team_name));
                $nickname = array_pop($parts);
                $wins = get_stat_value($entry['stats'], 'wins');
                $losses = get_stat_value($entry['stats'], 'losses');
                $record = "$wins-$losses";
                $ranking = get_stat_value($entry['stats'], 'playoffSeed');
                if ($ranking === null) {
                    $ranking = get_stat_value($entry['stats'], 'rank');
                }
                $apiTeams[$nickname] = array(
                    'wins'       => $wins,
                    'losses'     => $losses,
                    'record'     => $record,
                    'ranking'    => $ranking,
                    'conference' => $conference,
                    'abbrev'     => $entry['team']['abbreviation']
                );
            }
        }
    }
}

/*
   For conference defaults when API data is missing,
   we use our knowledge of which nicknames belong where.
*/
$easternList = array('DREAM', 'SKY', 'SUN', 'FEVER', 'LIBERTY', 'MYSTICS');
$westernList = array('WINGS', 'VALKYRIES', 'ACES', 'SPARKS', 'LYNX', 'MERCURY', 'STORM');

/*
   Loop through the master team list (13 teams) and update the database.
   If API data exists for a team, use it; otherwise, use default values.
*/
echo "<table border='1'>";
echo "<tr>
        <th>Team Nickname</th>
        <th>Win-Loss Record</th>
        <th>Red</th>
        <th>Green</th>
        <th>Blue</th>
        <th>SQL Query</th>
        <th>Status</th>
      </tr>";

foreach ($team_colors as $nickname => $colors) {
    $red   = $colors[0];
    $green = $colors[1];
    $blue  = $colors[2];
    $abbr  = isset($abbrByNickname[$nickname]) ? $abbrByNickname[$nickname] : '';
    
    if (isset($apiTeams[$nickname])) {
        // Use API data if available
        $record     = $apiTeams[$nickname]['record'];
        $conference = $apiTeams[$nickname]['conference'];
        $ranking    = $apiTeams[$nickname]['ranking'];
        // If ranking is available, use it in the WHERE clause; otherwise, use the abbreviation.
        if ($ranking) {
            $whereClause = "WHERE team_rank = $ranking AND league = 'WNBA' AND division = '$conference'";
        } else {
            $whereClause = "WHERE league = 'WNBA' AND Abbrev = '$abbr'";
        }
    } else {
        // Defaults if API data is missing
        $record = "0-0";
        $conference = in_array($nickname, $easternList) ? 'EASTERN' : 'WESTERN';
        $whereClause = "WHERE league = 'WNBA' AND Abbrev = '$abbr'";
    }
    
    $query = "UPDATE leader_board SET 
        current_team = '$nickname', 
        winLossRecord = '$record', 
        Abbrev = '$abbr',
        Red = $red, 
        Green = $green, 
        Blue = $blue 
        $whereClause;";
    
    // Execute query and output the result
    $status = mysqli_query($conn, $query) ? "Query executed successfully." : "Error: " . mysqli_error($conn);
    
    echo "<tr>";
    echo "<td>$nickname</td>";
    echo "<td>$record</td>";
    echo "<td>" . addZeros($red) . "</td>";
    echo "<td>" . addZeros($green) . "</td>";
    echo "<td>" . addZeros($blue) . "</td>";
    echo "<td>$query</td>";
    echo "<td>$status</td>";
    echo "</tr>";
}
echo "</table>";

// Close the database connection
mysqli_close($conn);
?>
