<?php

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database credentials
require_once '../config.php';

// Number of rows to update per run
$limit = 50;

// Path to the file that stores the current offset and last update time
$offsetFile = '/home/gscroll1/public_html/updateDB/crypto_offset_file.json';

// Connect to the database
$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (!$con) {
    error_log("Connection failed: " . mysqli_connect_error(), 3, 'error_log.log');
    die("Connection failed: " . mysqli_connect_error());
}

// Get the total number of rows in the table
$table = 'crypto_database';
$total_rows_query = "SELECT COUNT(*) as total FROM $table";
$total_rows_result = mysqli_query($con, $total_rows_query);

if ($total_rows_result) {
    $row = mysqli_fetch_assoc($total_rows_result);
    $total_rows = $row['total'];
    mysqli_free_result($total_rows_result);
} else {
    error_log("Failed to retrieve total row count: " . mysqli_error($con), 3, 'error_log.log');
    die("Failed to retrieve total row count.");
}

// Initialize or get the current offset from the JSON file
if (file_exists($offsetFile)) {
    $file_data = json_decode(file_get_contents($offsetFile), true);
    $offset = $file_data['offset'] ?? 0;
} else {
    $offset = 0;
}

// Fetch the next set of CMC_IDs
$query = "SELECT CMC_ID FROM $table ORDER BY CMC_ID LIMIT $offset, $limit";
$result = mysqli_query($con, $query);

if (!$result) {
    error_log("Query failed: " . mysqli_error($con), 3, 'error_log.log');
    die("Query failed: " . mysqli_error($con));
}

// Collect CMC_IDs into an array for API call
$crypto_array = [];
while ($row = mysqli_fetch_assoc($result)) {
    $crypto_array[] = $row['CMC_ID'];
}
mysqli_free_result($result);

// Check if there are rows to process
if (empty($crypto_array)) {
    echo "No more rows to update.";
    mysqli_close($con);
    exit();
}

// Prepare the API request
$cryptostring = implode(',', $crypto_array);
$api_key = '1cba9d17-dc4c-4a5a-a132-af2aa15ec989'; // Replace with your CoinMarketCap API key
$api_call = "https://pro-api.coinmarketcap.com/v1/cryptocurrency/quotes/latest?CMC_PRO_API_KEY=$api_key&id=" . $cryptostring;

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $api_call,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
]);
$result = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    error_log("cURL Error #:" . $err, 3, 'error_log.log');
    echo "cURL Error #:" . $err;
    exit();
}

// Decode JSON response
$data = json_decode($result, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    error_log("JSON decode error: " . json_last_error_msg(), 3, 'error_log.log');
    echo "JSON decode error: " . json_last_error_msg();
    exit();
}

if (!isset($data['data'])) {
    error_log("Invalid API response: " . $result, 3, 'error_log.log');
    echo "Invalid API response.";
    exit();
}

// Update the database with the fetched data
foreach ($data['data'] as $id => $crypto) {
    $price = $crypto['quote']['USD']['price'];
    $percentChange24h = $crypto['quote']['USD']['percent_change_24h'];
    $update_query = "UPDATE $table SET usd='$price', usd_24h_change='$percentChange24h' WHERE CMC_ID='$id'";
    $update_result = mysqli_query($con, $update_query);

    if (!$update_result) {
        error_log("Failed to update CMC_ID $id: " . mysqli_error($con), 3, 'error_log.log');
    }
}

// Close the database connection
mysqli_close($con);

// Calculate the new offset for the next run
$new_offset = $offset + $limit;
if ($new_offset >= $total_rows) {
    $new_offset = 0; // Reset offset if end is reached
}

// Get the current time in Eastern Time
$date = new DateTime('now', new DateTimeZone('America/New_York'));
$last_update = $date->format('Y-m-d H:i:s');

// Save the new offset and last update time to the JSON file
$file_data = [
    'offset' => $new_offset,
    'last_update' => $last_update
];
file_put_contents($offsetFile, json_encode($file_data, JSON_PRETTY_PRINT));

?>

