<?php
session_start();

// Include MeekroDB and configuration files
require_once '../meekrodb.2.4.class.php';
require_once '../config.php'; // Include the common configuration

// Set database credentials using config file
DB::$user = $username_gscroll;
DB::$password = $password_gscroll;
DB::$dbName = $database_gscroll;
DB::$host = $host_gscroll; // Add this if the host is not localhost

// Initialize SQL connection using config file credentials
$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (!$con) {
    error_log("Connection failed: " . mysqli_connect_error(), 3, 'stock_error_log.log');
    die("Connection failed: " . mysqli_connect_error());
}

// Utility functions
function strpos_nth($haystack, $needle, $occurrence) {
    if (filter_var($occurrence, FILTER_VALIDATE_INT, ["options" => ["min_range" => 1, "max_range" => strlen($haystack)]]) === false) {
        return false;
    }

    $position = -1;
    $loop = 0;
    while ($position !== false && ++$loop <= $occurrence) {
        $position = strpos($haystack, $needle, $position + 1);
    }

    return $position;
}

function strposX($haystack, $needle, $number = 0) {
    return strpos($haystack, $needle, $number > 1 ? strposX($haystack, $needle, $number - 1) + strlen($needle) : 0);
}

// Initialize arrays
$stock_array = [];
$spit_out = [];

// Fetch stock tickers
$stock_table = 'stock_list';
$query = "SELECT TICKER FROM $stock_table WHERE Name = 'Forex' ORDER BY Ticker";
$result = DB::query($query);

if ($result) {
    foreach ($result as $row) {
        $stock_array[] = $row['TICKER'];
    }
    $success_count = count($stock_array);
    echo "$success_count records fetched successfully.<br>";
    error_log("$success_count records fetched successfully from $stock_table.", 3, 'stock_log.log');
} else {
    error_log("Failed to fetch records from $stock_table: " . DB::error(), 3, 'stock_error_log.log');
    die("Failed to fetch records from the database.");
}

// Build the stock string for API calls
$stockstring = implode(',', array_map(function($item) {
    return str_replace("-", "/", $item);
}, $stock_array));

// Prepare the API key
$api_key = '8e26e14172134472b2197968bcab2a47';

// Loop through stock_array and call the API for each ticker
foreach ($stock_array as $i => $ticker) {
    $ticker = trim($ticker);
    $api_call = "https://api.twelvedata.com/time_series?apikey=$api_key&symbol=$ticker&interval=1day&outputsize=2&format=json&dp=5&type=none";

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $api_call,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => [
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36"
        ],
    ]);

    $result = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        error_log("cURL Error for $ticker: " . $err, 3, 'stock_error_log.log');
        echo "cURL Error for $ticker: " . $err . "<br>";
        continue;
    }

    $resultStockString = $result;

    // Parse API result to get symbol, latest close, and yesterday's close
    $start_suffix = '"symbol":"';
    $end_suffix = ',"interval"';
    $index_start = strposX($resultStockString, $start_suffix, 1) + strlen($start_suffix);
    $index_end = strposX($resultStockString, $end_suffix, 1) - $index_start - 1;
    $symbol = substr($resultStockString, $index_start, $index_end);
    $symbol = str_replace("/", "-", $symbol);

    // Replace precious metals codes with human-readable symbols
    $preciousMetals = [
        "XAU-USD" => "GOLD",
        "XAG-USD" => "SILVER",
        "WTI-USD" => "CRUDE-OIL",
        "XPT-USD" => "PLATINUM",
        "XBR-USD" => "BRENT"
    ];
    foreach ($preciousMetals as $key => $value) {
        $symbol = str_replace($key, $value, $symbol);
    }

    $start_suffix = ',"close":';
    $end_suffix = '"},{"d';
    $index_start = strposX($resultStockString, $start_suffix, 1) + strlen($start_suffix) + 1;
    $index_end = strposX($resultStockString, $end_suffix, 1) - $index_start - 1;
    $latest_close = substr($resultStockString, $index_start, $index_end);

    if (strlen($latest_close) > 12) {
        $pos = strpos($latest_close, '"');
        $latest_close = substr($latest_close, 0, $pos);
    }

    $start_suffix = ',"close":';
    $end_suffix = '"}],"s';
    $index_start = strposX($resultStockString, $start_suffix, 2) + strlen($start_suffix) + 1;
    $index_end = strposX($resultStockString, $end_suffix, 1) - $index_start - 1;
    $yesterdayClosePrice = substr($resultStockString, $index_start, $index_end);

    if (strlen($yesterdayClosePrice) > 12) {
        $pos = strpos($yesterdayClosePrice, '"');
        $yesterdayClosePrice = substr($yesterdayClosePrice, 0, $pos);
    }

    $percentDiff = (($latest_close - $yesterdayClosePrice) / $yesterdayClosePrice) * 100.0;

    // Update SQL database with the correct price and % change
    $query = "UPDATE `$stock_table` SET `Price`='$latest_close', `% Change`='$percentDiff' WHERE `Ticker`='$symbol'";
    $query_run = mysqli_query($con, $query);

    if ($query_run) {
        error_log("Successfully updated $symbol with latest close $latest_close and % change $percentDiff.", 3, 'stock_log.log');
    } else {
        error_log("Failed to update $symbol: " . mysqli_error($con), 3, 'stock_error_log.log');
    }
}

// Close the database connection
mysqli_close($con);
?>
