<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

$x = isset($_GET['value_for_loop']) ? $_GET['value_for_loop'] : 0;
$x = $x + 1;
$debug = false; // Set to false to disable debug output

require_once '../config.php';
require_once '../meekrodb.2.4.class.php';

DB::$user = $username_gscroll;
DB::$password = $password_gscroll;
DB::$dbName = $database_gscroll;
DB::$host = $host_gscroll;

$stock_table = 'stock_list';

// STEP 1: Retrieve ticker symbols from the database.
$query = "SELECT TICKER FROM $stock_table ORDER BY Ticker LIMIT $x,50";
$result = DB::query($query);
$allSymbols = array();
foreach ($result as $row) {
    $allSymbols[] = $row['TICKER'];
}
// Remove any ticker containing a hyphen.
foreach ($allSymbols as $key => $value) {
    if (strpos($value, "-") !== false) {
        unset($allSymbols[$key]);
    }
}
$allSymbols = array_values($allSymbols);

// STEP 2: Separate major indices from other tickers.
// Added "SPX" to the list so that your S&P ticker is treated as a major index.
$majorIndices = array("DJI", "IXIC", "GSPC", "SPX");
$nonIndexSymbols = array();
$indicesSymbols = array();
foreach ($allSymbols as $sym) {
    // Normalize by removing any leading caret.
    $normalized = ltrim($sym, '^');
    if (in_array($normalized, $majorIndices)) {
        $indicesSymbols[] = $sym; // keep original form
    } else {
        $nonIndexSymbols[] = $sym;
    }
}

// STEP 3: For non-index symbols, perform replacements (e.g. GOLD → XAU/USD).
foreach ($nonIndexSymbols as &$sym) {
    $sym = str_replace("GOLD", "XAU/USD", $sym);
    $sym = str_replace("SILVER", "XAG/USD", $sym);
    $sym = str_replace("CRUDE-OIL", "WTI/USD", $sym);
    $sym = str_replace("PLATINUM", "XPT/USD", $sym);
    $sym = str_replace("BRENT", "XBR/USD", $sym);
    // Replace any remaining hyphen with a forward slash.
    $sym = str_replace("-", "/", $sym);
}
unset($sym);
$stockstring = implode(",", $nonIndexSymbols);

// STEP 4: Call Twelve Data for non-index symbols (if any).
$twelveDataResults = array();
if (!empty($stockstring)) {
    $api_key = '8e26e14172134472b2197968bcab2a47';
    $api_call = "https://api.twelvedata.com/time_series?apikey={$api_key}&symbol={$stockstring}&interval=1day&outputsize=2&format=json&dp=5";
    
    // Optional: clean the URL.
    function cleanUrl($url) {
        preg_match("/symbol=([^&]*)/", $url, $matches);
        if (!isset($matches[1])) {
            return $url;
        }
        $cleaned = str_replace(" ", "", $matches[1]);
        while(strpos($cleaned, ',,') !== false) {
            $cleaned = str_replace(',,', ',', $cleaned);
        }
        return str_replace($matches[1], $cleaned, $url);
    }
    $api_call = cleanUrl($api_call);
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $api_call,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => [
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)"
        ],
    ]);
    $result = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) {
        echo "cURL Error: " . $err;
        exit;
    }
    $data = json_decode($result, true);
    if (isset($data["data"])) {
        $twelveDataResults = $data["data"];
    } else {
        // In case the result is an associative array keyed by symbol.
        if (!empty($data) && !is_numeric(key($data))) {
            foreach ($data as $symKey => $item) {
                if (!isset($item["meta"]["symbol"])) {
                    $item["meta"]["symbol"] = $symKey;
                }
                $twelveDataResults[] = $item;
            }
        } else {
            $twelveDataResults = [$data];
        }
    }
}

// STEP 5: Open SQL connection.
$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
$table = 'stock_list';

// STEP 6: Output HTML table header.
echo "<style>
table {
    border-collapse: separate;
    border-spacing: 0;
    width: 80%;
    font-family: Arial, sans-serif;
    margin: 20px auto;
    box-shadow: 0px 0px 20px rgba(0,0,0,0.15);
    border-radius: 10px;
    overflow: hidden;
}
th, td {
    padding: 15px 20px;
    text-align: center;
    border: 1px solid black;
}
th {
    background: linear-gradient(to bottom, #4CAF50, #388E3C);
    color: white;
    box-shadow: 0px 2px 10px rgba(0,0,0,0.15);
}
tr:nth-child(even) {
    background-color: #f2f2f2;
}
tr:not(:first-child):hover {
    background-color: #ddd;
    transition: background-color 0.2s;
}
.table-title {
    font-size: 24px;
    font-weight: bold;
    text-align: center;
    margin-top: 40px;
}
.debug {
    background-color: #ffffcc;
    font-size: 12px;
}
</style>";
echo "<div class='table-title'>UPDATE STOCK PRICES</div>";
echo "<table><tr><th>Ticker</th><th>Price</th><th>% Change</th></tr>";

// STEP 7: Process each non-index symbol.
foreach ($twelveDataResults as $item) {
    if (!isset($item["meta"]) || !isset($item["meta"]["symbol"])) {
        if ($debug) {
            echo "<tr class='debug'><td colspan='3'>DEBUG: meta or symbol not set for item: " . htmlspecialchars(json_encode($item)) . "</td></tr>";
        }
        continue;
    }
    $symbol = $item["meta"]["symbol"];
    // Convert API symbols for precious metals to your desired names.
    $precious = array(
        "XAU/USD" => "GOLD",
        "XAG/USD" => "SILVER",
        "WTI/USD" => "CRUDE-OIL",
        "XPT/USD" => "PLATINUM",
        "XBR/USD" => "BRENT"
    );
    if (isset($precious[$symbol])) {
        $symbol = $precious[$symbol];
    }
    if ($debug) {
        echo "<tr class='debug'><td colspan='3'>DEBUG: Extracted symbol = " . htmlspecialchars($symbol) . "</td></tr>";
    }
    // If Twelve Data returns an error or insufficient data, use Yahoo Finance fallback.
    $useYahoo = false;
    if ((isset($item["status"]) && $item["status"] == "error") ||
        !isset($item["values"][0]["close"]) || !isset($item["values"][1]["close"])) {
        if ($debug) {
            echo "<tr class='debug'><td colspan='3'>DEBUG: Twelve Data error or insufficient data for $symbol. Falling back to Yahoo Finance.</td></tr>";
        }
        $useYahoo = true;
    }
    if ($useYahoo) {
        // For fallback, if the symbol is a major index then add caret; otherwise, use as is.
        if (in_array(ltrim($symbol, '^'), $majorIndices)) {
            $symYahoo = "^" . ltrim($symbol, '^');
        } else {
            $symYahoo = $symbol;
        }
        $encodedSym = urlencode($symYahoo);
        $yahoo_url = "https://query1.finance.yahoo.com/v8/finance/chart/" . $encodedSym;
        if ($debug) {
            echo "<tr class='debug'><td colspan='3'>DEBUG: Yahoo URL for $symbol: " . htmlspecialchars($yahoo_url) . "</td></tr>";
        }
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $yahoo_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)"
            ],
        ]);
        $yahoo_result = curl_exec($ch);
        $yahoo_err = curl_error($ch);
        curl_close($ch);
        if ($yahoo_err) {
            if ($debug) echo "<tr class='debug'><td colspan='3'>DEBUG: Yahoo cURL error for $symbol: $yahoo_err</td></tr>";
            continue;
        }
        $yahoo_data = json_decode($yahoo_result, true);
        if (isset($yahoo_data['chart']['result'][0]['meta'])) {
            $meta = $yahoo_data['chart']['result'][0]['meta'];
            $latest_close = $meta['regularMarketPrice'];
            $prev_close = $meta['previousClose'];
            $percentDiff = ($prev_close != 0) ? (($latest_close - $prev_close) / $prev_close) * 100 : 0;
            if ($debug) {
                echo "<tr class='debug'><td colspan='3'>DEBUG: Yahoo meta found for $symbol</td></tr>";
            }
        } else {
            if ($debug) {
                echo "<tr class='debug'><td colspan='3'>DEBUG: Yahoo meta not found for $symbol</td></tr>";
            }
            continue;
        }
    } else {
        $latest_close = floatval($item["values"][0]["close"]);
        $prev_close = floatval($item["values"][1]["close"]);
        $percentDiff = ($prev_close != 0) ? (($latest_close - $prev_close) / $prev_close) * 100 : 0;
    }
    
    // Update the database.
    $query = "UPDATE `$table` SET `Price`='$latest_close', `% Change`='$percentDiff' WHERE `Ticker`='" . mysqli_real_escape_string($con, $symbol) . "'";
    mysqli_query($con, $query);
    
    // Output table row.
    echo "<tr>";
    echo "<td>" . htmlspecialchars($symbol) . "</td>";
    echo "<td>" . htmlspecialchars($latest_close) . "</td>";
    echo "<td>" . number_format($percentDiff, 2) . "%</td>";
    echo "</tr>";
}

// STEP 8: Process major indices via Yahoo Finance.
$majorMapping = array(
    "DJI"  => "^DJI",
    "IXIC" => "^IXIC",
    "GSPC" => "^GSPC",
    "SPX"  => "^GSPC" // Map SPX to Yahoo’s symbol for S&P 500.
);
foreach ($indicesSymbols as $sym) {
    // Determine Yahoo symbol using mapping for major indices.
    if (isset($majorMapping[$sym])) {
        $symYahoo = $majorMapping[$sym];
    } else {
        if ($sym[0] !== '^') {
            $symYahoo = "^" . $sym;
        } else {
            $symYahoo = $sym;
        }
    }
    $encodedSym = urlencode($symYahoo);
    $yahoo_url = "https://query1.finance.yahoo.com/v8/finance/chart/" . $encodedSym;
    if ($debug) echo "<tr class='debug'><td colspan='3'>DEBUG: Yahoo URL for major index $sym: " . htmlspecialchars($yahoo_url) . "</td></tr>";
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $yahoo_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => [
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)"
        ],
    ]);
    $yahoo_result = curl_exec($ch);
    $yahoo_err = curl_error($ch);
    curl_close($ch);
    if ($debug) echo "<tr class='debug'><td colspan='3'>DEBUG: Yahoo response (first 200 chars) for $sym: " . htmlspecialchars(substr($yahoo_result, 0, 200)) . "</td></tr>";
    if ($yahoo_err) {
        if ($debug) echo "<tr class='debug'><td colspan='3'>DEBUG: Yahoo cURL error for major index $sym: $yahoo_err</td></tr>";
        continue;
    }
    $yahoo_data = json_decode($yahoo_result, true);
    if (isset($yahoo_data['chart']['result'][0]['meta'])) {
        $meta = $yahoo_data['chart']['result'][0]['meta'];
        $latest_close = $meta['regularMarketPrice'];
        $prev_close = $meta['previousClose'];
        $percentDiff = ($prev_close != 0) ? (($latest_close - $prev_close) / $prev_close) * 100 : 0;
        if ($debug) echo "<tr class='debug'><td colspan='3'>DEBUG: Yahoo meta found for major index $sym</td></tr>";
    } else {
        if ($debug) echo "<tr class='debug'><td colspan='3'>DEBUG: Yahoo meta NOT found for major index $sym</td></tr>";
        continue;
    }
    $query = "UPDATE `$table` SET `Price`='$latest_close', `% Change`='$percentDiff' WHERE `Ticker`='" . mysqli_real_escape_string($con, $sym) . "'";
    mysqli_query($con, $query);
    
    echo "<tr>";
    echo "<td>" . htmlspecialchars($sym) . "</td>";
    echo "<td>" . htmlspecialchars($latest_close) . "</td>";
    echo "<td>" . number_format($percentDiff, 2) . "%</td>";
    echo "</tr>";
}

echo "</table>";
?>
