<?php

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database credentials
require_once '../config.php';
require_once '../meekrodb.2.4.class.php'; // Include MeekroDB

// MeekroDB credentials
DB::$user = $username_gscroll;
DB::$password = $password_gscroll;
DB::$dbName = $database_gscroll;

// Number of rows to update per run
$limit = 50;

// Path to the file that stores the current offset and last update time
$offsetFile = '/home/gscroll1/public_html/updateDB/stock_offset_file.json';

// Connect to the database
$con = mysqli_connect($host_gscroll, $username_gscroll, $password_gscroll, $database_gscroll);
if (!$con) {
    error_log("Connection failed: " . mysqli_connect_error(), 3, 'error_log.log');
    die("Connection failed: " . mysqli_connect_error());
}

// Get the total number of rows in the table
$stock_table = 'stock_list';
$total_rows_query = "SELECT COUNT(*) as total FROM $stock_table";
$total_rows_result = mysqli_query($con, $total_rows_query);

if ($total_rows_result) {
    $row = mysqli_fetch_assoc($total_rows_result);
    $total_rows = $row['total'];
    mysqli_free_result($total_rows_result);
} else {
    error_log("Failed to retrieve total row count: " . mysqli_error($con), 3, 'error_log.log');
    die("Failed to retrieve total row count.");
}

// Initialize or get the current offset from the JSON file
if (file_exists($offsetFile)) {
    $file_data = json_decode(file_get_contents($offsetFile), true);
    $offset = $file_data['offset'] ?? 0;
} else {
    $offset = 0;
}

// Fetch the next set of TICKERs
$query = "SELECT TICKER FROM $stock_table ORDER BY Ticker LIMIT $offset, $limit";
$result = DB::query($query);

// Collect TICKERs into an array for API call
$stock_array = [];
foreach ($result as $row) {
    if (strpos($row['TICKER'], "-") === false) {
        $stock_array[] = $row['TICKER'];
    }
}

// Prepare the API request
$stockstring = implode(',', $stock_array);
$api_key = '8e26e14172134472b2197968bcab2a47'; // Replace with your Twelve Data API key
$api_call = "https://api.twelvedata.com/time_series?apikey=$api_key&symbol=$stockstring&interval=1day&outputsize=2&format=json&dp=5";

function cleanUrl($url) {
    // Clean up URL symbols parameter
    preg_match("/symbol=([^&]*)/", $url, $matches);
    if (!isset($matches[1])) return $url;
    $cleanedSymbols = str_replace(" ", "", $matches[1]);
    while (strpos($cleanedSymbols, ',,') !== false) {
        $cleanedSymbols = str_replace(',,', ',', $cleanedSymbols);
    }
    return str_replace($matches[1], $cleanedSymbols, $url);
}

$api_call = cleanUrl($api_call);

// Execute the API call
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $api_call,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => [
        "User-Agent: Mozilla/5.0"
    ],
]);

$result = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    error_log("cURL Error #:" . $err, 3, 'error_log.log');
    echo "cURL Error #:" . $err;
    exit();
}

// Decode JSON response
$data = json_decode($result, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    error_log("JSON decode error: " . json_last_error_msg(), 3, 'error_log.log');
    echo "JSON decode error: " . json_last_error_msg();
    exit();
}

// Update the database with the fetched data
foreach ($data as $symbol => $info) {
    if (isset($info['values']) && count($info['values']) >= 2) {
        $latest_close = $info['values'][0]['close'];
        $yesterday_close = $info['values'][1]['close'];
        $percentDiff = (($latest_close - $yesterday_close) / $yesterday_close) * 100.0;
        
        $query = "UPDATE $stock_table SET `Price`='$latest_close', `% Change`='$percentDiff' WHERE `Ticker`='$symbol'";
        $query_run = mysqli_query($con, $query);

        if (!$query_run) {
            error_log("Failed to update Ticker $symbol: " . mysqli_error($con), 3, 'error_log.log');
        }
    }
}

// Close the database connection
mysqli_close($con);

// Calculate the new offset for the next run
$new_offset = $offset + $limit;
if ($new_offset >= $total_rows) {
    $new_offset = 0; // Reset offset if end is reached
}

// Get the current time in Eastern Time
$date = new DateTime('now', new DateTimeZone('America/New_York'));
$last_update = $date->format('Y-m-d H:i:s');

// Save the new offset and last update time to the JSON file
$file_data = [
    'offset' => $new_offset,
    'last_update' => $last_update
];
file_put_contents($offsetFile, json_encode($file_data, JSON_PRETTY_PRINT));

?>

